/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public class ThumbnailDocumentConverter
implements Converter {
    public static final String THUMBNAIL_COMMAND = "toThumbnail";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        try {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            CommandAvailability commandAvailability = cles.getCommandAvailability(THUMBNAIL_COMMAND);
            if (!commandAvailability.isAvailable()) {
                return null;
            }
            Blob blob = blobHolder.getBlob();
            if (blob == null) {
                return new SimpleCachableBlobHolder((Blob)null);
            }
            Blob targetBlob = Blobs.createBlobWithExtension((String)".png");
            targetBlob.setMimeType("image/png");
            try (CloseableFile source = blob.getCloseableFile();){
                CmdParameters params = cles.getDefaultCmdParameters();
                String size = parameters == null ? "1000x1000" : (String)((Object)parameters.getOrDefault("size", (Serializable)((Object)"1000x1000")));
                params.addNamedParameter("size", size);
                params.addNamedParameter("inputFilePath", source.getFile());
                params.addNamedParameter("outputFilePath", targetBlob.getFile());
                ExecResult res = cles.execCommand(THUMBNAIL_COMMAND, params);
                if (!res.isSuccessful()) {
                    throw res.getError();
                }
            }
            return new SimpleCachableBlobHolder(targetBlob);
        }
        catch (IOException | NuxeoException | CommandException | CommandNotAvailable e) {
            throw new ConversionException("Thumbnail conversion failed", e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

