/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.work;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;

public class ThumbnailRecomputeWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    protected static final int BATCH_SIZE = 10;
    protected String nxqlQuery;

    public ThumbnailRecomputeWork(String repositoryName, String nxqlQuery) {
        this.repositoryName = repositoryName;
        this.nxqlQuery = nxqlQuery;
    }

    public String getTitle() {
        return "Thumbnails Recomputation";
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModelList docs = this.session.query(this.nxqlQuery);
        long docsUpdated = 0L;
        this.setStatus("Generating thumbnails");
        for (DocumentModel doc : docs) {
            BlobHolder blobHolder;
            if (!doc.hasFacet("Thumbnail") || (blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob() == null) continue;
            blobHolder.setBlob(blobHolder.getBlob());
            this.session.saveDocument(doc);
            if (++docsUpdated % 10L != 0L) continue;
            this.commitOrRollbackTransaction();
            this.startTransaction();
        }
        this.setStatus("Done");
    }
}

