/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.suggesters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.platform.suggestbox.service.DocumentSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DocumentLookupSuggester
implements Suggester {
    protected List<String> highlights = null;
    protected String providerName = "DEFAULT_DOCUMENT_SUGGESTION";
    protected SuggesterDescriptor descriptor;

    @Override
    public void initWithParameters(SuggesterDescriptor descriptor) {
        String highlightFields;
        this.descriptor = descriptor;
        String providerName = descriptor.getParameters().get("providerName");
        if (providerName != null) {
            this.providerName = providerName;
        }
        if ((highlightFields = descriptor.getParameters().get("highlightFields")) != null && !StringUtils.isBlank((CharSequence)highlightFields)) {
            String[] fields = highlightFields.split(",");
            this.highlights = Arrays.asList(fields);
        }
    }

    @Override
    public List<Suggestion> suggest(String userInput, SuggestionContext context) throws SuggestionException {
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)context.session);
        userInput = NXQLQueryBuilder.sanitizeFulltextInput((String)userInput);
        if (userInput.trim().isEmpty()) {
            return Collections.emptyList();
        }
        if (!userInput.endsWith(" ")) {
            userInput = userInput + "*";
        }
        try {
            ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
            PageProvider pp = ppService.getPageProvider(this.providerName, null, null, null, null, props, this.highlights, null, new Object[]{userInput});
            for (DocumentModel doc : pp.getCurrentPage()) {
                suggestions.add(DocumentSuggestion.fromDocumentModel(doc));
            }
            return suggestions;
        }
        catch (QueryParseException e) {
            throw new SuggestionException(String.format("Suggester '%s' failed to perform query with input '%s'", this.descriptor.getName(), userInput), e);
        }
    }
}

