/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.lazy.AbstractLazyCachableRenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractRenditionBuilderWork
extends TransientStoreWork {
    private static final long serialVersionUID = 1L;
    protected final String key;
    protected final DocumentRef docRef;
    protected final String renditionName;
    protected static Log log = LogFactory.getLog(AbstractRenditionBuilderWork.class);
    public static final String CATEGORY = "renditionBuilder";

    public AbstractRenditionBuilderWork(String key, DocumentModel doc, RenditionDefinition def) {
        this.key = key;
        this.docRef = doc.getRef();
        this.repositoryName = doc.getRepositoryName();
        this.renditionName = def.getName();
        this.setOriginatingUsername(doc.getCoreSession().getPrincipal().getName());
        this.id = this.buildId(doc, def);
    }

    protected String buildId(DocumentModel doc, RenditionDefinition def) {
        StringBuilder sb = new StringBuilder("rendition:");
        sb.append(doc.getId());
        String variant = def.getProvider().getVariant(doc, def);
        if (variant != null) {
            sb.append("::");
            sb.append(variant);
        }
        sb.append("::");
        sb.append(def.getName());
        return sb.toString();
    }

    public String getTitle() {
        return "Lazy Rendition for " + this.renditionName + " on " + this.docRef.toString() + " on behalf of " + this.originatingUsername;
    }

    public String getCategory() {
        return CATEGORY;
    }

    protected String getTransientStoreName() {
        return "LazyRenditionCache";
    }

    public boolean isIdempotent() {
        return false;
    }

    public boolean isCoalescing() {
        return true;
    }

    public void work() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Starting %s work with id %s for transient store key %s and document %s.", ((Object)((Object)this)).getClass().getSimpleName(), this.id, this.key, this.docRef));
        }
        this.openUserSession();
        DocumentModel doc = this.session.getDocument(this.docRef);
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition def = rs.getAvailableRenditionDefinition(doc, this.renditionName);
        log.debug((Object)"Starting rendition computation.");
        List<Blob> blobs = this.doComputeRendition(this.session, doc, def);
        this.updateAndCompleteStoreEntry(this.getSourceDocumentModificationDate(doc), blobs);
    }

    public void cleanUp(boolean ok, Exception e) {
        if (ok) {
            super.cleanUp(ok, e);
            return;
        }
        DocumentModel doc = this.session.getDocument(this.docRef);
        String sourceDocumentModificationDate = this.getSourceDocumentModificationDate(doc);
        super.cleanUp(ok, e);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        StringBlob emptyBlob = new StringBlob("");
        emptyBlob.setFilename("error");
        emptyBlob.setMimeType("text/plain;error=true");
        blobs.add((Blob)emptyBlob);
        this.updateAndCompleteStoreEntry(sourceDocumentModificationDate, blobs);
    }

    void updateAndCompleteStoreEntry(String sourceDocumentModificationDate, List<Blob> blobs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Updating and completing transient store entry with key %s (workId=%s, document=%s).", this.key, this.id, this.docRef));
        }
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(this.getTransientStoreName());
        if (sourceDocumentModificationDate != null) {
            ts.putParameter(this.key, "sourceDocumentModificationDate", (Serializable)((Object)sourceDocumentModificationDate));
        }
        ts.putBlobs(this.key, blobs);
        ts.setCompleted(this.key, true);
    }

    protected String getSourceDocumentModificationDate(DocumentModel doc) {
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition definition = rs.getAvailableRenditionDefinition(doc, this.renditionName);
        RenditionProvider provider = definition.getProvider();
        if (provider instanceof AbstractLazyCachableRenditionProvider) {
            return ((AbstractLazyCachableRenditionProvider)provider).getSourceDocumentModificationDate(doc, definition);
        }
        return null;
    }

    protected abstract List<Blob> doComputeRendition(CoreSession var1, DocumentModel var2, RenditionDefinition var3);
}

