/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.operation;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.PublishToSection", category="Document", label="Publish Document's Rendition", description="input document's chosen rendition into the target section. If rendition is not given and default rendition option is false, it falls back on default publishing. Existing proxy is overrided if the override attribute is set. Return the created proxy.", aliases={"Document.PublishRendition"})
public class PublishRendition {
    public static final String ID = "Document.PublishToSection";
    @Context
    protected CoreSession session;
    @Param(name="renditionName", required=false)
    protected String renditionName;
    @Param(name="defaultRendition", required=false)
    protected boolean defaultRendition;
    @Param(name="target")
    protected DocumentModel target;
    @Param(name="override", required=false, values={"true"})
    protected boolean override = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        DocumentModel proxy;
        if (!this.defaultRendition && StringUtils.isEmpty((CharSequence)this.renditionName)) {
            proxy = this.session.publishDocument(doc, this.target, this.override);
        } else {
            RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
            proxy = rs.publishRendition(doc, this.target, this.renditionName, this.override);
        }
        this.notifyPublishedEvent(doc);
        this.notifyPublishedEvent(proxy);
        return proxy;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }

    protected void notifyPublishedEvent(DocumentModel proxy) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("repositoryName", proxy.getRepositoryName());
        properties.put("sessionId", this.session.getSessionId());
        properties.put("documentLifeCycle", proxy.getCurrentLifeCycleState());
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), proxy);
        ctx.setProperties(properties);
        ctx.setCategory("eventDocumentCategory");
        Event event = ctx.newEvent("documentPublished");
        ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
    }
}

