/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public class ConsumerNetworkClient
implements Closeable {
    private static final int MAX_POLL_TIMEOUT_MS = 5000;
    private final Logger log;
    private final KafkaClient client;
    private final UnsentRequests unsent = new UnsentRequests();
    private final Metadata metadata;
    private final Time time;
    private final long retryBackoffMs;
    private final int maxPollTimeoutMs;
    private final int requestTimeoutMs;
    private final AtomicBoolean wakeupDisabled = new AtomicBoolean();
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ConcurrentLinkedQueue<RequestFutureCompletionHandler> pendingCompletion = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Node> pendingDisconnects = new ConcurrentLinkedQueue();
    private final AtomicBoolean wakeup = new AtomicBoolean(false);

    public ConsumerNetworkClient(LogContext logContext, KafkaClient client, Metadata metadata, Time time, long retryBackoffMs, int requestTimeoutMs, int maxPollTimeoutMs) {
        this.log = logContext.logger(ConsumerNetworkClient.class);
        this.client = client;
        this.metadata = metadata;
        this.time = time;
        this.retryBackoffMs = retryBackoffMs;
        this.maxPollTimeoutMs = Math.min(maxPollTimeoutMs, 5000);
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public RequestFuture<ClientResponse> send(Node node, AbstractRequest.Builder<?> requestBuilder) {
        return this.send(node, requestBuilder, this.requestTimeoutMs);
    }

    public RequestFuture<ClientResponse> send(Node node, AbstractRequest.Builder<?> requestBuilder, int requestTimeoutMs) {
        long now = this.time.milliseconds();
        RequestFutureCompletionHandler completionHandler = new RequestFutureCompletionHandler();
        ClientRequest clientRequest = this.client.newClientRequest(node.idString(), requestBuilder, now, true, requestTimeoutMs, completionHandler);
        this.unsent.put(node, clientRequest);
        this.client.wakeup();
        return completionHandler.future;
    }

    public Node leastLoadedNode() {
        this.lock.lock();
        try {
            Node node = this.client.leastLoadedNode(this.time.milliseconds());
            return node;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReadyNodes(long now) {
        this.lock.lock();
        try {
            boolean bl = this.client.hasReadyNodes(now);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean awaitMetadataUpdate(Timer timer) {
        int version = this.metadata.requestUpdate();
        do {
            this.poll(timer);
            AuthenticationException ex = this.metadata.getAndClearAuthenticationException();
            if (ex == null) continue;
            throw ex;
        } while (this.metadata.version() == version && timer.notExpired());
        return this.metadata.version() > version;
    }

    boolean ensureFreshMetadata(Timer timer) {
        if (this.metadata.updateRequested() || this.metadata.timeToNextUpdate(timer.currentTimeMs()) == 0L) {
            return this.awaitMetadataUpdate(timer);
        }
        return true;
    }

    public void wakeup() {
        this.log.debug("Received user wakeup");
        this.wakeup.set(true);
        this.client.wakeup();
    }

    public void poll(RequestFuture<?> future) {
        while (!future.isDone()) {
            this.poll(this.time.timer(Long.MAX_VALUE), future);
        }
    }

    public boolean poll(RequestFuture<?> future, Timer timer) {
        do {
            this.poll(timer, future);
        } while (!future.isDone() && timer.notExpired());
        return future.isDone();
    }

    public void poll(Timer timer) {
        this.poll(timer, null);
    }

    public void poll(Timer timer, PollCondition pollCondition) {
        this.poll(timer, pollCondition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll(Timer timer, PollCondition pollCondition, boolean disableWakeup) {
        this.firePendingCompletedRequests();
        this.lock.lock();
        try {
            this.handlePendingDisconnects();
            long pollDelayMs = this.trySend(timer.currentTimeMs());
            if (this.pendingCompletion.isEmpty() && (pollCondition == null || pollCondition.shouldBlock())) {
                long pollTimeout = Math.min(timer.remainingMs(), pollDelayMs);
                if (this.client.inFlightRequestCount() == 0) {
                    pollTimeout = Math.min(pollTimeout, this.retryBackoffMs);
                }
                this.client.poll(pollTimeout, timer.currentTimeMs());
            } else {
                this.client.poll(0L, timer.currentTimeMs());
            }
            timer.update();
            this.checkDisconnects(timer.currentTimeMs());
            if (!disableWakeup) {
                this.maybeTriggerWakeup();
            }
            this.maybeThrowInterruptException();
            this.trySend(timer.currentTimeMs());
            this.failExpiredRequests(timer.currentTimeMs());
            this.unsent.clean();
        }
        finally {
            this.lock.unlock();
        }
        this.firePendingCompletedRequests();
    }

    public void pollNoWakeup() {
        this.poll(this.time.timer(0L), null, true);
    }

    public boolean awaitPendingRequests(Node node, Timer timer) {
        while (this.hasPendingRequests(node) && timer.notExpired()) {
            this.poll(timer);
        }
        return !this.hasPendingRequests(node);
    }

    public int pendingRequestCount(Node node) {
        this.lock.lock();
        try {
            int n = this.unsent.requestCount(node) + this.client.inFlightRequestCount(node.idString());
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasPendingRequests(Node node) {
        if (this.unsent.hasRequests(node)) {
            return true;
        }
        this.lock.lock();
        try {
            boolean bl = this.client.hasInFlightRequests(node.idString());
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int pendingRequestCount() {
        this.lock.lock();
        try {
            int n = this.unsent.requestCount() + this.client.inFlightRequestCount();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasPendingRequests() {
        if (this.unsent.hasRequests()) {
            return true;
        }
        this.lock.lock();
        try {
            boolean bl = this.client.hasInFlightRequests();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void firePendingCompletedRequests() {
        RequestFutureCompletionHandler completionHandler;
        boolean completedRequestsFired = false;
        while ((completionHandler = this.pendingCompletion.poll()) != null) {
            completionHandler.fireCompletion();
            completedRequestsFired = true;
        }
        if (completedRequestsFired) {
            this.client.wakeup();
        }
    }

    private void checkDisconnects(long now) {
        for (Node node : this.unsent.nodes()) {
            if (!this.client.connectionFailed(node)) continue;
            Collection<ClientRequest> requests = this.unsent.remove(node);
            for (ClientRequest request : requests) {
                RequestFutureCompletionHandler handler = (RequestFutureCompletionHandler)request.callback();
                AuthenticationException authenticationException = this.client.authenticationException(node);
                handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), request.callback(), request.destination(), request.createdTimeMs(), now, true, null, authenticationException, null));
            }
        }
    }

    private void handlePendingDisconnects() {
        this.lock.lock();
        try {
            Node node;
            while ((node = this.pendingDisconnects.poll()) != null) {
                this.failUnsentRequests(node, DisconnectException.INSTANCE);
                this.client.disconnect(node.idString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disconnectAsync(Node node) {
        this.pendingDisconnects.offer(node);
        this.client.wakeup();
    }

    private void failExpiredRequests(long now) {
        Collection expiredRequests = this.unsent.removeExpiredRequests(now);
        for (ClientRequest request : expiredRequests) {
            RequestFutureCompletionHandler handler = (RequestFutureCompletionHandler)request.callback();
            handler.onFailure(new TimeoutException("Failed to send request after " + request.requestTimeoutMs() + " ms."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failUnsentRequests(Node node, RuntimeException e) {
        this.lock.lock();
        try {
            Collection<ClientRequest> unsentRequests = this.unsent.remove(node);
            for (ClientRequest unsentRequest : unsentRequests) {
                RequestFutureCompletionHandler handler = (RequestFutureCompletionHandler)unsentRequest.callback();
                handler.onFailure(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private long trySend(long now) {
        long pollDelayMs = this.maxPollTimeoutMs;
        for (Node node : this.unsent.nodes()) {
            Iterator<ClientRequest> iterator = this.unsent.requestIterator(node);
            if (iterator.hasNext()) {
                pollDelayMs = Math.min(pollDelayMs, this.client.pollDelayMs(node, now));
            }
            while (iterator.hasNext()) {
                ClientRequest request = iterator.next();
                if (!this.client.ready(node, now)) continue;
                this.client.send(request, now);
                iterator.remove();
            }
        }
        return pollDelayMs;
    }

    public void maybeTriggerWakeup() {
        if (!this.wakeupDisabled.get() && this.wakeup.get()) {
            this.log.debug("Raising WakeupException in response to user wakeup");
            this.wakeup.set(false);
            throw new WakeupException();
        }
    }

    private void maybeThrowInterruptException() {
        if (Thread.interrupted()) {
            throw new InterruptException(new InterruptedException());
        }
    }

    public void disableWakeups() {
        this.wakeupDisabled.set(true);
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.client.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isUnavailable(Node node) {
        this.lock.lock();
        try {
            boolean bl = this.client.connectionFailed(node) && this.client.connectionDelay(node, this.time.milliseconds()) > 0L;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void maybeThrowAuthFailure(Node node) {
        this.lock.lock();
        try {
            AuthenticationException exception = this.client.authenticationException(node);
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void tryConnect(Node node) {
        this.lock.lock();
        try {
            this.client.ready(node, this.time.milliseconds());
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class UnsentRequests {
        private final ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> unsent = new ConcurrentHashMap<Node, ConcurrentLinkedQueue<ClientRequest>>();

        private UnsentRequests() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Node node, ClientRequest request) {
            ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> concurrentMap = this.unsent;
            synchronized (concurrentMap) {
                ConcurrentLinkedQueue<ClientRequest> requests = (ConcurrentLinkedQueue<ClientRequest>)this.unsent.get(node);
                if (requests == null) {
                    requests = new ConcurrentLinkedQueue<ClientRequest>();
                    this.unsent.put(node, requests);
                }
                requests.add(request);
            }
        }

        public int requestCount(Node node) {
            ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.get(node);
            return requests == null ? 0 : requests.size();
        }

        public int requestCount() {
            int total = 0;
            for (ConcurrentLinkedQueue requests : this.unsent.values()) {
                total += requests.size();
            }
            return total;
        }

        public boolean hasRequests(Node node) {
            ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.get(node);
            return requests != null && !requests.isEmpty();
        }

        public boolean hasRequests() {
            for (ConcurrentLinkedQueue requests : this.unsent.values()) {
                if (requests.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private Collection<ClientRequest> removeExpiredRequests(long now) {
            ArrayList<ClientRequest> expiredRequests = new ArrayList<ClientRequest>();
            for (ConcurrentLinkedQueue requests : this.unsent.values()) {
                ClientRequest request;
                long elapsedMs;
                Iterator requestIterator = requests.iterator();
                while (requestIterator.hasNext() && (elapsedMs = Math.max(0L, now - (request = (ClientRequest)requestIterator.next()).createdTimeMs())) > (long)request.requestTimeoutMs()) {
                    expiredRequests.add(request);
                    requestIterator.remove();
                }
            }
            return expiredRequests;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clean() {
            ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> concurrentMap = this.unsent;
            synchronized (concurrentMap) {
                Iterator iterator = this.unsent.values().iterator();
                while (iterator.hasNext()) {
                    ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)iterator.next();
                    if (!requests.isEmpty()) continue;
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<ClientRequest> remove(Node node) {
            ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> concurrentMap = this.unsent;
            synchronized (concurrentMap) {
                ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.remove(node);
                return requests == null ? Collections.emptyList() : requests;
            }
        }

        public Iterator<ClientRequest> requestIterator(Node node) {
            ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.get(node);
            return requests == null ? Collections.emptyIterator() : requests.iterator();
        }

        public Collection<Node> nodes() {
            return this.unsent.keySet();
        }
    }

    public static interface PollCondition {
        public boolean shouldBlock();
    }

    private class RequestFutureCompletionHandler
    implements RequestCompletionHandler {
        private final RequestFuture<ClientResponse> future = new RequestFuture();
        private ClientResponse response;
        private RuntimeException e;

        private RequestFutureCompletionHandler() {
        }

        public void fireCompletion() {
            if (this.e != null) {
                this.future.raise(this.e);
            } else if (this.response.authenticationException() != null) {
                this.future.raise(this.response.authenticationException());
            } else if (this.response.wasDisconnected()) {
                ConsumerNetworkClient.this.log.debug("Cancelled request with header {} due to node {} being disconnected", (Object)this.response.requestHeader(), (Object)this.response.destination());
                this.future.raise(DisconnectException.INSTANCE);
            } else if (this.response.versionMismatch() != null) {
                this.future.raise(this.response.versionMismatch());
            } else {
                this.future.complete(this.response);
            }
        }

        public void onFailure(RuntimeException e) {
            this.e = e;
            ConsumerNetworkClient.this.pendingCompletion.add(this);
        }

        @Override
        public void onComplete(ClientResponse response) {
            this.response = response;
            ConsumerNetworkClient.this.pendingCompletion.add(this);
        }
    }
}

