/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.IdentityQueryTransformer;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;

public abstract class QueryOptimizer {
    public static final String TYPE_ROOT = "Root";
    public static final String TYPE_DOCUMENT = "Document";
    public static final String TYPE_RELATION = "Relation";
    protected static final int CORR_BASE = 100000;
    protected FacetFilter facetFilter;
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
    protected final Set<String> neverPerInstanceMixins;
    protected int correlationCounter;
    protected boolean onlyRelations;
    protected static Collector<Predicate, ?, Map<String, List<Predicate>>> GROUPING_BY_EXPR_PREFIX = Collectors.groupingBy(QueryOptimizer::getPredicatePrefix, LinkedHashMap::new, Collectors.toList());

    public QueryOptimizer() {
        Set facets = this.schemaManager == null ? Collections.emptySet() : this.schemaManager.getNoPerDocumentQueryFacets();
        this.neverPerInstanceMixins = new HashSet<String>(facets);
    }

    public QueryOptimizer withFacetFilter(FacetFilter facetFilter) {
        this.facetFilter = facetFilter;
        return this;
    }

    public SQLQuery optimize(SQLQuery query) {
        MultiExpression whereExpr;
        query = this.addWildcardNotNullClauses(query);
        ArrayList<Predicate> clauses = new ArrayList<Predicate>();
        this.addFacetFilters(clauses, this.facetFilter);
        this.addTypes(clauses, query.from);
        this.addWhere(clauses, query.where);
        this.simplifyTypes(clauses);
        MultiExpression multiExpression = new MultiExpression(Operator.AND, clauses);
        new ReferencePrefixAnalyzer().visitMultiExpression(multiExpression);
        PrefixInfo info = (PrefixInfo)multiExpression.getInfo();
        if (!info.prefix.isEmpty()) {
            whereExpr = multiExpression;
        } else {
            Map<String, List<Predicate>> grouped = clauses.stream().collect(GROUPING_BY_EXPR_PREFIX);
            LinkedHashMap<String, Predicate> groupedExpressions = new LinkedHashMap<String, Predicate>();
            for (Map.Entry<String, List<Predicate>> en : grouped.entrySet()) {
                String prefix = en.getKey();
                List<Predicate> list = en.getValue();
                groupedExpressions.put(prefix, QueryOptimizer.makeSingleAndPredicate(prefix, list));
            }
            QueryOptimizer.reorganizeGroupedExpressions(groupedExpressions);
            ArrayList<Predicate> expressions = new ArrayList<Predicate>(groupedExpressions.values());
            whereExpr = QueryOptimizer.makeSingleAndPredicate("", expressions);
        }
        return query.withPredicate((Predicate)whereExpr);
    }

    public static Predicate makeSingleAndPredicate(String prefix, List<Predicate> predicates) {
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        int count = prefix.isEmpty() ? 0 : predicates.stream().mapToInt(QueryOptimizer::getExpressionCount).sum();
        MultiExpression e = new MultiExpression(Operator.AND, predicates);
        e.setInfo((Object)new PrefixInfo(prefix, count));
        return e;
    }

    protected static String getPredicatePrefix(Predicate predicate) {
        PrefixInfo info = (PrefixInfo)predicate.getInfo();
        return info == null ? "" : info.prefix;
    }

    protected static int getExpressionCount(Expression expr) {
        PrefixInfo info = (PrefixInfo)expr.getInfo();
        return info == null ? 0 : info.count;
    }

    public static void reorganizeGroupedExpressions(Map<String, Predicate> groupedExpressions) {
        ArrayList<String> withPrefix;
        ArrayList<String> keys;
        String prefix;
        if (groupedExpressions.size() > 1 && (prefix = QueryOptimizer.findPrefix(keys = new ArrayList<String>(groupedExpressions.keySet()), withPrefix = new ArrayList<String>())) != null) {
            Predicate first = groupedExpressions.remove(prefix);
            ArrayList<Predicate> exprs = new ArrayList<Predicate>();
            for (String k : withPrefix) {
                exprs.add(groupedExpressions.remove(k));
            }
            if (withPrefix.size() != 1) {
                throw new QueryParseException("Too complex correlated wildcards in query: " + groupedExpressions);
            }
            String secondPrefix = (String)withPrefix.get(0);
            Predicate second = QueryOptimizer.makeSingleAndPredicate(secondPrefix, exprs);
            Predicate expr = QueryOptimizer.makeSingleAndPredicate(prefix, Arrays.asList(first, second));
            groupedExpressions.put(prefix, expr);
        }
    }

    public static String findPrefix(List<String> strings, List<String> withPrefix) {
        String prefix = null;
        block0: for (int i = 0; i < strings.size(); ++i) {
            String candidate = strings.get(i);
            if (candidate.isEmpty()) continue;
            for (int j = 0; j < strings.size(); ++j) {
                String s;
                if (i == j || (s = strings.get(j)).isEmpty() || !s.startsWith(candidate + '/')) continue;
                prefix = candidate;
                break block0;
            }
        }
        if (prefix != null) {
            Iterator<String> it = strings.iterator();
            while (it.hasNext()) {
                String s = it.next();
                if (s.isEmpty()) continue;
                if (s.equals(prefix)) {
                    it.remove();
                    continue;
                }
                if (!s.startsWith(prefix + '/')) continue;
                it.remove();
                withPrefix.add(s);
            }
        }
        return prefix;
    }

    protected void addFacetFilters(List<Predicate> clauses, FacetFilter facetFilter) {
        if (facetFilter == null) {
            return;
        }
        for (Object mixin : facetFilter.required) {
            Predicate expr = new Predicate((Operand)new Reference("ecm:mixinType"), Operator.EQ, (Operand)new StringLiteral((String)mixin));
            clauses.add(expr);
        }
        if (!facetFilter.excluded.isEmpty()) {
            LiteralList list = new LiteralList();
            for (String mixin : facetFilter.excluded) {
                list.add((Object)new StringLiteral(mixin));
            }
            Predicate expr = new Predicate((Operand)new Reference("ecm:mixinType"), Operator.NOTIN, (Operand)list);
            clauses.add(expr);
        }
    }

    protected Set<String> getDocumentTypeNamesForFacet(String mixin) {
        Set<String> types = this.schemaManager.getDocumentTypeNamesForFacet(mixin);
        if (types == null) {
            types = Collections.emptySet();
        }
        return types;
    }

    protected Set<String> getDocumentTypeNamesExtending(String typeName) {
        Set types = this.schemaManager.getDocumentTypeNamesExtending(typeName);
        if (types == null) {
            throw new RuntimeException("Unknown type: " + typeName);
        }
        return types;
    }

    protected boolean isTypeRelation(String typeName) {
        DocumentType t;
        do {
            if (TYPE_RELATION.equals(typeName)) {
                return true;
            }
            t = this.schemaManager.getDocumentType(typeName);
            if (t == null) continue;
            t = t.getSuperType();
        } while ((typeName = t == null ? null : t.getName()) != null);
        return false;
    }

    protected void addTypes(List<Predicate> clauses, FromClause node) {
        this.onlyRelations = true;
        HashSet<String> fromTypes = new HashSet<String>();
        FromList elements = node.elements;
        for (String typeName : elements.values()) {
            if (TYPE_DOCUMENT.equalsIgnoreCase(typeName)) {
                typeName = TYPE_DOCUMENT;
            }
            fromTypes.addAll(this.getDocumentTypeNamesExtending(typeName));
            boolean isRelation = this.isTypeRelation(typeName);
            this.onlyRelations = this.onlyRelations && isRelation;
        }
        fromTypes.remove(TYPE_ROOT);
        LiteralList list = new LiteralList();
        for (String type : fromTypes) {
            list.add((Object)new StringLiteral(type));
        }
        clauses.add(new Predicate((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list));
    }

    protected void addWhere(List<Predicate> clauses, WhereClause where) {
        if (where != null) {
            this.addWhere(clauses, where.predicate);
        }
    }

    protected void addWhere(List<Predicate> clauses, Predicate expr) {
        if (expr.operator == Operator.AND && expr.lvalue instanceof Expression && expr.rvalue instanceof Expression) {
            this.addWhere(clauses, (Predicate)expr.lvalue);
            this.addWhere(clauses, (Predicate)expr.rvalue);
        } else if (expr.operator == Operator.AND && expr instanceof MultiExpression) {
            for (Predicate pred : ((MultiExpression)expr).predicates) {
                this.addWhere(clauses, pred);
            }
        } else {
            clauses.add(expr);
        }
    }

    protected void simplifyTypes(List<Predicate> clauses) {
        Set<String> primaryTypes = null;
        Iterator<Predicate> it = clauses.iterator();
        while (it.hasNext()) {
            String mixin;
            Predicate predicate = it.next();
            if (!(predicate.lvalue instanceof Reference)) continue;
            String name = ((Reference)predicate.lvalue).name;
            Operator op = predicate.operator;
            Operand rvalue = predicate.rvalue;
            if ("ecm:primaryType".equals(name)) {
                Set<String> set;
                if (op != Operator.EQ && op != Operator.IN) continue;
                if (op == Operator.EQ) {
                    if (!(rvalue instanceof StringLiteral)) continue;
                    String primaryType = ((StringLiteral)rvalue).value;
                    set = new HashSet<String>(Collections.singleton(primaryType));
                } else {
                    if (!(rvalue instanceof LiteralList)) continue;
                    set = QueryOptimizer.getStringLiterals((LiteralList)rvalue);
                }
                if (primaryTypes == null) {
                    primaryTypes = set;
                } else {
                    primaryTypes.retainAll(set);
                }
                it.remove();
                continue;
            }
            if (!"ecm:mixinType".equals(name) || op != Operator.EQ && op != Operator.NOTEQ || !(rvalue instanceof StringLiteral) || !this.neverPerInstanceMixins.contains(mixin = ((StringLiteral)rvalue).value)) continue;
            Set<String> set = this.getDocumentTypeNamesForFacet(mixin);
            if (primaryTypes == null) {
                if (op != Operator.EQ) continue;
                primaryTypes = new HashSet<String>(set);
            } else if (op == Operator.EQ) {
                primaryTypes.retainAll(set);
            } else {
                primaryTypes.removeAll(set);
            }
            it.remove();
        }
        if (primaryTypes != null) {
            Predicate predicate;
            if (primaryTypes.isEmpty()) {
                primaryTypes.add("__NOSUCHTYPE__");
            }
            if (primaryTypes.size() == 1) {
                String pt = (String)primaryTypes.iterator().next();
                predicate = new Predicate((Operand)new Reference("ecm:primaryType"), Operator.EQ, (Operand)new StringLiteral(pt));
            } else {
                LiteralList list = new LiteralList();
                for (String pt : primaryTypes) {
                    list.add((Object)new StringLiteral(pt));
                }
                predicate = new Predicate((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list);
            }
            clauses.add(predicate);
        }
    }

    protected static Set<String> getStringLiterals(LiteralList list) {
        HashSet<String> set = new HashSet<String>();
        for (Literal literal : list) {
            if (!(literal instanceof StringLiteral)) {
                throw new RuntimeException("requires string literals");
            }
            set.add(((StringLiteral)literal).value);
        }
        return set;
    }

    protected SQLQuery addWildcardNotNullClauses(SQLQuery query) {
        ProjectionWildcardsFinder finder = new ProjectionWildcardsFinder();
        finder.visitQuery(query);
        Set<String> wildcards = finder.projectionWildcards;
        Set<String> uncorrelatedWildcards = finder.uncorrelatedProjectionWildcards;
        if (!uncorrelatedWildcards.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>(uncorrelatedWildcards.size());
            for (String name : uncorrelatedWildcards) {
                String newName = name + (100000 + this.correlationCounter++);
                map.put(name, newName);
                wildcards.remove(name);
                wildcards.add(newName);
            }
            query = new ProjectionReferenceRenamer(map).transform(query);
        }
        if (!wildcards.isEmpty()) {
            query = this.addIsNotNullClauses(query, wildcards);
        }
        return query;
    }

    protected SQLQuery addIsNotNullClauses(SQLQuery query, Collection<String> names) {
        List values = names.stream().map(name -> new Predicate((Operand)new Reference(name), Operator.ISNOTNULL, null)).collect(Collectors.toList());
        Predicate expr = new Predicate((Operand)query.where.predicate, Operator.AND, (Operand)new MultiExpression(Operator.AND, values));
        return query.withPredicate(expr);
    }

    public abstract String getCorrelatedWildcardPrefix(String var1);

    public class ReferencePrefixAnalyzer
    extends DefaultQueryVisitor {
        public void visitReference(Reference node) {
            super.visitReference(node);
            this.processReference(node);
        }

        public void visitMultiExpression(MultiExpression node) {
            super.visitMultiExpression(node);
            this.processExpression((Expression)node, node.predicates);
        }

        public void visitExpression(Expression node) {
            super.visitExpression(node);
            this.processExpression(node, Arrays.asList(node.lvalue, node.rvalue));
        }

        protected void processReference(Reference node) {
            String prefix = QueryOptimizer.this.getCorrelatedWildcardPrefix(node.name);
            int count = prefix.isEmpty() ? 0 : 1;
            node.setInfo((Object)new PrefixInfo(prefix, count));
        }

        protected void processExpression(Expression node, List<? extends Operand> operands) {
            PrefixInfo commonInfo = null;
            for (Operand operand : operands) {
                PrefixInfo info;
                if (operand instanceof Reference) {
                    Reference reference = (Reference)operand;
                    info = (PrefixInfo)reference.getInfo();
                } else if (operand instanceof Expression) {
                    Expression expression = (Expression)operand;
                    info = (PrefixInfo)expression.getInfo();
                } else {
                    info = null;
                }
                if (info == null) continue;
                if (commonInfo == null) {
                    commonInfo = info;
                    continue;
                }
                if (commonInfo.prefix.equals(info.prefix)) {
                    commonInfo = new PrefixInfo(commonInfo.prefix, commonInfo.count + info.count);
                    continue;
                }
                commonInfo = PrefixInfo.EMPTY;
            }
            node.setInfo(commonInfo);
        }
    }

    public static class PrefixInfo {
        public static final PrefixInfo EMPTY = new PrefixInfo("", 0);
        public final String prefix;
        public final int count;

        public PrefixInfo(String prefix, int count) {
            this.prefix = prefix;
            this.count = count;
        }
    }

    protected static class ProjectionReferenceRenamer
    extends IdentityQueryTransformer {
        protected final Map<String, String> map;
        protected boolean inProjection;

        public ProjectionReferenceRenamer(Map<String, String> map) {
            this.map = map;
        }

        public SelectClause transform(SelectClause node) {
            this.inProjection = true;
            node = super.transform(node);
            this.inProjection = false;
            return node;
        }

        public Reference transform(Reference node) {
            if (!this.inProjection) {
                return node;
            }
            String name = node.name;
            String newName = this.map.getOrDefault(name, name);
            Reference newReference = new Reference(newName, node.cast, node.esHint);
            if (newReference.originalName == null) {
                newReference.originalName = name;
            }
            newReference.info = node.info;
            return newReference;
        }
    }

    protected static class ProjectionWildcardsFinder
    extends DefaultQueryVisitor {
        protected final Set<String> projectionWildcards = new HashSet<String>();
        protected final Set<String> uncorrelatedProjectionWildcards = new HashSet<String>();
        protected boolean inProjection;
        protected boolean inOrderBy;

        protected ProjectionWildcardsFinder() {
        }

        public void visitSelectClause(SelectClause node) {
            this.inProjection = true;
            super.visitSelectClause(node);
            this.inProjection = false;
        }

        public void visitOrderByClause(OrderByClause node) {
            this.inOrderBy = true;
            super.visitOrderByClause(node);
            this.inOrderBy = false;
        }

        public void visitReference(Reference ref) {
            String name;
            if (this.inProjection && (name = ref.name).endsWith("*")) {
                this.projectionWildcards.add(name);
                if (name.endsWith("/*")) {
                    this.uncorrelatedProjectionWildcards.add(name);
                }
            }
        }
    }
}

