/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.runtime.pubsub.SerializableAccumulableInvalidations;

public class DBSInvalidations
implements SerializableAccumulableInvalidations {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SIZE = 10000;
    public boolean all;
    public Set<String> ids;
    private static final String UTF_8 = "UTF-8";
    private static final int ALL_IDS = 65;
    private static final int ID_SEP = 44;

    public DBSInvalidations() {
    }

    public DBSInvalidations(boolean all) {
        this.all = all;
    }

    public boolean isEmpty() {
        return this.ids == null && !this.all;
    }

    public void clear() {
        this.all = false;
        this.ids = null;
    }

    protected void setAll() {
        this.all = true;
        this.ids = null;
    }

    protected void checkMaxSize() {
        if (this.ids != null && this.ids.size() > 10000) {
            this.setAll();
        }
    }

    public void add(SerializableAccumulableInvalidations o) {
        DBSInvalidations other = (DBSInvalidations)o;
        if (other == null) {
            return;
        }
        if (this.all) {
            return;
        }
        if (other.all) {
            this.setAll();
            return;
        }
        if (other.ids != null) {
            if (this.ids == null) {
                this.ids = new HashSet<String>();
            }
            this.ids.addAll(other.ids);
        }
        this.checkMaxSize();
    }

    public void add(String id) {
        if (this.all) {
            return;
        }
        if (this.ids == null) {
            this.ids = new HashSet<String>();
        }
        this.ids.add(id);
        this.checkMaxSize();
    }

    public void addAll(Collection<String> idsToAdd) {
        if (this.all) {
            return;
        }
        if (this.ids == null) {
            this.ids = new HashSet<String>(idsToAdd);
        } else {
            this.ids.addAll(idsToAdd);
        }
        this.checkMaxSize();
    }

    public void serialize(OutputStream out) throws IOException {
        if (this.all) {
            out.write(65);
        } else if (this.ids != null) {
            for (String id : this.ids) {
                out.write(44);
                out.write(id.getBytes(UTF_8));
            }
        }
    }

    public static DBSInvalidations deserialize(InputStream in) throws IOException {
        int first = in.read();
        if (first == -1) {
            return null;
        }
        DBSInvalidations invalidations = new DBSInvalidations();
        if (first == 65) {
            invalidations.setAll();
        } else {
            if (first != 44) {
                return null;
            }
            ByteArrayOutputStream baout = new ByteArrayOutputStream(36);
            while (true) {
                int b;
                if ((b = in.read()) == 44 || b == -1) {
                    invalidations.add(baout.toString(UTF_8));
                    if (b == -1) break;
                    baout.reset();
                    continue;
                }
                baout.write(b);
            }
        }
        return invalidations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + '(');
        if (this.all) {
            sb.append("all=true");
        }
        if (this.ids != null) {
            sb.append("ids=");
            sb.append(this.ids);
        }
        sb.append(')');
        return sb.toString();
    }
}

