/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.runtime.api.Framework;

public class ConversionWork
extends TransientStoreWork {
    private static final long serialVersionUID = 14593653977944460L;
    protected String converterName;
    protected String destinationMimeType;
    protected Map<String, Serializable> parameters;
    protected String inputEntryKey;

    public ConversionWork(String converterName, String destinationMimeType, BlobHolder blobHolder, Map<String, Serializable> parameters) {
        if (converterName == null && destinationMimeType == null) {
            throw new IllegalArgumentException("'convertName' or 'destinationMimeType' must not be null");
        }
        this.converterName = converterName;
        this.destinationMimeType = destinationMimeType;
        this.parameters = parameters;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Serializable>();
        }
        this.storeInputBlobHolder(blobHolder);
    }

    protected void storeInputBlobHolder(BlobHolder blobHolder) {
        this.inputEntryKey = this.entryKey + "_input";
        ConversionWork.putBlobHolder((String)this.inputEntryKey, (BlobHolder)blobHolder);
    }

    public void work() {
        BlobHolder result;
        this.setStatus("Converting");
        BlobHolder inputBlobHolder = this.retrieveInputBlobHolder();
        if (inputBlobHolder == null) {
            return;
        }
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder blobHolder = result = this.converterName != null ? conversionService.convert(this.converterName, inputBlobHolder, this.parameters) : conversionService.convertToMimeType(this.destinationMimeType, inputBlobHolder, this.parameters);
        if (result == null) {
            return;
        }
        this.putBlobHolder(result);
        this.setStatus(null);
    }

    protected BlobHolder retrieveInputBlobHolder() {
        return ConversionWork.getBlobHolder((String)this.inputEntryKey);
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        ConversionWork.removeBlobHolder((String)this.inputEntryKey);
    }

    public String getTitle() {
        if (this.converterName != null) {
            return String.format("Conversion using '%s' converter", this.converterName);
        }
        return String.format("Conversion using '%s' target mime type", this.destinationMimeType);
    }
}

