/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.logging.SequenceTracer;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractWork
implements Work {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractWork.class);
    protected static final Random RANDOM = new Random();
    protected String id;
    protected volatile transient boolean suspending;
    protected volatile transient boolean suspended;
    protected Work.State state;
    protected Work.Progress progress;
    protected String repositoryName;
    protected String docId;
    protected List<String> docIds;
    protected boolean isTree;
    protected String originatingUsername;
    protected String status;
    protected long schedulingTime;
    protected long startTime;
    protected long completionTime;
    protected transient CoreSession session;
    protected transient LoginContext loginContext;
    protected WorkSchedulePath schedulePath;
    protected String callerThread;

    public AbstractWork() {
        this(System.nanoTime() + "." + Math.abs(RANDOM.nextInt()));
        this.callerThread = SequenceTracer.getThreadName();
    }

    public AbstractWork(String id) {
        this.id = id;
        this.progress = Work.Progress.PROGRESS_INDETERMINATE;
        this.schedulingTime = System.currentTimeMillis();
        this.callerThread = SequenceTracer.getThreadName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public WorkSchedulePath getSchedulePath() {
        return this.schedulePath == null ? WorkSchedulePath.EMPTY : this.schedulePath;
    }

    @Override
    public void setSchedulePath(WorkSchedulePath path) {
        this.schedulePath = path;
    }

    public void setDocument(String repositoryName, String docId, boolean isTree) {
        this.repositoryName = repositoryName;
        this.docId = docId;
        this.docIds = null;
        this.isTree = isTree;
    }

    public void setDocument(String repositoryName, String docId) {
        this.setDocument(repositoryName, docId, false);
    }

    public void setDocuments(String repositoryName, List<String> docIds) {
        this.repositoryName = repositoryName;
        this.docId = null;
        this.docIds = new ArrayList<String>(docIds);
    }

    public void setOriginatingUsername(String originatingUsername) {
        this.originatingUsername = originatingUsername;
    }

    @Override
    public void setWorkInstanceSuspending() {
        this.suspending = true;
    }

    @Override
    public boolean isSuspending() {
        return this.suspending;
    }

    @Override
    public void suspended() {
        this.suspended = true;
    }

    @Override
    public boolean isWorkInstanceSuspended() {
        return this.suspended;
    }

    @Override
    public void setWorkInstanceState(Work.State state) {
        this.state = state;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " state=" + (Object)((Object)state)));
        }
    }

    @Override
    public Work.State getWorkInstanceState() {
        return this.state;
    }

    @Override
    public void setProgress(Work.Progress progress) {
        this.progress = progress;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.valueOf(this));
        }
    }

    @Override
    public Work.Progress getProgress() {
        return this.progress;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Deprecated
    public CoreSession initSession() {
        return this.initSession(this.repositoryName);
    }

    public void openSystemSession() {
        this.session = CoreInstance.openCoreSessionSystem((String)this.repositoryName, (String)this.originatingUsername);
    }

    public void openUserSession() {
        if (this.originatingUsername == null) {
            throw new IllegalStateException("Cannot open an user session without an originatingUsername");
        }
        try {
            this.loginContext = Framework.loginAsUser((String)this.originatingUsername);
        }
        catch (LoginException e) {
            throw new NuxeoException((Throwable)e);
        }
        this.session = CoreInstance.openCoreSession((String)this.repositoryName);
    }

    @Deprecated
    public CoreSession initSession(String repositoryName) {
        this.session = CoreInstance.openCoreSessionSystem((String)repositoryName, (String)this.originatingUsername);
        return this.session;
    }

    public void closeSession() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Override
    public void run() {
        if (this.isSuspending()) {
            this.suspended();
            return;
        }
        if (SequenceTracer.isEnabled()) {
            SequenceTracer.startFrom((String)this.callerThread, (String)("Work " + this.getTitleOr("unknown")), (String)" #7acde9");
        }
        RuntimeException suppressed = null;
        int retryCount = this.getRetryCount();
        for (int i = 0; i <= retryCount; ++i) {
            if (i > 0) {
                log.debug((Object)("Retrying work due to concurrent update (" + i + "): " + this));
                log.trace((Object)"Concurrent update", (Throwable)suppressed);
            }
            if (ExceptionUtils.hasInterruptedCause(suppressed)) {
                log.debug((Object)("No need to retry the work with id=" + this.getId() + ", work manager is shutting down"));
                break;
            }
            try {
                this.runWorkWithTransaction();
                SequenceTracer.stop((String)("Work done " + (this.completionTime - this.startTime) + " ms"));
                return;
            }
            catch (RuntimeException e) {
                if (suppressed == null) {
                    suppressed = e;
                    continue;
                }
                suppressed.addSuppressed(e);
                continue;
            }
        }
        if (suppressed != null) {
            String msg = "Work failed after " + retryCount + " " + (retryCount == 1 ? "retry" : "retries") + ", class=" + this.getClass() + " id=" + this.getId() + " category=" + this.getCategory() + " title=" + this.getTitle();
            SequenceTracer.destroy((String)("Work failure " + (this.completionTime - this.startTime) + " ms"));
            throw new RuntimeException(msg, suppressed);
        }
    }

    private String getTitleOr(String defaultTitle) {
        try {
            return this.getTitle();
        }
        catch (Exception e) {
            return defaultTitle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWorkWithTransaction() {
        TransactionHelper.startTransaction();
        boolean ok = false;
        Exception exc = null;
        try {
            WorkSchedulePath.handleEnter(this);
            this.setStartTime();
            this.work();
            ok = true;
        }
        catch (Exception e) {
            exc = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e);
        }
        finally {
            WorkSchedulePath.handleReturn();
            try {
                this.setCompletionTime();
                this.cleanUp(ok, exc);
            }
            finally {
                if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                    if (!ok || this.isSuspending()) {
                        log.trace((Object)(this + " is suspending, rollbacking"));
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
    }

    @Override
    public abstract void work();

    public int getRetryCount() {
        return 0;
    }

    @Override
    public void cleanUp(boolean ok, Exception e) {
        if (!ok) {
            if (ExceptionUtils.hasInterruptedCause((Throwable)e)) {
                log.debug((Object)("Interrupted work: " + this));
            } else if (!(e instanceof ConcurrentUpdateException) && !this.isSuspending()) {
                log.error((Object)("Exception during work: " + this), (Throwable)e);
                if (WorkSchedulePath.captureStack) {
                    WorkSchedulePath.log.error((Object)"Work schedule path", (Throwable)this.getSchedulePath().getStack());
                }
            }
        }
        this.closeSession();
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException le) {
            throw new NuxeoException((Throwable)le);
        }
    }

    @Override
    public String getOriginatingUsername() {
        return this.originatingUsername;
    }

    @Override
    public long getSchedulingTime() {
        return this.schedulingTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    protected void setCompletionTime() {
        this.completionTime = System.currentTimeMillis();
    }

    @Override
    public String getCategory() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('(');
        if (this.docId != null) {
            buf.append(this.docId);
            buf.append(", ");
        } else if (this.docIds != null && this.docIds.size() > 0) {
            buf.append(this.docIds.get(0));
            buf.append("..., ");
        }
        buf.append(this.getSchedulePath().getParentPath());
        buf.append(", ");
        buf.append(this.getProgress());
        buf.append(", ");
        buf.append(this.getStatus());
        buf.append(')');
        return buf.toString();
    }

    @Override
    public DocumentLocation getDocument() {
        if (this.docId != null) {
            return this.newDocumentLocation(this.docId);
        }
        return null;
    }

    @Override
    public List<DocumentLocation> getDocuments() {
        if (this.docIds != null) {
            ArrayList<DocumentLocation> res = new ArrayList<DocumentLocation>(this.docIds.size());
            for (String docId : this.docIds) {
                res.add(this.newDocumentLocation(docId));
            }
            return res;
        }
        if (this.docId != null) {
            return Collections.singletonList(this.newDocumentLocation(this.docId));
        }
        return Collections.emptyList();
    }

    protected DocumentLocation newDocumentLocation(String docId) {
        return new DocumentLocationImpl(this.repositoryName, (DocumentRef)new IdRef(docId));
    }

    @Override
    public boolean isDocumentTree() {
        return this.isTree;
    }

    public void commitOrRollbackTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    public boolean startTransaction() {
        return TransactionHelper.startTransaction();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Work)) {
            return false;
        }
        return ((Work)other).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public String getPartitionKey() {
        if (this.docId != null) {
            return this.docId;
        }
        if (this.docIds != null && !this.docIds.isEmpty()) {
            return this.docIds.get(0);
        }
        return this.getId();
    }
}

