/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.store.DataStore;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceUserStore;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public class NuxeoOAuth2ServiceProvider
implements OAuth2ServiceProvider {
    public static final String SCHEMA = "oauth2ServiceProvider";
    protected static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    protected static final JsonFactory JSON_FACTORY = new JacksonFactory();
    public static final String CODE_URL_PARAMETER = "code";
    public static final String ERROR_URL_PARAMETER = "error";
    protected String serviceName;
    protected Long id;
    protected String description;
    private String tokenServerURL;
    private String authorizationServerURL;
    protected String userAuthorizationURL;
    private String clientId;
    private String clientSecret;
    private List<String> scopes;
    private boolean enabled;
    protected OAuth2ServiceUserStore serviceUserStore;
    protected OAuth2TokenStore tokenStore;

    @Override
    public String getAuthorizationUrl(HttpServletRequest request) {
        return this.getAuthorizationCodeFlow().newAuthorizationUrl().setRedirectUri(this.getCallbackUrl(request)).build();
    }

    @Override
    public String getAuthorizationUrl(String serverURL) {
        return this.getAuthorizationCodeFlow().newAuthorizationUrl().setRedirectUri(this.getCallbackUrl(serverURL)).build();
    }

    protected String getCallbackUrl(HttpServletRequest request) {
        return this.getCallbackUrl(VirtualHostHelper.getBaseURL((ServletRequest)request));
    }

    protected String getCallbackUrl(String serverURL) {
        if (serverURL.endsWith("/")) {
            serverURL = serverURL.substring(0, serverURL.length() - 1);
        }
        return serverURL + "/site/oauth2/" + this.serviceName + "/callback";
    }

    @Override
    public Credential handleAuthorizationCallback(HttpServletRequest request) {
        String error = this.getError(request);
        if (error != null) {
            throw new NuxeoException("There was an error: \"" + error + "\".");
        }
        String code = this.getAuthorizationCode(request);
        if (code == null) {
            throw new NuxeoException("There is not code provided as QueryParam.");
        }
        try {
            AuthorizationCodeFlow flow = this.getAuthorizationCodeFlow();
            String redirectUri = this.getCallbackUrl(request);
            TokenResponse tokenResponse = flow.newTokenRequest(code).setScopes(this.scopes.isEmpty() ? null : this.scopes).setRedirectUri(redirectUri).execute();
            String userId = this.getOrCreateServiceUser(request, tokenResponse.getAccessToken());
            return flow.createAndStoreCredential(tokenResponse, userId);
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to retrieve credential", (Throwable)e);
        }
    }

    @Override
    public Credential loadCredential(String user) {
        String userId = this.getServiceUserId(user);
        try {
            return userId != null ? this.getAuthorizationCodeFlow().loadCredential(userId) : null;
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to load credential for " + user, (Throwable)e);
        }
    }

    protected String getServiceUserId(String key) {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("nuxeoLogin", (Serializable)((Object)key));
        return this.getServiceUserStore().find(filter);
    }

    protected String getOrCreateServiceUser(HttpServletRequest request, String accessToken) throws IOException {
        String nuxeoLogin = request.getUserPrincipal().getName();
        String userId = this.getServiceUserId(nuxeoLogin);
        if (userId == null) {
            userId = this.getServiceUserStore().store(nuxeoLogin);
        }
        return userId;
    }

    public AuthorizationCodeFlow getAuthorizationCodeFlow() {
        Credential.AccessMethod method = BearerToken.authorizationHeaderAccessMethod();
        GenericUrl tokenServerUrl = new GenericUrl(this.tokenServerURL);
        ClientParametersAuthentication clientAuthentication = new ClientParametersAuthentication(this.clientId, this.clientSecret);
        String authorizationServerUrl = this.authorizationServerURL;
        return new AuthorizationCodeFlow.Builder(method, HTTP_TRANSPORT, JSON_FACTORY, tokenServerUrl, (HttpExecuteInterceptor)clientAuthentication, this.clientId, authorizationServerUrl).setScopes(this.scopes).setCredentialDataStore((DataStore)this.getCredentialDataStore()).build();
    }

    protected OAuth2ServiceUserStore getServiceUserStore() {
        if (this.serviceUserStore == null) {
            this.serviceUserStore = new OAuth2ServiceUserStore(this.serviceName);
        }
        return this.serviceUserStore;
    }

    public OAuth2TokenStore getCredentialDataStore() {
        if (this.tokenStore == null) {
            this.tokenStore = new OAuth2TokenStore(this.serviceName);
        }
        return this.tokenStore;
    }

    protected String getError(HttpServletRequest request) {
        String error = request.getParameter(ERROR_URL_PARAMETER);
        return StringUtils.isBlank((String)error) ? null : error;
    }

    protected String getAuthorizationCode(HttpServletRequest request) {
        String code = request.getParameter(CODE_URL_PARAMETER);
        return StringUtils.isBlank((String)code) ? null : code;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTokenServerURL() {
        return this.tokenServerURL;
    }

    @Override
    public String getUserAuthorizationURL() {
        return this.userAuthorizationURL;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getAuthorizationServerURL() {
        return this.authorizationServerURL;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isProviderAvailable() {
        return this.isEnabled() && this.getClientSecret() != null && this.getClientId() != null;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setTokenServerURL(String tokenServerURL) {
        this.tokenServerURL = tokenServerURL;
    }

    @Override
    public void setUserAuthorizationURL(String userAuthorizationURL) {
        this.userAuthorizationURL = userAuthorizationURL;
    }

    @Override
    public void setAuthorizationServerURL(String authorizationServerURL) {
        this.authorizationServerURL = authorizationServerURL;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public void setScopes(String ... scopes) {
        this.scopes = scopes == null ? Collections.emptyList() : Arrays.asList(scopes);
    }
}

