/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.request;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public abstract class OAuth2Request {
    protected String clientId;
    protected String redirectURI;

    public OAuth2Request() {
    }

    public OAuth2Request(HttpServletRequest request) {
        this.clientId = request.getParameter("client_id");
        this.redirectURI = OAuth2Request.decodeParameter(request, "redirect_uri");
        if (StringUtils.isBlank((String)this.redirectURI)) {
            this.redirectURI = OAuth2Request.decodeParameter(request, "redirect_url");
        }
    }

    public static String decodeParameter(HttpServletRequest request, String parameterName) {
        String value = request.getParameter(parameterName);
        try {
            if (StringUtils.isNotBlank((String)value)) {
                return URLDecoder.decode(value, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public String getClientId() {
        return this.clientId;
    }
}

