/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.GroupByClause;
import org.nuxeo.ecm.core.query.sql.model.HavingClause;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.OperandList;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.QueryTransformer;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.ReferenceList;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.SelectList;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;

public class IdentityQueryTransformer
implements QueryTransformer {
    @Override
    public SQLQuery transform(SQLQuery node) {
        SelectClause select = this.transform(node.select);
        FromClause from = this.transform(node.from);
        WhereClause where = this.transform(node.where);
        GroupByClause groupBy = this.transform(node.groupBy);
        HavingClause having = this.transform(node.having);
        OrderByClause orderBy = this.transform(node.orderBy);
        long limit = this.transformLimit(node.limit);
        long offset = this.transformOffset(node.offset);
        return new SQLQuery(select, from, where, groupBy, having, orderBy, limit, offset);
    }

    @Override
    public SelectClause transform(SelectClause node) {
        return new SelectClause(this.transform(node.elements), node.distinct);
    }

    @Override
    public SelectList transform(SelectList node) {
        SelectList list = new SelectList();
        for (Map.Entry es : node.entrySet()) {
            list.put(es.getKey(), this.transform((Operand)es.getValue()));
        }
        return list;
    }

    @Override
    public FromClause transform(FromClause node) {
        return new FromClause(this.transform(node.elements));
    }

    @Override
    public FromList transform(FromList node) {
        FromList list = new FromList();
        list.putAll(node);
        return list;
    }

    @Override
    public WhereClause transform(WhereClause node) {
        return new WhereClause(this.transform(node.predicate));
    }

    @Override
    public GroupByClause transform(GroupByClause node) {
        if (node == null) {
            return null;
        }
        String[] elements = node.elements;
        if (elements != null) {
            return new GroupByClause(Arrays.asList(elements));
        }
        return new GroupByClause();
    }

    @Override
    public HavingClause transform(HavingClause node) {
        if (node == null) {
            return null;
        }
        return new HavingClause(this.transform(node.predicate));
    }

    @Override
    public OrderByClause transform(OrderByClause node) {
        if (node == null) {
            return null;
        }
        return new OrderByClause(this.transform(node.elements));
    }

    @Override
    public OrderByList transform(OrderByList node) {
        OrderByList list = new OrderByList(null);
        list.clear();
        for (OrderByExpr value : node) {
            list.add(this.transform(value));
        }
        return list;
    }

    @Override
    public OrderByExpr transform(OrderByExpr node) {
        return new OrderByExpr(this.transform(node.reference), node.isDescending);
    }

    @Override
    public long transformLimit(long limit) {
        return limit;
    }

    @Override
    public long transformOffset(long offset) {
        return offset;
    }

    @Override
    public Operand transform(Operand node) {
        if (node instanceof Literal) {
            return this.transform((Literal)node);
        }
        if (node instanceof LiteralList) {
            return this.transform((LiteralList)node);
        }
        if (node instanceof Function) {
            return this.transform((Function)node);
        }
        if (node instanceof Expression) {
            return this.transform((Expression)node);
        }
        if (node instanceof Reference) {
            return this.transform((Reference)node);
        }
        throw new QueryParseException("Unknown operand: " + node);
    }

    @Override
    public Expression transform(Expression node) {
        Expression expr = new Expression(this.transform(node.lvalue), this.transform(node.operator), this.transform(node.rvalue));
        expr.info = node.info;
        return expr;
    }

    @Override
    public Expression transform(MultiExpression node) {
        ArrayList<Operand> list = new ArrayList<Operand>(node.values.size());
        for (Operand o : node.values) {
            list.add(this.transform(o));
        }
        MultiExpression expr = new MultiExpression(this.transform(node.operator), list);
        expr.info = node.info;
        return expr;
    }

    @Override
    public Operator transform(Operator node) {
        return node;
    }

    @Override
    public Reference transform(Reference node) {
        Reference ref = new Reference(node.name, node.cast, node.esHint);
        ref.info = node.info;
        return ref;
    }

    @Override
    public ReferenceList transform(ReferenceList node) {
        ReferenceList list = new ReferenceList();
        for (Reference ref : node) {
            list.add(this.transform(ref));
        }
        return list;
    }

    @Override
    public Operand transform(Function node) {
        return new Function(node.name, this.transform(node.args));
    }

    @Override
    public OperandList transform(OperandList node) {
        OperandList list = new OperandList();
        for (Operand oper : node) {
            list.add(this.transform(oper));
        }
        return list;
    }

    @Override
    public Literal transform(Literal node) {
        if (node instanceof BooleanLiteral) {
            return this.transform((BooleanLiteral)node);
        }
        if (node instanceof DateLiteral) {
            return this.transform((DateLiteral)node);
        }
        if (node instanceof DoubleLiteral) {
            return this.transform((DoubleLiteral)node);
        }
        if (node instanceof IntegerLiteral) {
            return this.transform((IntegerLiteral)node);
        }
        if (node instanceof StringLiteral) {
            return this.transform((StringLiteral)node);
        }
        throw new QueryParseException("Unknown literal: " + node);
    }

    @Override
    public LiteralList transform(LiteralList node) {
        LiteralList list = new LiteralList();
        for (Literal lit : node) {
            list.add(this.transform(lit));
        }
        return list;
    }

    @Override
    public Literal transform(BooleanLiteral node) {
        return node;
    }

    @Override
    public Literal transform(DateLiteral node) {
        return node;
    }

    @Override
    public Literal transform(DoubleLiteral node) {
        return node;
    }

    @Override
    public Literal transform(IntegerLiteral node) {
        return node;
    }

    @Override
    public Literal transform(StringLiteral node) {
        return node;
    }
}

