/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskPersisterDescriptor;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskProviderDescriptor;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.service.CreateTaskUnrestricted;
import org.nuxeo.ecm.platform.task.core.service.TaskEventNotificationHelper;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class TaskServiceImpl
extends DefaultComponent
implements TaskService {
    private static final long serialVersionUID = 1L;
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.task.core.TaskService");
    public static final String DEFAULT_TASK_PROVIDER = "documentTaskProvider";
    private static final String TASK_PROVIDER_XP = "taskProvider";
    private static final String TASK_PERSISTER_XP = "taskPersister";
    private Map<String, TaskProvider> tasksProviders;
    private String parentPath = "/task-root";

    public void activate(ComponentContext context) {
        super.activate(context);
        this.tasksProviders = new HashMap<String, TaskProvider>();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.tasksProviders = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(TASK_PROVIDER_XP)) {
            if (contribution instanceof TaskProviderDescriptor) {
                TaskProviderDescriptor taskProviderDescriptor = (TaskProviderDescriptor)contribution;
                String providerId = taskProviderDescriptor.getId();
                if (taskProviderDescriptor.isEnabled().booleanValue()) {
                    this.tasksProviders.put(providerId, taskProviderDescriptor.getNewInstance());
                } else if (this.tasksProviders.get(providerId) != null) {
                    this.tasksProviders.remove(providerId);
                }
            }
        } else if (extensionPoint.equals(TASK_PERSISTER_XP) && contribution instanceof TaskPersisterDescriptor) {
            TaskPersisterDescriptor taskPersisterDescriptor = (TaskPersisterDescriptor)contribution;
            this.parentPath = taskPersisterDescriptor.getPath();
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        TaskProviderDescriptor taskProviderDescriptor;
        String providerId;
        if (extensionPoint.equals(TASK_PROVIDER_XP) && contribution instanceof TaskProviderDescriptor && this.tasksProviders.get(providerId = (taskProviderDescriptor = (TaskProviderDescriptor)contribution).getId()) != null) {
            this.tasksProviders.remove(providerId);
        }
    }

    public List<Task> createTask(CoreSession coreSession, NuxeoPrincipal principal, DocumentModel document, String taskName, List<String> actorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) {
        return this.createTask(coreSession, principal, document, taskName, null, null, actorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
    }

    public List<Task> createTask(CoreSession coreSession, NuxeoPrincipal principal, DocumentModel document, String taskDocumentType, String taskName, String taskType, String processId, List<String> actorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath, Map<String, Serializable> eventInfo) {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        docs.add(document);
        return this.createTaskForProcess(coreSession, principal, docs, taskDocumentType, taskName, taskType, processId, null, actorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath, eventInfo);
    }

    public List<Task> createTask(CoreSession coreSession, NuxeoPrincipal principal, DocumentModel document, String taskName, String taskType, String processId, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) {
        return this.createTask(coreSession, principal, document, "TaskDoc", taskName, taskType, processId, prefixedActorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath, null);
    }

    public String acceptTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment) {
        return this.endTask(coreSession, principal, task, comment, "workflowTaskCompleted", true);
    }

    public String rejectTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment) {
        return this.endTask(coreSession, principal, task, comment, "workflowTaskRejected", false);
    }

    public String endTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment, String eventName, boolean isValidated) {
        TaskProvider taskProvider;
        if (!this.canEndTask(principal, task)) {
            throw new NuxeoException(String.format("User with id '%s' cannot end this task", principal.getName()));
        }
        String taskProviderId = task.getVariable("taskProviderId");
        if (taskProviderId == null) {
            taskProviderId = DEFAULT_TASK_PROVIDER;
        }
        if ((taskProvider = this.tasksProviders.get(taskProviderId)) == null) {
            throw new NuxeoException(String.format("No task provider registered, cannot end task. Please contribute at least the default task provider: %s.", DEFAULT_TASK_PROVIDER));
        }
        return taskProvider.endTask(coreSession, principal, task, comment, eventName, isValidated);
    }

    public boolean canEndTask(NuxeoPrincipal principal, Task task) {
        if (task != null && !task.isCancelled().booleanValue() && !task.hasEnded().booleanValue()) {
            return principal.isAdministrator() || principal.getName().equals(task.getInitiator()) || this.isTaskAssignedToUser(task, principal, true);
        }
        return false;
    }

    protected boolean isTaskAssignedToUser(Task task, NuxeoPrincipal user, boolean checkDelegatedActors) {
        if (task != null && user != null) {
            List actors = user.getAllGroups();
            actors.add(user.getName());
            if (actors.contains(task.getInitiator())) {
                return true;
            }
            List users = task.getActors();
            if (checkDelegatedActors) {
                users.addAll(task.getDelegatedActors());
            }
            if (users != null) {
                for (String userName : users) {
                    if (!(userName.startsWith("user:") ? actors.contains(userName.substring("user:".length())) : (userName.startsWith("group:") ? actors.contains(userName.substring("group:".length())) : actors.contains(userName)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Task getTask(CoreSession coreSession, String taskId) {
        Task task;
        IdRef docRef = new IdRef(taskId);
        DocumentModel taskDoc = coreSession.getDocument((DocumentRef)docRef);
        if (taskDoc != null && (task = (Task)taskDoc.getAdapter(Task.class)) != null) {
            return task;
        }
        return null;
    }

    public void deleteTask(CoreSession coreSession, String taskId) {
        IdRef docRef = new IdRef(taskId);
        UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(coreSession, (DocumentRef)docRef){
            final /* synthetic */ DocumentRef val$docRef;
            {
                this.val$docRef = documentRef;
                super(x0);
            }

            public void run() {
                this.session.removeDocument(this.val$docRef);
            }
        };
        runner.runUnrestricted();
    }

    public DocumentModel getTargetDocumentModel(Task task, CoreSession coreSession) {
        try {
            return coreSession.getDocument((DocumentRef)new IdRef((String)task.getTargetDocumentsIds().get(0)));
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    public List<Task> getCurrentTaskInstances(CoreSession coreSession) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getCurrentTaskInstances(coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getCurrentTaskInstances(CoreSession coreSession, List<SortInfo> sortInfos) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getCurrentTaskInstances(coreSession, sortInfos);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getAllCurrentTaskInstances(CoreSession coreSession, List<SortInfo> sortInfos) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getAllCurrentTaskInstances(coreSession, sortInfos);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getCurrentTaskInstances(actors, coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession, List<SortInfo> sortInfos) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getCurrentTaskInstances(actors, coreSession, sortInfos);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getTaskInstances(DocumentModel dm, NuxeoPrincipal user, CoreSession coreSession) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getTaskInstances(dm, user, coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, CoreSession coreSession) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getTaskInstances(dm, actors, coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getAllTaskInstances(String processId, CoreSession session) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getAllTaskInstances(processId, session);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getAllTaskInstances(String processId, NuxeoPrincipal user, CoreSession session) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getAllTaskInstances(processId, user, session);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getAllTaskInstances(String processId, List<String> actors, CoreSession session) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getAllTaskInstances(processId, actors, session);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public String getTaskRootParentPath(CoreSession coreSession) {
        GetTaskRootParentPathUnrestricted runner = new GetTaskRootParentPathUnrestricted(coreSession);
        runner.runUnrestricted();
        return runner.getParentPath();
    }

    public List<Task> getAllTaskInstances(String processId, String nodeId, CoreSession session) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getAllTaskInstances(processId, nodeId, session);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public void reassignTask(CoreSession session, final String taskId, final List<String> newActors, final String comment) {
        new UnrestrictedSessionRunner(session){

            public void run() {
                DocumentModel taskDoc = this.session.getDocument((DocumentRef)new IdRef(taskId));
                Task task = (Task)taskDoc.getAdapter(Task.class);
                if (task == null) {
                    throw new NuxeoException("Invalid taskId: " + taskId);
                }
                List currentAssignees = task.getActors();
                ArrayList<String> currentActors = new ArrayList<String>();
                for (String currentAssignee : currentAssignees) {
                    if (currentAssignee.startsWith("group:") || currentAssignee.startsWith("user:")) {
                        currentActors.add(currentAssignee.substring(currentAssignee.indexOf(":") + 1));
                        continue;
                    }
                    currentActors.add(currentAssignee);
                }
                String taskInitator = task.getInitiator();
                ACP acp = taskDoc.getACP();
                ACL acl = acp.getOrCreateACL("local");
                ArrayList<ACE> toRemove = new ArrayList<ACE>();
                for (ACE ace : acl.getACEs()) {
                    if (!currentActors.contains(ace.getUsername()) && !taskInitator.equals(ace.getUsername())) continue;
                    toRemove.add(ace);
                }
                acl.removeAll(toRemove);
                ArrayList<String> actorIds = new ArrayList<String>();
                for (String actor : newActors) {
                    if (actor.startsWith("group:") || actor.startsWith("user:")) {
                        actorIds.add(actor.substring(actor.indexOf(":") + 1));
                        continue;
                    }
                    actorIds.add(actor);
                }
                for (String actorId : actorIds) {
                    acl.add(new ACE(actorId, "Everything", true));
                }
                taskDoc.setACP(acp, true);
                task.setActors(actorIds);
                String currentUser = ((NuxeoPrincipal)this.session.getPrincipal()).getActingUser();
                task.addComment(currentUser, comment);
                this.session.saveDocument(taskDoc);
                ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
                for (String string : task.getTargetDocumentsIds()) {
                    docs.add(this.session.getDocument((DocumentRef)new IdRef(string)));
                }
                TaskServiceImpl.this.notifyEvent(this.session, task, docs, "workflowTaskReassigned", new HashMap<String, Serializable>(), comment, (NuxeoPrincipal)this.session.getPrincipal(), actorIds);
            }
        }.runUnrestricted();
    }

    public void delegateTask(CoreSession session, final String taskId, final List<String> delegatedActors, final String comment) {
        new UnrestrictedSessionRunner(session){

            public void run() {
                DocumentModel taskDoc = this.session.getDocument((DocumentRef)new IdRef(taskId));
                Task task = (Task)taskDoc.getAdapter(Task.class);
                if (task == null) {
                    throw new NuxeoException("Invalid taskId: " + taskId);
                }
                ArrayList<String> actorIds = new ArrayList<String>();
                ACP acp = taskDoc.getACP();
                ACL acl = acp.getOrCreateACL("local");
                for (String string : delegatedActors) {
                    if (string.startsWith("group:") || string.startsWith("user:")) {
                        actorIds.add(string.substring(string.indexOf(":") + 1));
                        continue;
                    }
                    actorIds.add(string);
                }
                for (String string : actorIds) {
                    ACE ace = new ACE(string, "Everything", true);
                    if (acl.contains((Object)ace)) continue;
                    acl.add(ace);
                }
                taskDoc.setACP(acp, true);
                ArrayList<String> allDelegatedActors = new ArrayList<String>();
                allDelegatedActors.addAll(task.getDelegatedActors());
                for (String actor : actorIds) {
                    if (allDelegatedActors.contains(actor)) continue;
                    allDelegatedActors.add(actor);
                }
                task.setDelegatedActors(allDelegatedActors);
                String string = ((NuxeoPrincipal)this.session.getPrincipal()).getActingUser();
                task.addComment(string, comment);
                this.session.saveDocument(taskDoc);
                ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
                for (String string2 : task.getTargetDocumentsIds()) {
                    docs.add(this.session.getDocument((DocumentRef)new IdRef(string2)));
                }
                TaskServiceImpl.this.notifyEvent(this.session, task, docs, "workflowTaskDelegated", new HashMap<String, Serializable>(), String.format("Task delegated by '%s' to '%s'", string, StringUtils.join(actorIds, (String)",")) + (!StringUtils.isEmpty((String)comment) ? " with the following comment: " + comment : ""), (NuxeoPrincipal)this.session.getPrincipal(), actorIds);
            }
        }.runUnrestricted();
    }

    protected void notifyEvent(CoreSession session, Task task, List<DocumentModel> docs, String event, Map<String, Serializable> eventInfo, String comment, NuxeoPrincipal principal, List<String> actorIds) {
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        ArrayList<String> notificationRecipients = new ArrayList<String>();
        notificationRecipients.addAll(actorIds);
        eventProperties.put("recipients", (Serializable)notificationRecipients.toArray(new String[notificationRecipients.size()]));
        if (eventInfo != null) {
            eventProperties.putAll(eventInfo);
        }
        for (DocumentModel doc : docs) {
            TaskEventNotificationHelper.notifyEvent(session, doc, principal, task, event, eventProperties, comment, null);
        }
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, boolean includeDelegatedTasks, CoreSession session) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            tasks.addAll(taskProvider.getTaskInstances(dm, actors, includeDelegatedTasks, session));
        }
        return tasks;
    }

    @Deprecated
    public List<Task> createTask(CoreSession coreSession, NuxeoPrincipal principal, List<DocumentModel> documents, String taskDocumentType, String taskName, String taskType, String processId, List<String> actorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath, Map<String, Serializable> eventInfo) {
        return this.createTaskForProcess(coreSession, principal, documents, taskDocumentType, taskName, taskType, processId, null, actorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath, eventInfo);
    }

    public List<Task> createTaskForProcess(CoreSession coreSession, NuxeoPrincipal principal, List<DocumentModel> documents, String taskDocumentType, String taskName, String taskType, String processId, String processName, List<String> actorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath, Map<String, Serializable> eventInfo) {
        if (StringUtils.isBlank((String)parentPath)) {
            parentPath = this.getTaskRootParentPath(coreSession);
        }
        CreateTaskUnrestricted runner = new CreateTaskUnrestricted(coreSession, principal, documents, taskDocumentType, taskName, taskType, processId, processName, actorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
        runner.runUnrestricted();
        List<Task> tasks = runner.getTasks();
        for (Task task : tasks) {
            this.notifyEvent(coreSession, task, documents, "workflowTaskAssigned", eventInfo, comment, principal, task.getActors());
        }
        return tasks;
    }

    public class GetTaskRootParentPathUnrestricted
    extends UnrestrictedSessionRunner {
        protected DocumentModel taskRootDoc;

        public GetTaskRootParentPathUnrestricted(CoreSession session) {
            super(session);
        }

        public void run() {
            PathRef pathRef = new PathRef(TaskServiceImpl.this.parentPath);
            if (this.session.exists((DocumentRef)pathRef)) {
                this.taskRootDoc = this.session.getDocument((DocumentRef)pathRef);
            } else {
                Path path = new Path(TaskServiceImpl.this.parentPath);
                this.taskRootDoc = this.session.createDocumentModel(path.removeLastSegments(1).toString(), path.lastSegment(), "TaskRoot");
                this.taskRootDoc = this.session.createDocument(this.taskRootDoc);
                ACP acp = this.taskRootDoc.getACP();
                ACL acl = acp.getOrCreateACL("local");
                acl.add(new ACE("Everyone", "Everything", false));
                this.taskRootDoc.setACP(acp, true);
                this.taskRootDoc = this.session.saveDocument(this.taskRootDoc);
            }
        }

        public DocumentModel getTaskRootDoc() {
            return this.taskRootDoc;
        }

        public String getParentPath() {
            return this.taskRootDoc.getPathAsString();
        }
    }
}

