/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.migration;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="migration")
public class MigrationDescriptor {
    @XNode(value="@id")
    public String id;
    @XNode(value="description@label")
    public String descriptionLabel;
    @XNode(value="description")
    public String description;
    @XNode(value="statusChangeNotifier")
    public Class<?> statusChangeNotifierClass;
    @XNode(value="defaultState")
    public String defaultState;
    @XNodeMap(value="state", key="@id", type=LinkedHashMap.class, componentType=MigrationStateDescriptor.class)
    public Map<String, MigrationStateDescriptor> states = new LinkedHashMap<String, MigrationStateDescriptor>();
    @XNodeMap(value="step", key="@id", type=LinkedHashMap.class, componentType=MigrationStepDescriptor.class)
    public Map<String, MigrationStepDescriptor> steps = new LinkedHashMap<String, MigrationStepDescriptor>();

    public String getId() {
        return this.id;
    }

    public String getDescriptionLabel() {
        return this.descriptionLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<?> getStatusChangeNotifierClass() {
        return this.statusChangeNotifierClass;
    }

    public String getDefaultState() {
        return this.defaultState;
    }

    public Map<String, MigrationStateDescriptor> getStates() {
        return this.states;
    }

    public Map<String, MigrationStepDescriptor> getSteps() {
        return this.steps;
    }

    public MigrationDescriptor() {
    }

    public MigrationDescriptor(MigrationDescriptor other) {
        this.id = other.id;
        this.descriptionLabel = other.descriptionLabel;
        this.statusChangeNotifierClass = other.statusChangeNotifierClass;
        this.description = other.description;
        this.defaultState = other.defaultState;
        this.states = new LinkedHashMap<String, MigrationStateDescriptor>(other.states);
        this.steps = new LinkedHashMap<String, MigrationStepDescriptor>(other.steps);
    }

    public void merge(MigrationDescriptor other) {
        if (other.descriptionLabel != null) {
            this.descriptionLabel = other.descriptionLabel;
        }
        if (other.description != null) {
            this.description = other.description;
        }
        if (other.statusChangeNotifierClass != null) {
            this.statusChangeNotifierClass = other.statusChangeNotifierClass;
        }
        if (other.defaultState != null) {
            this.defaultState = other.defaultState;
        }
        this.states.putAll(other.states);
        this.steps.putAll(other.steps);
    }

    @XObject(value="step")
    public static class MigrationStepDescriptor {
        @XNode(value="@id")
        public String id;
        @XNode(value="@fromState")
        public String fromState;
        @XNode(value="@toState")
        public String toState;
        @XNode(value="description@label")
        public String descriptionLabel;
        @XNode(value="description")
        public String description;
        @XNode(value="class")
        public Class<?> klass;

        public String getId() {
            return this.id;
        }

        public String getFromState() {
            return this.fromState;
        }

        public String getToState() {
            return this.toState;
        }

        public String getDescriptionLabel() {
            return this.descriptionLabel;
        }

        public String getDescription() {
            return this.description;
        }

        public Class<?> getKlass() {
            return this.klass;
        }
    }

    @XObject(value="state")
    public static class MigrationStateDescriptor {
        @XNode(value="@id")
        public String id;
        @XNode(value="description@label")
        public String descriptionLabel;
        @XNode(value="description")
        public String description;

        public String getId() {
            return this.id;
        }

        public String getDescriptionLabel() {
            return this.descriptionLabel;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

