/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;

@Operation(id="Context.SetWorkflowVar", category="Workflow Context", label="Set Workflow Variable", requires="Workflow", description="Set a workflow variable. The workflow variable must exists on the workflow. If no workflowId is specified the variable is set on the current workflow.To compute the value at runtime from the current context you should use a MVEL expression as the value. This operation works on any input type and return back the input as the output.")
public class SetWorkflowVar {
    public static final String ID = "Context.SetWorkflowVar";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="name")
    protected String name;
    @Param(name="value", required=false)
    protected Object value;
    @Param(name="workflowInstanceId", required=false)
    protected String workflowInstanceId;

    @OperationMethod
    public void run() {
        if (this.ctx.get((Object)"WorkflowVariables") != null) {
            ((Map)this.ctx.get((Object)"WorkflowVariables")).put(this.name, (Serializable)this.value);
            return;
        }
        if (this.workflowInstanceId == null && this.ctx.get((Object)"workflowInstanceId") != null) {
            this.workflowInstanceId = (String)this.ctx.get((Object)"workflowInstanceId");
        }
        if (this.workflowInstanceId == null) {
            return;
        }
        DocumentModel workflowInstance = this.session.getDocument((DocumentRef)new IdRef(this.workflowInstanceId));
        GraphRoute graph = (GraphRoute)workflowInstance.getAdapter(GraphRoute.class);
        Map<String, Serializable> vars = graph.getVariables();
        vars.put(this.name, (Serializable)this.value);
        graph.setVariables(vars);
    }
}

