/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.audit;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.runtime.api.Framework;

public final class RoutingAuditHelper {
    public static final String TIME_SINCE_WF_STARTED = "timeSinceWfStarted";
    public static final String TIME_SINCE_TASK_STARTED = "timeSinceTaskStarted";
    public static final String TASK_ACTOR = "taskActor";
    public static final String WORKFLOW_INITATIOR = "workflowInitiator";
    public static final String WORKFLOW_VARIABLES = "workflowVariables";

    public static long computeElapsedTime(DocumentRoutingConstants.Events event, String elementId) {
        Logs logs = (Logs)Framework.getService(Logs.class);
        if (logs != null && StringUtils.isNotBlank((String)elementId)) {
            HashMap<String, FilterMapEntry> filterMap = new HashMap<String, FilterMapEntry>();
            FilterMapEntry categoryFilterMapEntry = new FilterMapEntry();
            categoryFilterMapEntry.setColumnName("category");
            categoryFilterMapEntry.setOperator("=");
            categoryFilterMapEntry.setQueryParameterName("category");
            categoryFilterMapEntry.setObject((Object)"Routing");
            filterMap.put("category", categoryFilterMapEntry);
            FilterMapEntry eventIdFilterMapEntry = new FilterMapEntry();
            eventIdFilterMapEntry.setColumnName("eventId");
            eventIdFilterMapEntry.setOperator("=");
            eventIdFilterMapEntry.setQueryParameterName("eventId");
            eventIdFilterMapEntry.setObject((Object)event.name());
            filterMap.put("eventId", eventIdFilterMapEntry);
            List logEntries = logs.getLogEntriesFor(elementId, filterMap, true);
            Iterator iterator = logEntries.iterator();
            if (iterator.hasNext()) {
                LogEntry logEntry = (LogEntry)iterator.next();
                Date start = logEntry.getEventDate();
                return new Date().getTime() - start.getTime();
            }
        }
        return -1L;
    }

    public static long computeDurationSinceWfStarted(String workflowInstanceId) {
        return RoutingAuditHelper.computeElapsedTime(DocumentRoutingConstants.Events.afterWorkflowStarted, workflowInstanceId);
    }

    public static long computeDurationSinceTaskStarted(String taskId) {
        return RoutingAuditHelper.computeElapsedTime(DocumentRoutingConstants.Events.afterWorkflowTaskCreated, taskId);
    }
}

