/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.scripting.DateWrapper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.api.TasksInfoWrapper;
import org.nuxeo.ecm.platform.routing.core.api.scripting.RoutingScriptingExpression;
import org.nuxeo.ecm.platform.routing.core.api.scripting.RoutingScriptingFunctions;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteElementImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRouteImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphVariablesUtil;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

public class GraphNodeImpl
extends DocumentRouteElementImpl
implements GraphNode {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GraphNodeImpl.class);
    private static final String EXPR_PREFIX = "expr:";
    private static final String TEMPLATE_START = "@{";
    protected final GraphRouteImpl graph;
    protected GraphNode.State localState;
    protected List<GraphNode.Transition> inputTransitions;
    protected List<GraphNode.Transition> outputTransitions;
    protected List<GraphNode.Button> taskButtons;
    protected List<GraphNode.EscalationRule> escalationRules;
    protected List<GraphNode.TaskInfo> tasksInfo;

    public GraphNodeImpl(DocumentModel doc, GraphRouteImpl graph) {
        super(doc, new GraphRunner());
        this.graph = graph;
        this.inputTransitions = new ArrayList<GraphNode.Transition>(2);
    }

    public GraphNodeImpl(DocumentModel doc) {
        super(doc, new GraphRunner());
        this.graph = (GraphRouteImpl)this.getDocumentRoute(doc.getCoreSession());
        this.inputTransitions = new ArrayList<GraphNode.Transition>(2);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getId()).toString();
    }

    protected boolean getBoolean(String propertyName) {
        return Boolean.TRUE.equals(this.getProperty(propertyName));
    }

    protected void incrementProp(String prop) {
        Long count = (Long)this.getProperty(prop);
        if (count == null) {
            count = 0L;
        }
        this.document.setPropertyValue(prop, (Serializable)Long.valueOf(count + 1L));
        this.saveDocument();
    }

    protected CoreSession getSession() {
        return this.document.getCoreSession();
    }

    protected void saveDocument() {
        this.getSession().saveDocument(this.document);
    }

    @Override
    public String getId() {
        return (String)this.getProperty("rnode:nodeId");
    }

    @Override
    public GraphNode.State getState() {
        if (this.localState != null) {
            return this.localState;
        }
        String s = this.document.getCurrentLifeCycleState();
        return GraphNode.State.fromString(s);
    }

    @Override
    public void setState(GraphNode.State state) {
        if (state == null) {
            throw new NullPointerException("null state");
        }
        String lc = state.getLifeCycleState();
        if (lc == null) {
            this.localState = state;
            return;
        }
        this.localState = null;
        String oldLc = this.document.getCurrentLifeCycleState();
        if (lc.equals(oldLc)) {
            return;
        }
        this.document.followTransition(state.getTransition());
        this.saveDocument();
    }

    @Override
    public boolean isStart() {
        return this.getBoolean("rnode:start");
    }

    @Override
    public boolean isStop() {
        return this.getBoolean("rnode:stop");
    }

    @Override
    public void setCanceled() {
        log.debug((Object)("Canceling " + this));
        this.incrementProp("rnode:canceled");
    }

    @Override
    public long getCanceledCount() {
        Long c = (Long)this.getProperty("rnode:canceled");
        return c == null ? 0L : c;
    }

    @Override
    public boolean isMerge() {
        String merge = (String)this.getProperty("rnode:merge");
        return StringUtils.isNotEmpty((String)merge);
    }

    @Override
    public String getInputChain() {
        return (String)this.getProperty("rnode:inputChain");
    }

    @Override
    public String getOutputChain() {
        return (String)this.getProperty("rnode:outputChain");
    }

    @Override
    public boolean hasTask() {
        return this.getBoolean("rnode:hasTask");
    }

    @Override
    public List<String> getTaskAssignees() {
        return (List)this.getProperty("rnode:taskAssignees");
    }

    public String getTaskAssigneesVar() {
        return (String)this.getProperty("rnode:taskAssigneesExpr");
    }

    @Override
    public Date getTaskDueDate() {
        Calendar cal = (Calendar)this.getProperty("rnode:taskDueDate");
        return cal == null ? null : cal.getTime();
    }

    @Override
    public String getTaskDirective() {
        return (String)this.getProperty("rnode:taskDirective");
    }

    @Override
    public String getTaskAssigneesPermission() {
        return (String)this.getProperty("rnode:taskAssigneesPermission");
    }

    @Override
    public String getTaskLayout() {
        return (String)this.getProperty("rnode:taskLayout");
    }

    @Override
    public String getTaskNotificationTemplate() {
        return (String)this.getProperty("rnode:taskNotificationTemplate");
    }

    @Override
    public String getTaskDueDateExpr() {
        return (String)this.getProperty("rnode:taskDueDateExpr");
    }

    @Override
    public void starting() {
        for (GraphNode.Transition t : this.inputTransitions) {
            t.setResult(false);
            this.getSession().saveDocument(t.source.getDocument());
        }
        this.incrementProp("rnode:count");
        this.document.setPropertyValue("rnode:startDate", (Serializable)Calendar.getInstance());
        this.tasksInfo = null;
        this.document.setPropertyValue("rnode:tasksInfo", new ArrayList());
        this.saveDocument();
    }

    @Override
    public void ending() {
        this.document.setPropertyValue("rnode:endDate", (Serializable)Calendar.getInstance());
        this.saveDocument();
    }

    @Override
    public Map<String, Serializable> getVariables() {
        return GraphVariablesUtil.getVariables(this.document, "rnode:variablesFacet");
    }

    @Override
    public Map<String, Serializable> getJsonVariables() {
        return GraphVariablesUtil.getVariables(this.document, "rnode:variablesFacet", true);
    }

    @Override
    public void setVariables(Map<String, Serializable> map) {
        GraphVariablesUtil.setVariables(this.document, "rnode:variablesFacet", map);
    }

    @Override
    public void setJSONVariables(Map<String, String> map) {
        GraphVariablesUtil.setJSONVariables(this.document, "rnode:variablesFacet", map);
    }

    @Override
    public void setAllVariables(Map<String, Object> map) {
        this.setAllVariables(map, true);
    }

    @Override
    public void setAllVariables(Map<String, Object> map, boolean allowGlobalVariablesAssignement) {
        if (map == null) {
            return;
        }
        Boolean mapToJSON = Boolean.FALSE;
        if (map.containsKey("_MAP_VAR_FORMAT_JSON") && ((Boolean)map.get("_MAP_VAR_FORMAT_JSON")).booleanValue()) {
            mapToJSON = Boolean.TRUE;
        }
        Map<String, Serializable> graphVariables = mapToJSON != false ? this.graph.getJsonVariables() : this.graph.getVariables();
        Map<String, Serializable> nodeVariables = mapToJSON != false ? this.getJsonVariables() : this.getVariables();
        HashMap<String, Serializable> changedGraphVariables = new HashMap<String, Serializable>();
        HashMap<String, Serializable> changedNodeVariables = new HashMap<String, Serializable>();
        if (map.get("NodeVariables") != null) {
            for (Map.Entry es : ((Map)map.get("NodeVariables")).entrySet()) {
                Serializable serializable;
                String key = (String)es.getKey();
                Serializable value = (Serializable)es.getValue();
                if (!nodeVariables.containsKey(key) || GraphNodeImpl.equality(value, serializable = nodeVariables.get(key))) continue;
                changedNodeVariables.put(key, value);
            }
        }
        String transientSchemaName = "var_global_" + this.getId();
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        if (map.get("WorkflowVariables") != null) {
            Schema transientSchema = schemaManager.getSchema(transientSchemaName);
            for (Map.Entry entry : ((Map)map.get("WorkflowVariables")).entrySet()) {
                Serializable oldValue;
                String key = (String)entry.getKey();
                Serializable value = (Serializable)entry.getValue();
                if (!graphVariables.containsKey(key) || GraphNodeImpl.equality(value, oldValue = graphVariables.get(key))) continue;
                if (!allowGlobalVariablesAssignement && transientSchema != null && !transientSchema.hasField(key)) {
                    throw new DocumentRouteException(String.format("You don't have the permission to set the workflow variable %s", key));
                }
                changedGraphVariables.put(key, value);
            }
        }
        if (!allowGlobalVariablesAssignement) {
            DocumentModelImpl transientDocumentModel = new DocumentModelImpl(this.getDocument().getType());
            transientDocumentModel.copyContent(this.document);
            String transientFacetName = "facet-" + transientSchemaName;
            CompositeType compositeType = schemaManager.getFacet(transientFacetName);
            if (compositeType != null) {
                changedGraphVariables.put("_MAP_VAR_FORMAT_JSON", mapToJSON);
                transientDocumentModel.addFacet("facet-" + transientSchemaName);
                GraphVariablesUtil.setVariables((DocumentModel)transientDocumentModel, "facet-" + transientSchemaName, changedGraphVariables, false);
            }
            changedNodeVariables.put("_MAP_VAR_FORMAT_JSON", mapToJSON);
            GraphVariablesUtil.setVariables((DocumentModel)transientDocumentModel, "rnode:variablesFacet", changedNodeVariables, false);
            DocumentValidationService documentValidationService = (DocumentValidationService)Framework.getService(DocumentValidationService.class);
            DocumentValidationReport report = documentValidationService.validate((DocumentModel)transientDocumentModel);
            if (report.hasError()) {
                throw new DocumentValidationException(report);
            }
        }
        if (!changedNodeVariables.isEmpty()) {
            changedNodeVariables.put("_MAP_VAR_FORMAT_JSON", mapToJSON);
            this.setVariables(changedNodeVariables);
        }
        if (!changedGraphVariables.isEmpty()) {
            changedGraphVariables.put("_MAP_VAR_FORMAT_JSON", mapToJSON);
            this.graph.setVariables(changedGraphVariables);
        }
    }

    public static boolean equality(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof List && o2.getClass().isArray()) {
            return Arrays.equals(((List)o1).toArray(), (Object[])o2);
        }
        if (o1.getClass().isArray() && o2 instanceof List) {
            return Arrays.equals((Object[])o1, ((List)o2).toArray());
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        return o1.equals(o2);
    }

    protected OperationContext getExecutionContext(CoreSession session) {
        OperationContext context = new OperationContext(session);
        context.putAll(this.getWorkflowContextualInfo(session, true));
        context.setCommit(false);
        DocumentModelList documents = this.graph.getAttachedDocuments(session);
        context.setInput((Object)documents);
        return context;
    }

    @Override
    public Map<String, Serializable> getWorkflowContextualInfo(CoreSession session, boolean detached) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("WorkflowVariables", (Serializable)((Object)this.graph.getVariables()));
        context.put("workflowInitiator", (Serializable)((Object)this.getWorkflowInitiator()));
        context.put("workflowStartTime", this.getWorkflowStartTime());
        context.put("workflowParent", (Serializable)((Object)this.getWorkflowParentRouteId()));
        context.put("workflowParentNode", (Serializable)((Object)this.getWorkflowParentNodeId()));
        context.put("workflowInstanceId", (Serializable)((Object)this.graph.getDocument().getId()));
        context.put("taskDueTime", (Calendar)this.getProperty("rnode:taskDueDate"));
        DocumentModelList documents = this.graph.getAttachedDocuments(session);
        if (detached) {
            for (DocumentModel documentModel : documents) {
                documentModel.detach(true);
            }
        }
        context.put("workflowDocuments", (Serializable)documents);
        context.put("documents", (Serializable)documents);
        String button = (String)this.getProperty("rnode:button");
        Map<String, Serializable> nodeVariables = this.getVariables();
        nodeVariables.put("button", (Serializable)((Object)button));
        nodeVariables.put("numberOfProcessedTasks", Integer.valueOf(this.getProcessedTasksInfo().size()));
        nodeVariables.put("numberOfTasks", Integer.valueOf(this.getTasksInfo().size()));
        nodeVariables.put("tasks", new TasksInfoWrapper(this.getTasksInfo()));
        context.put("NodeVariables", (Serializable)((Object)nodeVariables));
        context.put("nodeId", (Serializable)((Object)this.getId()));
        String state = this.getState().name().toLowerCase();
        context.put("nodeState", (Serializable)((Object)state));
        context.put("state", (Serializable)((Object)state));
        context.put("nodeStartTime", this.getNodeStartTime());
        context.put("nodeEndTime", this.getNodeEndTime());
        context.put("nodeLastActor", (Serializable)((Object)this.getNodeLastActor()));
        context.put("comment", (Serializable)((Object)""));
        return context;
    }

    protected String getWorkflowInitiator() {
        return (String)((Object)this.graph.getDocument().getPropertyValue("docri:initiator"));
    }

    protected Calendar getWorkflowStartTime() {
        return (Calendar)this.graph.getDocument().getPropertyValue("dc:created");
    }

    protected String getWorkflowParentRouteId() {
        return (String)((Object)this.graph.getDocument().getPropertyValue("docri:parentRouteInstanceId"));
    }

    protected String getWorkflowParentNodeId() {
        return (String)((Object)this.graph.getDocument().getPropertyValue("docri:parentRouteNodeId"));
    }

    protected Calendar getNodeStartTime() {
        return (Calendar)this.getDocument().getPropertyValue("rnode:startDate");
    }

    protected Calendar getNodeEndTime() {
        return (Calendar)this.getDocument().getPropertyValue("rnode:endDate");
    }

    protected String getNodeLastActor() {
        return (String)((Object)this.getDocument().getPropertyValue("rnode:lastActor"));
    }

    @Override
    public void executeChain(String chainId) throws DocumentRouteException {
        this.executeChain(chainId, null);
    }

    @Override
    public void executeTransitionChain(GraphNode.Transition transition) throws DocumentRouteException {
        this.executeChain(transition.chain, transition.id);
    }

    public void executeChain(String chainId, String transitionId) throws DocumentRouteException {
        if (StringUtils.isEmpty((String)chainId)) {
            return;
        }
        try (OperationContext context = this.getExecutionContext(this.getSession());){
            if (transitionId != null) {
                context.put("transition", (Object)transitionId);
            }
            AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
            automationService.run(context, chainId);
            this.setAllVariables((Map<String, Object>)context);
        }
        catch (OperationException e) {
            throw new DocumentRouteException("Error running chain: " + chainId, (Throwable)e);
        }
    }

    @Override
    public void initAddInputTransition(GraphNode.Transition transition) {
        this.inputTransitions.add(transition);
    }

    protected List<GraphNode.Transition> computeOutputTransitions() {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:transitions");
        ArrayList<GraphNode.Transition> trans = new ArrayList<GraphNode.Transition>(props.size());
        for (Property p : props) {
            trans.add(new GraphNode.Transition(this, p));
        }
        return trans;
    }

    @Override
    public List<GraphNode.Transition> getOutputTransitions() {
        if (this.outputTransitions == null) {
            this.outputTransitions = this.computeOutputTransitions();
        }
        return this.outputTransitions;
    }

    @Override
    public List<GraphNode.Transition> evaluateTransitions() throws DocumentRouteException {
        ArrayList<GraphNode.Transition> trueTrans = new ArrayList<GraphNode.Transition>();
        for (GraphNode.Transition t : this.getOutputTransitions()) {
            try {
                OperationContext context = this.getExecutionContext(this.getSession());
                Throwable throwable = null;
                try {
                    context.put("transition", (Object)t.id);
                    RoutingScriptingExpression expr = new RoutingScriptingExpression(t.condition, new RoutingScriptingFunctions(context));
                    Object res = expr.eval(context);
                    if (!(res instanceof Boolean)) {
                        throw new DocumentRouteException("Condition for transition " + t + " of node '" + this.getId() + "' of graph '" + this.graph.getName() + "' does not evaluate to a boolean: " + t.condition);
                    }
                    boolean bool = Boolean.TRUE.equals(res);
                    t.setResult(bool);
                    if (bool) {
                        trueTrans.add(t);
                        if (this.executeOnlyFirstTransition()) break;
                    }
                    this.saveDocument();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                }
            }
            catch (DocumentRouteException e) {
                throw e;
            }
            catch (RuntimeException | OperationException e) {
                if (e instanceof DocumentRouteException) {
                    throw (DocumentRouteException)e;
                }
                throw new DocumentRouteException("Error evaluating condition: " + t.condition, e);
            }
        }
        return trueTrans;
    }

    @Override
    public List<String> evaluateTaskAssignees() throws DocumentRouteException {
        ArrayList<String> taskAssignees = new ArrayList<String>();
        String taskAssigneesVar = this.getTaskAssigneesVar();
        if (StringUtils.isEmpty((String)taskAssigneesVar)) {
            return taskAssignees;
        }
        try (OperationContext context = this.getExecutionContext(this.getSession());){
            Expression expr = Scripting.newExpression((String)taskAssigneesVar);
            Object[] res = expr.eval(context);
            if (res instanceof List) {
                res = ((List)res).toArray();
            }
            if (res instanceof Object[]) {
                Object[] list = res;
                String[] tmp = new String[list.length];
                try {
                    System.arraycopy(list, 0, tmp, 0, list.length);
                    res = tmp;
                }
                catch (ArrayStoreException arrayStoreException) {
                    // empty catch block
                }
            }
            if (!(res instanceof String) && !(res instanceof String[])) {
                throw new DocumentRouteException("Can not evaluate task assignees from " + taskAssigneesVar);
            }
            if (res instanceof String) {
                taskAssignees.add((String)res);
            } else {
                taskAssignees.addAll(Arrays.asList((String[])res));
            }
        }
        catch (DocumentRouteException e) {
            throw e;
        }
        catch (RuntimeException | OperationException e) {
            throw new DocumentRouteException("Error evaluating task assignees: " + taskAssigneesVar, e);
        }
        return taskAssignees;
    }

    @Override
    public boolean canMerge() {
        int n = 0;
        List<GraphNode.Transition> inputTransitions = this.getInputTransitions();
        for (GraphNode.Transition t : inputTransitions) {
            if (!t.result) continue;
            ++n;
        }
        String merge = (String)this.getProperty("rnode:merge");
        if ("one".equals(merge)) {
            return n > 0;
        }
        if ("all".equals(merge)) {
            return n == inputTransitions.size();
        }
        throw new NuxeoException("Illegal merge mode '" + merge + "' for node " + this);
    }

    @Override
    public List<GraphNode.Transition> getInputTransitions() {
        return this.inputTransitions;
    }

    @Override
    public void cancelTasks() {
        CoreSession session = this.getSession();
        List<GraphNode.TaskInfo> tasks = this.getTasksInfo();
        for (GraphNode.TaskInfo task : tasks) {
            if (task.isEnded()) continue;
            this.cancelTask(session, task.getTaskDocId());
        }
    }

    @Override
    public List<GraphNode.Button> getTaskButtons() {
        if (this.taskButtons == null) {
            this.taskButtons = this.computeTaskButtons();
        }
        return this.taskButtons;
    }

    protected List<GraphNode.Button> computeTaskButtons() {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:taskButtons");
        ArrayList<GraphNode.Button> btns = new ArrayList<GraphNode.Button>(props.size());
        for (Property p : props) {
            btns.add(new GraphNode.Button(this, p));
        }
        Collections.sort(btns);
        return btns;
    }

    @Override
    public void setButton(String status) {
        this.document.setPropertyValue("rnode:button", (Serializable)((Object)status));
        this.saveDocument();
    }

    @Override
    public void setLastActor(String actor) {
        this.document.setPropertyValue("rnode:lastActor", (Serializable)((Object)actor));
        this.saveDocument();
    }

    protected void addTaskAssignees(List<String> taskAssignees) {
        List<String> allTasksAssignees = this.getTaskAssignees();
        allTasksAssignees.addAll(taskAssignees);
        this.document.setPropertyValue("rnode:taskAssignees", (Serializable)((Object)allTasksAssignees));
        this.saveDocument();
    }

    @Override
    public String getTaskDocType() {
        String taskDocType = (String)this.getProperty("rnode:taskDocType");
        if (StringUtils.isEmpty((String)taskDocType) || "TaskDoc".equals(taskDocType)) {
            taskDocType = "RoutingTask";
        }
        return taskDocType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Date evaluateDueDate() throws DocumentRouteException {
        String taskDueDateExpr = this.getTaskDueDateExpr();
        if (StringUtils.isEmpty((String)taskDueDateExpr)) {
            return new Date();
        }
        try (OperationContext context = this.getExecutionContext(this.getSession());){
            Expression expr = Scripting.newExpression((String)taskDueDateExpr);
            Object res = expr.eval(context);
            if (res instanceof DateWrapper) {
                Date date = ((DateWrapper)res).getDate();
                return date;
            }
            if (res instanceof Date) {
                Date date = (Date)res;
                return date;
            }
            if (res instanceof Calendar) {
                Date date = ((Calendar)res).getTime();
                return date;
            }
            if (res instanceof String) {
                Date date = DateParser.parseW3CDateTime((String)((String)res));
                return date;
            }
            throw new DocumentRouteException("The following expression can not be evaluated to a date: " + taskDueDateExpr);
        }
        catch (DocumentRouteException e) {
            throw e;
        }
        catch (RuntimeException | OperationException e) {
            throw new DocumentRouteException("Error evaluating task due date: " + taskDueDateExpr, e);
        }
    }

    @Override
    public Date computeTaskDueDate() throws DocumentRouteException {
        Date dueDate = this.evaluateDueDate();
        this.document.setPropertyValue("rnode:taskDueDate", (Serializable)dueDate);
        CoreSession session = this.document.getCoreSession();
        session.saveDocument(this.document);
        return dueDate;
    }

    @Override
    public boolean executeOnlyFirstTransition() {
        return this.getBoolean("rnode:executeOnlyFirstTransition");
    }

    @Override
    public boolean hasSubRoute() throws DocumentRouteException {
        return this.getSubRouteModelId() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSubRouteModelId() throws DocumentRouteException {
        String subRouteModelExpr = (String)this.getProperty("rnode:subRouteModelExpr");
        if (StringUtils.isBlank((String)subRouteModelExpr)) {
            return null;
        }
        try (OperationContext context = this.getExecutionContext(this.getSession());){
            String res = this.valueOrExpression(String.class, subRouteModelExpr, context, "Sub-workflow id expression");
            String string = StringUtils.defaultIfBlank((String)res, null);
            return string;
        }
        catch (OperationException e) {
            throw new DocumentRouteException("Cannot get sub route id for " + this.getId(), (Throwable)e);
        }
    }

    protected String getSubRouteInstanceId() {
        return (String)this.getProperty("rnode:subRouteInstanceId");
    }

    @Override
    public DocumentRoute startSubRoute() throws DocumentRouteException {
        String subRouteModelId = this.getSubRouteModelId();
        DocumentRoutingService service = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        List<String> docs = this.graph.getAttachedDocuments();
        String subRouteInstanceId = service.createNewInstance(subRouteModelId, docs, this.getSession(), false);
        DocumentModel subRouteInstance = this.getSession().getDocument((DocumentRef)new IdRef(subRouteInstanceId));
        subRouteInstance.setPropertyValue("docri:parentRouteInstanceId", (Serializable)((Object)this.getDocument().getParentRef().toString()));
        subRouteInstance.setPropertyValue("docri:parentRouteNodeId", (Serializable)((Object)this.getDocument().getName()));
        subRouteInstance = this.getSession().saveDocument(subRouteInstance);
        this.document.setPropertyValue("rnode:subRouteInstanceId", (Serializable)((Object)subRouteInstanceId));
        this.saveDocument();
        Map<String, Serializable> map = this.getSubRouteInitialVariables();
        service.startInstance(subRouteInstanceId, docs, map, this.getSession());
        DocumentRoute subRoute = (DocumentRoute)subRouteInstance.getAdapter(DocumentRoute.class);
        return subRoute;
    }

    protected Map<String, Serializable> getSubRouteInitialVariables() {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:subRouteVariables");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try (OperationContext context = this.getExecutionContext(this.getSession());){
            for (Property p : props) {
                MapProperty prop = (MapProperty)p;
                String key = (String)((Object)prop.get("key").getValue());
                String v = (String)((Object)prop.get("value").getValue());
                Serializable value = this.valueOrExpression(Serializable.class, v, context, "Sub-workflow variable expression");
                map.put(key, value);
            }
        }
        catch (OperationException e) {
            throw new DocumentRouteException("Cannot get initial variables for " + this.getId(), (Throwable)e);
        }
        return map;
    }

    protected <T> T valueOrExpression(Class<T> klass, String v, OperationContext context, String kind) throws DocumentRouteException {
        if (!v.startsWith(EXPR_PREFIX)) {
            return (T)v;
        }
        Expression expr = (v = v.substring(EXPR_PREFIX.length()).trim()).contains(TEMPLATE_START) ? Scripting.newTemplate((String)v) : Scripting.newExpression((String)v);
        Object res = null;
        try {
            res = expr.eval(context);
        }
        catch (RuntimeException e) {
            throw new DocumentRouteException("Error evaluating expression: " + v, (Throwable)e);
        }
        if (!klass.isAssignableFrom(res.getClass())) {
            throw new DocumentRouteException(kind + " of node '" + this.getId() + "' of graph '" + this.graph.getName() + "' does not evaluate to " + klass.getSimpleName() + " but " + res.getClass().getName() + ": " + v);
        }
        return (T)res;
    }

    @Override
    public void cancelSubRoute() throws DocumentRouteException {
        String subRouteInstanceId = this.getSubRouteInstanceId();
        if (!StringUtils.isEmpty((String)subRouteInstanceId)) {
            DocumentModel subRouteDoc = this.getSession().getDocument((DocumentRef)new IdRef(subRouteInstanceId));
            DocumentRoute subRoute = (DocumentRoute)subRouteDoc.getAdapter(DocumentRoute.class);
            subRoute.cancel(this.getSession());
        }
    }

    protected List<GraphNode.EscalationRule> computeEscalationRules() {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:escalationRules");
        ArrayList<GraphNode.EscalationRule> rules = new ArrayList<GraphNode.EscalationRule>(props.size());
        for (Property p : props) {
            rules.add(new GraphNode.EscalationRule(this, p));
        }
        Collections.sort(rules);
        return rules;
    }

    @Override
    public List<GraphNode.EscalationRule> getEscalationRules() {
        if (this.escalationRules == null) {
            this.escalationRules = this.computeEscalationRules();
        }
        return this.escalationRules;
    }

    @Override
    public List<GraphNode.EscalationRule> evaluateEscalationRules() {
        ArrayList<GraphNode.EscalationRule> rulesToExecute = new ArrayList<GraphNode.EscalationRule>();
        for (GraphNode.EscalationRule rule : this.getEscalationRules()) {
            try {
                OperationContext context = this.getExecutionContext(this.getSession());
                Throwable throwable = null;
                try {
                    RoutingScriptingExpression expr = new RoutingScriptingExpression(rule.condition, new RoutingScriptingFunctions(context, rule));
                    Object res = expr.eval(context);
                    if (!(res instanceof Boolean)) {
                        throw new DocumentRouteException("Condition for rule " + rule + " of node '" + this.getId() + "' of graph '" + this.graph.getName() + "' does not evaluate to a boolean: " + rule.condition);
                    }
                    boolean bool = Boolean.TRUE.equals(res);
                    if (rule.isExecuted() && !rule.isMultipleExecution() || !bool) continue;
                    rulesToExecute.add(rule);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                }
            }
            catch (DocumentRouteException e) {
                throw e;
            }
            catch (RuntimeException | OperationException e) {
                throw new DocumentRouteException("Error evaluating condition: " + rule.condition, e);
            }
        }
        this.saveDocument();
        return rulesToExecute;
    }

    @Override
    public boolean hasMultipleTasks() {
        return this.getBoolean("rnode:hasMultipleTasks");
    }

    protected List<GraphNode.TaskInfo> computeTasksInfo() {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:tasksInfo");
        ArrayList<GraphNode.TaskInfo> tasks = new ArrayList<GraphNode.TaskInfo>(props.size());
        for (Property p : props) {
            tasks.add(new GraphNode.TaskInfo((GraphNode)this, p));
        }
        return tasks;
    }

    @Override
    public List<GraphNode.TaskInfo> getTasksInfo() {
        if (this.tasksInfo == null) {
            this.tasksInfo = this.computeTasksInfo();
        }
        return this.tasksInfo;
    }

    @Override
    public void addTaskInfo(String taskId) {
        this.getTasksInfo().add(new GraphNode.TaskInfo((GraphNode)this, taskId));
        this.saveDocument();
    }

    @Override
    public void removeTaskInfo(String taskId) {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:tasksInfo");
        Property propertytoBeRemoved = null;
        for (Property p : props) {
            if (!taskId.equals(p.get("taskDocId").getValue())) continue;
            propertytoBeRemoved = p;
            break;
        }
        if (propertytoBeRemoved != null) {
            props.remove(propertytoBeRemoved);
            this.saveDocument();
            this.tasksInfo = null;
        }
    }

    @Override
    public void updateTaskInfo(String taskId, boolean ended, String status, String actor, String comment) {
        boolean updated = false;
        List<GraphNode.TaskInfo> tasksInfo = this.getTasksInfo();
        for (GraphNode.TaskInfo taskInfo : tasksInfo) {
            if (!taskId.equals(taskInfo.getTaskDocId())) continue;
            taskInfo.setComment(comment);
            taskInfo.setStatus(status);
            taskInfo.setActor(actor);
            taskInfo.setEnded(true);
            updated = true;
        }
        if (!updated) {
            GraphNode.TaskInfo ti = new GraphNode.TaskInfo((GraphNode)this, taskId);
            ti.setActor(actor);
            ti.setStatus(status);
            ti.setComment(comment);
            ti.setEnded(true);
            this.getTasksInfo().add(ti);
        }
        this.saveDocument();
    }

    @Override
    public List<GraphNode.TaskInfo> getEndedTasksInfo() {
        List<GraphNode.TaskInfo> tasksInfo = this.getTasksInfo();
        ArrayList<GraphNode.TaskInfo> endedTasks = new ArrayList<GraphNode.TaskInfo>();
        for (GraphNode.TaskInfo taskInfo : tasksInfo) {
            if (!taskInfo.isEnded()) continue;
            endedTasks.add(taskInfo);
        }
        return endedTasks;
    }

    @Override
    public boolean hasOpenTasks() {
        return this.getTasksInfo().size() != this.getEndedTasksInfo().size();
    }

    @Override
    public List<GraphNode.TaskInfo> getProcessedTasksInfo() {
        List<GraphNode.TaskInfo> tasksInfo = this.getTasksInfo();
        ArrayList<GraphNode.TaskInfo> processedTasks = new ArrayList<GraphNode.TaskInfo>();
        for (GraphNode.TaskInfo taskInfo : tasksInfo) {
            if (!taskInfo.isEnded() || taskInfo.getStatus() == null) continue;
            processedTasks.add(taskInfo);
        }
        return processedTasks;
    }

    @Override
    public boolean allowTaskReassignment() {
        return this.getBoolean("rnode:allowTaskReassignment");
    }

    protected void cancelTask(CoreSession session, String taskId) throws DocumentRouteException {
        IdRef taskRef = new IdRef(taskId);
        if (!session.exists((DocumentRef)taskRef)) {
            log.info((Object)String.format("Task with id %s does not exist anymore", taskId));
            DocumentModelList docs = this.graph.getAttachedDocumentModels();
            ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).removePermissionsForTaskActors(session, (List)docs, taskId);
            NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
            String actor = principal.getActingUser();
            this.updateTaskInfo(taskId, true, null, actor, null);
            return;
        }
        DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
        Task task = (Task)taskDoc.getAdapter(Task.class);
        if (task == null) {
            throw new DocumentRouteException("Invalid taskId: " + taskId);
        }
        DocumentModelList docs = this.graph.getAttachedDocumentModels();
        ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).removePermissionsForTaskActors(session, (List)docs, task);
        if (task.isOpened().booleanValue()) {
            task.cancel(session);
        }
        session.saveDocument(task.getDocument());
        NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
        String actor = principal.getActingUser();
        this.updateTaskInfo(taskId, true, null, actor, null);
    }

    @Override
    public void setVariable(String name, String value) {
        Map<String, Serializable> nodeVariables = this.getVariables();
        if (nodeVariables.containsKey(name)) {
            nodeVariables.put(name, (Serializable)((Object)value));
            this.setVariables(nodeVariables);
        }
    }

    @Override
    public boolean hasTaskButton(String name) {
        for (GraphNode.Button button : this.getTaskButtons()) {
            if (!button.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

