/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;

public class GraphVariablesUtil {
    private GraphVariablesUtil() {
    }

    protected static SchemaManager getSchemaManager() {
        return (SchemaManager)Framework.getService(SchemaManager.class);
    }

    private static JsonFactory getFactory() {
        JsonFactoryManager jsonFactoryManager = (JsonFactoryManager)Framework.getService(JsonFactoryManager.class);
        return jsonFactoryManager.getJsonFactory();
    }

    public static Map<String, Serializable> getVariables(DocumentModel doc, String facetProp, boolean mapToJSON) {
        String facet = (String)((Object)doc.getPropertyValue(facetProp));
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>();
        if (StringUtils.isBlank((String)facet)) {
            return map;
        }
        CompositeType type = GraphVariablesUtil.getSchemaManager().getFacet(facet);
        if (type == null) {
            return map;
        }
        boolean hasFacet = doc.hasFacet(facet);
        for (Field f : type.getFields()) {
            Object value;
            String name = f.getName().getLocalName();
            Object object = value = hasFacet ? doc.getPropertyValue(name) : null;
            if (value instanceof Calendar) {
                value = mapToJSON ? DateParser.formatW3CDateTime((Date)((Calendar)value).getTime()) : ((Calendar)value).getTime();
            } else if (value instanceof Object[] && mapToJSON) {
                try {
                    Object[] objects = (Object[])value;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    JsonGenerator jg = GraphVariablesUtil.getFactory().createJsonGenerator((OutputStream)out);
                    jg.writeStartArray();
                    for (Object object2 : objects) {
                        jg.writeString(type.encode(object2));
                    }
                    jg.writeEndArray();
                    jg.flush();
                    jg.close();
                    value = out.toString("UTF-8");
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            if (mapToJSON) {
                map.put(name, (Serializable)((Object)(value != null ? value.toString() : null)));
                continue;
            }
            map.put(name, (Serializable)value);
        }
        return map;
    }

    public static Map<String, Serializable> getVariables(DocumentModel doc, String facetProp) {
        return GraphVariablesUtil.getVariables(doc, facetProp, false);
    }

    public static void setVariables(DocumentModel doc, String facetProp, Map<String, Serializable> map) {
        GraphVariablesUtil.setVariables(doc, facetProp, map, true);
    }

    public static void setVariables(DocumentModel doc, String facetProp, Map<String, Serializable> map, boolean save) {
        if (map.containsKey("_MAP_VAR_FORMAT_JSON") && ((Boolean)map.get("_MAP_VAR_FORMAT_JSON")).booleanValue()) {
            HashMap<String, String> vars = new HashMap<String, String>();
            map.remove("_MAP_VAR_FORMAT_JSON");
            for (String key : map.keySet()) {
                if (map.get(key) != null && !(map.get(key) instanceof String)) {
                    throw new NuxeoException("Trying to decode JSON variables: The parameter 'map' should contain only Strings as it contains the marker '_MAP_VAR_FORMAT_JSON' ");
                }
                vars.put(key, (String)((Object)map.get(key)));
            }
            GraphVariablesUtil.setJSONVariables(doc, facetProp, vars, save);
        } else {
            String facet = null;
            try {
                facet = (String)((Object)doc.getPropertyValue(facetProp));
            }
            catch (PropertyNotFoundException e) {
                facet = facetProp;
            }
            if (StringUtils.isBlank((String)facet)) {
                return;
            }
            CompositeType type = GraphVariablesUtil.getSchemaManager().getFacet(facet);
            if (type == null) {
                return;
            }
            boolean hasFacet = doc.hasFacet(facet);
            for (Field f : type.getFields()) {
                Serializable value;
                String name = f.getName().getLocalName();
                if (!map.containsKey(name) || (value = map.get(name)) == null && !hasFacet) continue;
                if (!hasFacet) {
                    doc.addFacet(facet);
                    hasFacet = true;
                }
                doc.setPropertyValue(name, value);
            }
            if (save) {
                CoreSession session = doc.getCoreSession();
                session.saveDocument(doc);
            }
        }
    }

    public static void setJSONVariables(DocumentModel doc, String facetProp, Map<String, String> map) {
        GraphVariablesUtil.setJSONVariables(doc, facetProp, map, true);
    }

    public static void setJSONVariables(DocumentModel doc, String facetProp, Map<String, String> map, boolean save) {
        Properties jsonProperties = new Properties();
        String facet = null;
        try {
            facet = (String)((Object)doc.getPropertyValue(facetProp));
        }
        catch (PropertyNotFoundException e) {
            facet = facetProp;
        }
        if (StringUtils.isBlank((String)facet)) {
            return;
        }
        CompositeType type = GraphVariablesUtil.getSchemaManager().getFacet(facet);
        if (type == null) {
            // empty if block
        }
        boolean hasFacet = doc.hasFacet(facet);
        for (Field f : type.getFields()) {
            String value;
            String name = f.getName().getLocalName();
            if (!map.containsKey(name) || (value = map.get(name)) == null && !hasFacet) continue;
            if (!hasFacet) {
                doc.addFacet(facet);
                hasFacet = true;
            }
            jsonProperties.put((Object)name, (Object)value);
        }
        CoreSession session = doc.getCoreSession();
        try {
            DocumentHelper.setJSONProperties((CoreSession)session, (DocumentModel)doc, (Properties)jsonProperties);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (save) {
            session.saveDocument(doc);
        }
    }
}

