/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.io.NodeAccessRunner;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class TaskWriter
extends ExtensibleEntityJsonWriter<Task> {
    public static final String FETCH_ACTORS = "actors";
    public static final String TARGET_DOCUMENT_IDS = "targetDocumentIds";
    public static final String FETCH_TARGET_DOCUMENT = "targetDocumentIds";
    protected static final String USER_PREFIX = "user";
    protected static final String GROUP_PREFIX = "group";
    protected static final String SEPARATOR = ":";
    @Inject
    private SchemaManager schemaManager;
    @Inject
    UserManager userManager;
    public static final String ENTITY_TYPE = "task";

    public TaskWriter() {
        super(ENTITY_TYPE, Task.class);
    }

    public void writeEntityBody(Task item, JsonGenerator jg) throws IOException {
        GraphRoute workflowInstance = null;
        GraphNode node = null;
        String workflowInstanceId = item.getProcessId();
        String nodeId = item.getVariable("nodeId");
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(item.getDocument());){
            if (StringUtils.isNotBlank((String)workflowInstanceId)) {
                NodeAccessRunner nodeAccessRunner = new NodeAccessRunner(wrapper.getSession(), workflowInstanceId, nodeId);
                nodeAccessRunner.runUnrestricted();
                workflowInstance = nodeAccessRunner.getWorkflowInstance();
                node = nodeAccessRunner.getNode();
            }
            jg.writeStringField("id", item.getDocument().getId());
            jg.writeStringField("name", item.getName());
            jg.writeStringField("workflowInstanceId", workflowInstanceId);
            if (workflowInstance != null) {
                jg.writeStringField("workflowModelName", workflowInstance.getModelName());
            }
            jg.writeStringField("state", item.getDocument().getCurrentLifeCycleState());
            jg.writeStringField("directive", item.getDirective());
            jg.writeStringField("created", DateParser.formatW3CDateTime((Date)item.getCreated()));
            jg.writeStringField("dueDate", DateParser.formatW3CDateTime((Date)item.getDueDate()));
            jg.writeStringField("nodeName", item.getVariable("nodeId"));
            jg.writeArrayFieldStart("targetDocumentIds");
            boolean isFetchTargetDocumentIds = this.ctx.getFetched(ENTITY_TYPE).contains("targetDocumentIds");
            for (Iterator docId : item.getTargetDocumentsIds()) {
                IdRef idRef = new IdRef((String)((Object)docId));
                if (!wrapper.getSession().exists((DocumentRef)idRef)) continue;
                if (isFetchTargetDocumentIds) {
                    this.writeEntity(wrapper.getSession().getDocument((DocumentRef)idRef), jg);
                    continue;
                }
                jg.writeStartObject();
                jg.writeStringField("id", (String)((Object)docId));
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeArrayFieldStart(FETCH_ACTORS);
            boolean isFetchActors = this.ctx.getFetched(ENTITY_TYPE).contains(FETCH_ACTORS);
            for (String actorId : item.getActors()) {
                if (isFetchActors) {
                    NuxeoPrincipal user;
                    if (actorId.startsWith("user:")) {
                        user = this.userManager.getPrincipal(actorId = actorId.substring(USER_PREFIX.length() + SEPARATOR.length()));
                        if (user != null) {
                            this.writeEntity(user, jg);
                            continue;
                        }
                    } else if (actorId.startsWith("group:")) {
                        NuxeoGroup group = this.userManager.getGroup(actorId = actorId.substring(GROUP_PREFIX.length() + SEPARATOR.length()));
                        if (group != null) {
                            this.writeEntity(group, jg);
                            continue;
                        }
                    } else {
                        user = this.userManager.getPrincipal(actorId);
                        if (user != null) {
                            this.writeEntity(user, jg);
                            continue;
                        }
                        NuxeoGroup group = this.userManager.getGroup(actorId);
                        if (group != null) {
                            this.writeEntity(group, jg);
                            continue;
                        }
                    }
                }
                jg.writeStartObject();
                jg.writeStringField("id", actorId);
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeArrayFieldStart("comments");
            for (TaskComment comment : item.getComments()) {
                jg.writeStartObject();
                jg.writeStringField("author", comment.getAuthor());
                jg.writeStringField("text", comment.getText());
                jg.writeStringField("date", DateParser.formatW3CDateTime((Date)comment.getCreationDate().getTime()));
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeFieldName("variables");
            jg.writeStartObject();
            if (node != null) {
                TaskWriter.writeTaskVariables(node, jg, this.registry, this.ctx, this.schemaManager);
            }
            if (workflowInstance != null) {
                TaskWriter.writeWorkflowVariables(workflowInstance, node, jg, this.registry, this.ctx, this.schemaManager);
            }
            jg.writeEndObject();
            if (node != null) {
                jg.writeFieldName("taskInfo");
                jg.writeStartObject();
                ActionManager actionManager = (ActionManager)Framework.getService(ActionManager.class);
                jg.writeArrayFieldStart("taskActions");
                for (GraphNode.Button button : node.getTaskButtons()) {
                    if (!StringUtils.isBlank((String)button.getFilter()) && !actionManager.checkFilter(button.getFilter(), TaskWriter.createActionContext(wrapper.getSession()))) continue;
                    jg.writeStartObject();
                    jg.writeStringField("name", button.getName());
                    jg.writeStringField("url", this.ctx.getBaseUrl() + "api/v1/task/" + item.getDocument().getId() + "/" + button.getName());
                    jg.writeStringField("label", button.getLabel());
                    jg.writeEndObject();
                }
                jg.writeEndArray();
                jg.writeFieldName("layoutResource");
                jg.writeStartObject();
                jg.writeStringField("name", node.getTaskLayout());
                jg.writeStringField("url", this.ctx.getBaseUrl() + "site/layout-manager/layouts/?layoutName=" + node.getTaskLayout());
                jg.writeEndObject();
                jg.writeArrayFieldStart("schemas");
                for (String schema : node.getDocument().getSchemas()) {
                    jg.writeStartObject();
                    jg.writeStringField("name", schema);
                    jg.writeStringField("url", this.ctx.getBaseUrl() + "api/v1/config/schemas/" + schema);
                    jg.writeEndObject();
                }
                jg.writeEndArray();
                jg.writeEndObject();
            }
        }
    }

    protected static ActionContext createActionContext(CoreSession session) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setDocumentManager(session);
        actionContext.setCurrentPrincipal((NuxeoPrincipal)session.getPrincipal());
        return actionContext;
    }

    public static void writeTaskVariables(GraphNode node, JsonGenerator jg, MarshallerRegistry registry, RenderingContext ctx, SchemaManager schemaManager) throws IOException, JsonGenerationException {
        CompositeType type;
        if (node == null || node.getDocument() == null) {
            return;
        }
        String facet = (String)((Object)node.getDocument().getPropertyValue("rnode:variablesFacet"));
        if (StringUtils.isNotBlank((String)facet) && (type = schemaManager.getFacet(facet)) != null) {
            boolean hasFacet = node.getDocument().hasFacet(facet);
            Writer propertyWriter = registry.getWriter(ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
            try (Closeable resource = ctx.wrap().with("document", (Object)node.getDocument()).open();){
                for (Field f : type.getFields()) {
                    String name = f.getName().getLocalName();
                    Property property = hasFacet ? node.getDocument().getProperty(name) : null;
                    OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                    jg.writeFieldName(name);
                    propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
                }
            }
        }
    }

    public static void writeWorkflowVariables(DocumentRoute route, GraphNode node, JsonGenerator jg, MarshallerRegistry registry, RenderingContext ctx, SchemaManager schemaManager) throws IOException, JsonGenerationException {
        CompositeType type;
        String facet = (String)((Object)route.getDocument().getPropertyValue("docri:variablesFacet"));
        if (StringUtils.isNotBlank((String)facet) && (type = schemaManager.getFacet(facet)) != null) {
            String transientSchemaName = "var_global_" + node.getId();
            Schema transientSchema = schemaManager.getSchema(transientSchemaName);
            if (transientSchema == null) {
                return;
            }
            boolean hasFacet = route.getDocument().hasFacet(facet);
            Writer propertyWriter = registry.getWriter(ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
            try (Closeable resource = ctx.wrap().with("document", (Object)route.getDocument()).open();){
                for (Field f : type.getFields()) {
                    String name = f.getName().getLocalName();
                    if (!transientSchema.hasField(name)) continue;
                    Property property = hasFacet ? route.getDocument().getProperty(name) : null;
                    OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                    jg.writeFieldName(name);
                    propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
                }
            }
        }
    }
}

