/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.security.management.IdentityManager;

public class SeamLoginModule
implements LoginModule {
    private static final LogProvider log = Logging.getLogProvider(SeamLoginModule.class);
    protected Set<String> roles = new HashSet<String>();
    protected Subject subject;
    protected Map<String, ?> options;
    protected CallbackHandler callbackHandler;
    protected String username;

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(new SimplePrincipal(this.username));
        SimpleGroup roleGroup = null;
        for (Group g : this.subject.getPrincipals(Group.class)) {
            if (!"Roles".equalsIgnoreCase(g.getName())) continue;
            roleGroup = g;
            break;
        }
        if (roleGroup == null) {
            roleGroup = new SimpleGroup("Roles");
        }
        for (String role : this.roles) {
            roleGroup.addMember(new SimplePrincipal(role));
        }
        this.subject.getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.options = options;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            NameCallback cbName = new NameCallback("Enter username");
            PasswordCallback cbPassword = new PasswordCallback("Enter password", false);
            this.callbackHandler.handle(new Callback[]{cbName, cbPassword});
            this.username = cbName.getName();
        }
        catch (Exception ex) {
            log.warn("Error logging in", ex);
            LoginException le = new LoginException(ex.getMessage());
            le.initCause(ex);
            throw le;
        }
        Expressions.MethodExpression mb = Identity.instance().getAuthenticateMethod();
        if (mb != null) {
            try {
                return (Boolean)mb.invoke(new Object[0]);
            }
            catch (Exception ex) {
                log.warn("Error invoking login method", ex);
                LoginException le = new LoginException(ex.getMessage());
                le.initCause(ex);
                throw le;
            }
        }
        IdentityManager identityManager = IdentityManager.instance();
        if (identityManager != null && identityManager.isEnabled()) {
            Identity identity = Identity.instance();
            try {
                boolean success = identityManager.authenticate(this.username, identity.getCredentials().getPassword());
                if (success) {
                    for (String role : identityManager.getImpliedRoles(this.username)) {
                        identity.addRole(role);
                    }
                }
                return success;
            }
            catch (Exception ex) {
                log.warn("Error invoking login method");
                LoginException le = new LoginException(ex.getMessage());
                le.initCause(ex);
                throw le;
            }
        }
        log.error("No authentication method defined - please define authenticate-method for <security:identity/> in components.xml");
        throw new LoginException("No authentication method defined");
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

