/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReferenceDescriptor;

@XObject(value="directory")
public class SQLDirectoryDescriptor
extends BaseDirectoryDescriptor {
    public static final int QUERY_SIZE_LIMIT_DEFAULT = 0;
    @XNode(value="dataSource")
    public String dataSourceName;
    @XNode(value="querySizeLimit")
    private Integer querySizeLimit;
    @XNodeList(value="references/tableReference", type=TableReferenceDescriptor[].class, componentType=TableReferenceDescriptor.class)
    private TableReferenceDescriptor[] tableReferences;
    @XNodeList(value="filters/staticFilter", type=SQLStaticFilter[].class, componentType=SQLStaticFilter.class)
    private SQLStaticFilter[] staticFilters;
    @XNode(value="nativeCase")
    public Boolean nativeCase;
    @XNode(value="computeMultiTenantId")
    private boolean computeMultiTenantId = true;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public TableReferenceDescriptor[] getTableReferences() {
        return this.tableReferences;
    }

    public int getQuerySizeLimit() {
        return this.querySizeLimit == null ? 0 : this.querySizeLimit;
    }

    public void setQuerySizeLimit(int querySizeLimit) {
        this.querySizeLimit = querySizeLimit;
    }

    public SQLStaticFilter[] getStaticFilters() {
        if (this.staticFilters == null) {
            return new SQLStaticFilter[0];
        }
        return this.staticFilters;
    }

    public boolean isComputeMultiTenantId() {
        return this.computeMultiTenantId;
    }

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof SQLDirectoryDescriptor) {
            this.merge((SQLDirectoryDescriptor)other);
        }
    }

    protected void merge(SQLDirectoryDescriptor other) {
        if (other.dataSourceName != null) {
            this.dataSourceName = other.dataSourceName;
        }
        if (other.querySizeLimit != null) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.tableReferences != null && other.tableReferences.length != 0) {
            this.tableReferences = other.tableReferences;
        }
        if (other.staticFilters != null && other.staticFilters.length != 0) {
            this.staticFilters = other.staticFilters;
        }
        if (other.nativeCase != null) {
            this.nativeCase = other.nativeCase;
        }
        this.computeMultiTenantId = other.computeMultiTenantId;
    }

    public SQLDirectoryDescriptor clone() {
        int i;
        SQLDirectoryDescriptor clone = (SQLDirectoryDescriptor)super.clone();
        if (this.tableReferences != null) {
            clone.tableReferences = new TableReferenceDescriptor[this.tableReferences.length];
            for (i = 0; i < this.tableReferences.length; ++i) {
                clone.tableReferences[i] = this.tableReferences[i].clone();
            }
        }
        if (this.staticFilters != null) {
            clone.staticFilters = new SQLStaticFilter[this.staticFilters.length];
            for (i = 0; i < this.staticFilters.length; ++i) {
                clone.staticFilters[i] = this.staticFilters[i].clone();
            }
        }
        return clone;
    }

    public SQLDirectory newDirectory() {
        return new SQLDirectory(this);
    }
}

