/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.OperationNotAllowedException;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;
import org.nuxeo.ecm.directory.sql.filter.SQLComplexFilter;

public class SQLSession
extends BaseSession {
    private static final Log log = LogFactory.getLog(SQLSession.class);
    private static final boolean HIDE_PASSWORD_IN_LOGS = true;
    final Table table;
    private final boolean computeMultiTenantId;
    protected SQLStaticFilter[] staticFilters;
    String sid;
    Connection sqlConnection;
    private final Dialect dialect;
    protected JDBCLogger logger = new JDBCLogger("SQLDirectory");

    public SQLSession(SQLDirectory directory, SQLDirectoryDescriptor config) throws DirectoryException {
        super((Directory)directory, TableReference.class);
        this.table = directory.getTable();
        this.dialect = directory.getDialect();
        this.sid = String.valueOf(SIDGenerator.next());
        this.staticFilters = config.getStaticFilters();
        this.computeMultiTenantId = config.isComputeMultiTenantId();
        this.acquireConnection();
    }

    public SQLDirectory getDirectory() {
        return (SQLDirectory)this.directory;
    }

    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) throws DirectoryException {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat(this.getReadColumnsSQL());
        String whereClause = this.table.getPrimaryColumn().getQuotedName() + " = ?";
        whereClause = this.addFilterWhereClause(whereClause);
        select.setWhere(whereClause);
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<Serializable> values = new ArrayList<Serializable>();
            values.add((Serializable)((Object)id));
            this.addFilterValuesForLog(values);
            this.logger.logSQL(sql, values);
        }
        PreparedStatement ps = null;
        try {
            String entryTenantId;
            String tenantId;
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            this.addFilterValues(ps, 2);
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    DocumentModel documentModel = null;
                    return documentModel;
                }
                for (Column column : this.getReadColumns()) {
                    Object value = this.getFieldValue(rs, column);
                    fieldMap.put(column.getKey(), value);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, this.getReadColumns());
                }
            }
            if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId())) && !StringUtils.isBlank((String)(entryTenantId = (String)fieldMap.get("tenantId"))) && !entryTenantId.equals(tenantId)) {
                Iterator<Object> iterator = null;
                return iterator;
            }
            DocumentModel entry = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                HashMap targetIdsMap = new HashMap();
                for (Reference reference : this.directory.getReferences()) {
                    ArrayList targetIds = reference.getTargetIdsForSource(entry.getId());
                    targetIds = new ArrayList(targetIds);
                    Collections.sort(targetIds);
                    String fieldName = reference.getFieldName();
                    if (targetIdsMap.containsKey(fieldName)) {
                        ((List)targetIdsMap.get(fieldName)).addAll(targetIds);
                        continue;
                    }
                    targetIdsMap.put(fieldName, targetIds);
                }
                for (Map.Entry entry2 : targetIdsMap.entrySet()) {
                    String fieldName = (String)entry2.getKey();
                    List targetIds = (List)entry2.getValue();
                    try {
                        entry.setProperty(this.schemaName, fieldName, (Object)targetIds);
                    }
                    catch (PropertyException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            var9_10 = entry;
            return var9_10;
        }
        catch (SQLException e) {
            throw new DirectoryException("getEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    protected List<Column> getReadColumns() {
        return this.readAllColumns ? this.getDirectory().readColumnsAll : this.getDirectory().readColumns;
    }

    protected String getReadColumnsSQL() {
        return this.readAllColumns ? this.getDirectory().readColumnsAllSQL : this.getDirectory().readColumnsSQL;
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String idFieldName = ((Field)this.directory.getSchemaFieldMap().get(this.getIdField())).getName().getPrefixedName();
        if (!fieldMap.containsKey(idFieldName)) {
            idFieldName = this.getIdField();
        }
        String id = String.valueOf(fieldMap.get(idFieldName));
        try {
            DocumentModel docModel = BaseSession.createEntryModel((String)this.sid, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
            return docModel;
        }
        catch (PropertyException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void acquireConnection() throws DirectoryException {
        try {
            if (this.sqlConnection == null || this.sqlConnection.isClosed()) {
                this.sqlConnection = this.getDirectory().getConnection();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot connect to SQL directory '" + this.directory.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected void checkConcurrentUpdate(Throwable e) throws ConcurrentUpdateException {
        if (this.dialect.isConcurrentUpdateException(e)) {
            throw new ConcurrentUpdateException(e);
        }
    }

    protected String addFilterWhereClause(String whereClause) throws DirectoryException {
        if (this.staticFilters.length == 0) {
            return whereClause;
        }
        whereClause = whereClause != null && whereClause.trim().length() > 0 ? whereClause + " AND " : "";
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            whereClause = whereClause + filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase()).getQuotedName();
            whereClause = whereClause + " " + filter.getOperator() + " ";
            whereClause = whereClause + "? ";
            if (i >= this.staticFilters.length - 1) continue;
            whereClause = whereClause + " AND ";
        }
        return whereClause;
    }

    protected void addFilterValues(PreparedStatement ps, int startIdx) throws DirectoryException {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            this.setFieldValue(ps, startIdx + i, filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase()), filter.getValue());
        }
    }

    protected void addFilterValuesForLog(List<Serializable> values) {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            values.add((Serializable)((Object)this.staticFilters[i].getValue()));
        }
    }

    /*
     * Exception decompiling
     */
    protected String getPassword(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteEntry(String id) {
        this.acquireConnection();
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        super.deleteEntry(id);
    }

    protected boolean canDeleteMultiTenantEntry(String entryId) throws DirectoryException {
        DocumentModel entry;
        String entryTenantId;
        String tenantId;
        if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId())) && (StringUtils.isBlank((String)(entryTenantId = (String)(entry = this.getEntry(entryId)).getProperty(this.schemaName, "tenantId"))) || !entryTenantId.equals(tenantId))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Trying to delete entry '%s' not part of current tenant '%s'", entryId, tenantId));
            }
            return false;
        }
        return true;
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        this.checkPermission("Write");
        this.acquireConnection();
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new DirectoryException("Operation not allowed in the current tenant context");
        }
        Statement ps = null;
        try {
            Delete delete = new Delete(this.table);
            StringBuilder whereClause = new StringBuilder();
            ArrayList<String> values = new ArrayList<String>(1 + map.size());
            whereClause.append(this.table.getPrimaryColumn().getQuotedName());
            whereClause.append(" = ?");
            values.add(id);
            for (Map.Entry<String, String> e : map.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                whereClause.append(" AND ");
                Column col = this.table.getColumn(key);
                if (col == null) {
                    throw new IllegalArgumentException("Unknown column " + key);
                }
                whereClause.append(col.getQuotedName());
                if (value == null) {
                    whereClause.append(" IS NULL");
                    continue;
                }
                whereClause.append(" = ?");
                values.add(value);
            }
            delete.setWhere(whereClause.toString());
            String sql = delete.getStatement();
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, values);
            }
            ps = this.sqlConnection.prepareStatement(sql);
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    this.setFieldValue((PreparedStatement)ps, 1, this.table.getPrimaryColumn(), values.get(i));
                    continue;
                }
                ps.setString(1 + i, (String)values.get(i));
            }
            ps.execute();
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        this.getDirectory().invalidateCaches();
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) {
        return this.query(filter, fulltext, orderBy, fetchReferences, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws DirectoryException {
        String tenantId;
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        this.acquireConnection();
        LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>(filter);
        filterMap.remove(this.getPasswordField());
        if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId()))) {
            filterMap.put("tenantId", (Serializable)((Object)tenantId));
        }
        try {
            boolean manualLimitOffset;
            Object object;
            StringBuilder whereClause = new StringBuilder();
            String separator = "";
            LinkedList<Column> orderedColumns = new LinkedList<Column>();
            for (String columnName : filterMap.keySet()) {
                String operator;
                String rightSide;
                String leftSide;
                Column column;
                Object value;
                block71: {
                    block74: {
                        boolean substring;
                        block75: {
                            if (this.getDirectory().isReference(columnName)) {
                                log.warn((Object)(columnName + " is a reference and will be ignored" + " as a query criterion"));
                                continue;
                            }
                            value = filterMap.get(columnName);
                            column = this.table.getColumn(columnName);
                            if (null == column) {
                                throw new DirectoryException("cannot find column '" + columnName + "' for table: " + this.table);
                            }
                            leftSide = column.getQuotedName();
                            rightSide = "?";
                            boolean bl = substring = fulltext != null && fulltext.contains(columnName);
                            if ("".equals(value) && this.dialect.hasNullEmptyString() && !substring) {
                                value = null;
                            }
                            if (value == null) break block74;
                            if (!(value instanceof SQLComplexFilter)) break block75;
                            SQLComplexFilter complexFilter = (SQLComplexFilter)value;
                            operator = complexFilter.getOperator();
                            rightSide = complexFilter.getRightSide();
                            break block71;
                        }
                        if (substring) {
                            String searchedValue = null;
                            switch (this.substringMatchType) {
                                case subany: {
                                    searchedValue = '%' + String.valueOf(value).toLowerCase() + '%';
                                    break;
                                }
                                case subinitial: {
                                    searchedValue = String.valueOf(value).toLowerCase() + '%';
                                    break;
                                }
                                case subfinal: {
                                    searchedValue = '%' + String.valueOf(value).toLowerCase();
                                    break;
                                }
                            }
                            filterMap.put(columnName, searchedValue);
                            if (this.dialect.supportsIlike()) {
                                operator = " ILIKE ";
                                break block71;
                            } else {
                                leftSide = "LOWER(" + leftSide + ')';
                                operator = " LIKE ";
                            }
                            break block71;
                        } else {
                            operator = " = ";
                        }
                        break block71;
                    }
                    operator = " IS NULL";
                }
                whereClause.append(separator).append(leftSide).append(operator);
                if (value != null) {
                    whereClause.append(rightSide);
                    orderedColumns.add(column);
                }
                separator = " AND ";
            }
            int queryLimitSize = this.getDirectory().getDescriptor().getQuerySizeLimit();
            boolean trucatedResults = false;
            if (queryLimitSize != 0 && (limit <= 0 || limit > queryLimitSize)) {
                try (Statement ps = null;){
                    int count;
                    Select select = new Select(this.table);
                    select.setWhat("count(*)");
                    select.setFrom(this.table.getQuotedName());
                    String where = whereClause.toString();
                    where = this.addFilterWhereClause(where);
                    select.setWhere(where);
                    String countQuery = select.getStatement();
                    if (this.logger.isLogEnabled()) {
                        ArrayList<Serializable> values = new ArrayList<Serializable>(orderedColumns.size());
                        for (Column column : orderedColumns) {
                            Object value = filterMap.get(column.getKey());
                            values.add((Serializable)value);
                        }
                        this.addFilterValuesForLog(values);
                        this.logger.logSQL(countQuery, values);
                    }
                    ps = this.sqlConnection.prepareStatement(countQuery);
                    this.fillPreparedStatementFields(filterMap, orderedColumns, (PreparedStatement)ps);
                    ResultSet rs = ps.executeQuery();
                    object = null;
                    try {
                        rs.next();
                        count = rs.getInt(1);
                    }
                    catch (Throwable value) {
                        object = value;
                        throw value;
                    }
                    finally {
                        if (rs != null) {
                            if (object != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable value) {
                                    ((Throwable)object).addSuppressed(value);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    if (this.logger.isLogEnabled()) {
                        this.logger.logCount(count);
                    }
                    if (count > queryLimitSize) {
                        trucatedResults = true;
                        limit = queryLimitSize;
                        log.error((Object)("Displayed results will be truncated because too many rows in result: " + count));
                    }
                }
            }
            Select select = new Select(this.table);
            select.setWhat(this.getReadColumnsSQL());
            select.setFrom(this.table.getQuotedName());
            String where = whereClause.toString();
            where = this.addFilterWhereClause(where);
            select.setWhere(where);
            StringBuilder orderby = new StringBuilder(128);
            if (orderBy != null) {
                Iterator<Map.Entry<String, String>> it = orderBy.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    orderby.append(this.dialect.openQuote()).append(entry.getKey()).append(this.dialect.closeQuote()).append(' ').append(entry.getValue());
                    if (!it.hasNext()) continue;
                    orderby.append(',');
                }
            }
            select.setOrderBy(orderby.toString());
            String query = select.getStatement();
            if (limit <= 0) {
                manualLimitOffset = false;
            } else {
                if (offset < 0) {
                    offset = 0;
                }
                if (this.dialect.supportsPaging()) {
                    query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
                    manualLimitOffset = false;
                } else {
                    manualLimitOffset = true;
                }
            }
            if (this.logger.isLogEnabled()) {
                ArrayList<Serializable> values = new ArrayList<Serializable>(orderedColumns.size());
                for (Column column : orderedColumns) {
                    Object value = filterMap.get(column.getKey());
                    values.add((Serializable)value);
                }
                this.addFilterValuesForLog(values);
                this.logger.logSQL(query, values);
            }
            PreparedStatement ps = this.sqlConnection.prepareStatement(query);
            object = null;
            try {
                this.fillPreparedStatementFields(filterMap, orderedColumns, ps);
                ResultSet rs = ps.executeQuery();
                DocumentModelListImpl list = new DocumentModelListImpl();
                while (true) {
                    DocumentModel docModel;
                    block77: {
                        Iterator<Object> iterator;
                        HashMap<String, List> targetIdsMap;
                        block78: {
                            block76: {
                                if (!rs.next()) break block76;
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                for (Column column : this.getReadColumns()) {
                                    Object o = this.getFieldValue(rs, column);
                                    map.put(column.getKey(), o);
                                }
                                docModel = this.fieldMapToDocumentModel(map);
                                if (!fetchReferences) break block77;
                                targetIdsMap = new HashMap<String, List>();
                                iterator = this.directory.getReferences().iterator();
                                break block78;
                            }
                            rs.close();
                            if (manualLimitOffset) {
                                int totalSize = list.size();
                                if (offset > 0) {
                                    list = offset >= totalSize ? new DocumentModelListImpl() : new DocumentModelListImpl(list.subList(offset, totalSize));
                                }
                                if (list.size() > limit) {
                                    list = new DocumentModelListImpl(list.subList(0, limit));
                                }
                                list.setTotalSize((long)totalSize);
                            }
                            if (trucatedResults) {
                                list.setTotalSize(-2L);
                            }
                            DocumentModelListImpl documentModelListImpl = list;
                            return documentModelListImpl;
                        }
                        while (iterator.hasNext()) {
                            Reference reference = (Reference)iterator.next();
                            List targetIds = reference.getTargetIdsForSource(docModel.getId());
                            String fieldName = reference.getFieldName();
                            if (targetIdsMap.containsKey(fieldName)) {
                                ((List)targetIdsMap.get(fieldName)).addAll(targetIds);
                                continue;
                            }
                            targetIdsMap.put(fieldName, targetIds);
                        }
                        for (Map.Entry entry : targetIdsMap.entrySet()) {
                            String fieldName = (String)entry.getKey();
                            List targetIds = (List)entry.getValue();
                            docModel.setProperty(this.schemaName, fieldName, (Object)targetIds);
                        }
                    }
                    list.add((Object)docModel);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (object != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                this.sqlConnection.close();
                throw new DirectoryException("query failed", (Throwable)e);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new DirectoryException("query failed", (Throwable)e);
        }
    }

    protected DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) {
        DocumentModel entry;
        fieldMap = new HashMap<String, Object>(fieldMap);
        Map schemaFieldMap = this.directory.getSchemaFieldMap();
        Field schemaIdField = (Field)schemaFieldMap.get(this.getIdField());
        String idFieldName = schemaIdField.getName().getPrefixedName();
        this.acquireConnection();
        if (this.autoincrementId) {
            fieldMap.remove(idFieldName);
        } else {
            String tenantId;
            Object rawId = fieldMap.get(idFieldName);
            if (rawId == null) {
                throw new DirectoryException("Missing id");
            }
            String id = String.valueOf(rawId);
            if (this.hasEntry(id)) {
                throw new DirectoryException(String.format("Entry with id %s already exists", id));
            }
            if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId()))) {
                fieldMap.put("tenantId", tenantId);
                if (this.computeMultiTenantId) {
                    fieldMap.put(idFieldName, SQLSession.computeMultiTenantDirectoryId((String)tenantId, (String)id));
                }
            }
        }
        ArrayList columnList = new ArrayList(this.table.getColumns());
        Column idColumn = null;
        Iterator i = columnList.iterator();
        while (i.hasNext()) {
            String prefixedName;
            Column column = (Column)i.next();
            if (column.isIdentity()) {
                idColumn = column;
            }
            if (fieldMap.containsKey(prefixedName = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName())) continue;
            Field prefixedField = (Field)schemaFieldMap.get(prefixedName);
            if (prefixedField != null && prefixedField.getDefaultValue() != null) {
                fieldMap.put(prefixedName, prefixedField.getDefaultValue());
                continue;
            }
            i.remove();
        }
        Insert insert = new Insert(this.table);
        for (Column column : columnList) {
            insert.addColumn(column);
        }
        insert.addIdentityColumn(idColumn);
        String sql = insert.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<String> values = new ArrayList<String>(columnList.size());
            for (Column column : columnList) {
                String prefixField = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName();
                Object value = fieldMap.get(prefixField);
                Object v = column.getKey().equals(this.getPasswordField()) ? "********" : this.fieldValueForWrite(value, column);
                values.add((String)v);
            }
            this.logger.logSQL(sql, values);
        }
        Statement ps = null;
        Statement st = null;
        try {
            ps = this.autoincrementId && this.dialect.hasIdentityGeneratedKey() ? this.sqlConnection.prepareStatement(sql, new String[]{this.getIdField()}) : this.sqlConnection.prepareStatement(sql);
            int index = 1;
            for (Column column : columnList) {
                String prefixField = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName();
                Object value = fieldMap.get(prefixField);
                this.setFieldValue((PreparedStatement)ps, index, column, value);
                ++index;
            }
            ps.execute();
            if (this.autoincrementId) {
                ResultSet rs;
                Column column = this.table.getColumn(this.getIdField());
                if (this.dialect.hasIdentityGeneratedKey()) {
                    rs = ps.getGeneratedKeys();
                } else {
                    sql = this.dialect.getIdentityGeneratedKeySql(column);
                    st = this.sqlConnection.createStatement();
                    rs = st.executeQuery(sql);
                }
                if (!rs.next()) {
                    throw new DirectoryException("Cannot get generated key");
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, Collections.singletonList(column));
                }
                Serializable rawId = column.getFromResultSet(rs, 1);
                fieldMap.put(idFieldName, rawId);
                rs.close();
            }
            entry = this.fieldMapToDocumentModel(fieldMap);
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("createEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        return entry;
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) throws DirectoryException {
        String entryTenantId;
        Object tenantId;
        this.acquireConnection();
        LinkedList<Column> storedColumnList = new LinkedList<Column>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId())) && (StringUtils.isBlank((String)(entryTenantId = (String)docModel.getProperty(this.schemaName, "tenantId"))) || !entryTenantId.equals(tenantId))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Trying to update entry '%s' not part of current tenant '%s'", docModel.getId(), tenantId));
            }
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        for (String fieldName : this.directory.getSchemaFieldMap().keySet()) {
            Property prop;
            if (fieldName.equals(this.getIdField()) || !(prop = docModel.getPropertyObject(this.schemaName, fieldName)).isDirty() || fieldName.equals(this.getPasswordField()) && StringUtils.isEmpty((String)((String)((Object)prop.getValue())))) continue;
            if (this.getDirectory().isReference(fieldName)) {
                referenceFieldList.add(fieldName);
                continue;
            }
            storedColumnList.add(this.table.getColumn(fieldName));
        }
        if (!storedColumnList.isEmpty()) {
            Update update = new Update(this.table);
            update.setUpdatedColumns(storedColumnList);
            String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
            update.setWhere(whereString);
            String sql = update.getStatement();
            if (this.logger.isLogEnabled()) {
                ArrayList<Object> values = new ArrayList<Object>(storedColumnList.size());
                for (Column column : storedColumnList) {
                    Object value = docModel.getProperty(this.schemaName, column.getKey());
                    if (column.getKey().equals(this.getPasswordField())) {
                        value = "********";
                    }
                    values.add((Serializable)value);
                }
                values.add(docModel.getId());
                this.logger.logSQL(sql, values);
            }
            PreparedStatement ps = null;
            try {
                ps = this.sqlConnection.prepareStatement(sql);
                int index = 1;
                for (Column column : storedColumnList) {
                    Object value = docModel.getProperty(this.schemaName, column.getKey());
                    this.setFieldValue(ps, index, column, value);
                    ++index;
                }
                this.setFieldValue(ps, index, this.table.getPrimaryColumn(), docModel.getId());
                ps.execute();
            }
            catch (SQLException e) {
                this.checkConcurrentUpdate(e);
                throw new DirectoryException("updateEntry failed for " + docModel.getId(), (Throwable)e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sqle) {
                    throw new DirectoryException((Throwable)sqle);
                }
            }
        }
        return referenceFieldList;
    }

    public void deleteEntryWithoutReferences(String id) throws DirectoryException {
        Statement ps = null;
        try {
            Delete delete = new Delete(this.table);
            String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
            delete.setWhere(whereString);
            String sql = delete.getStatement();
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singleton(id));
            }
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue((PreparedStatement)ps, 1, this.table.getPrimaryColumn(), id);
            ps.execute();
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    protected void fillPreparedStatementFields(Map<String, Object> filterMap, List<Column> orderedColumns, PreparedStatement ps) throws DirectoryException {
        int index = 1;
        for (Column column : orderedColumns) {
            Object value = filterMap.get(column.getKey());
            if (value instanceof SQLComplexFilter) {
                index = ((SQLComplexFilter)value).setFieldValue(ps, index, column);
                continue;
            }
            this.setFieldValue(ps, index, column, value);
            ++index;
        }
        this.addFilterValues(ps, index);
    }

    private Object getFieldValue(ResultSet rs, Column column) throws DirectoryException {
        try {
            int index = rs.findColumn(column.getPhysicalName());
            return column.getFromResultSet(rs, index);
        }
        catch (SQLException e) {
            throw new DirectoryException("getFieldValue failed", (Throwable)e);
        }
    }

    private void setFieldValue(PreparedStatement ps, int index, Column column, Object value) throws DirectoryException {
        try {
            column.setToPreparedStatement(ps, index, this.fieldValueForWrite(value, column));
        }
        catch (SQLException e) {
            throw new DirectoryException("setFieldValue failed", (Throwable)e);
        }
    }

    protected Serializable fieldValueForWrite(Object value, Column column) {
        ColumnSpec spec = column.getType().spec;
        if (value instanceof String) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                return Long.valueOf((String)value);
            }
            if (column.getKey().equals(this.getPasswordField())) {
                String password = (String)value;
                if (!PasswordHelper.isHashed((String)password)) {
                    password = PasswordHelper.hashPassword((String)password, (String)this.passwordHashAlgorithm);
                }
                return password;
            }
        } else if (value instanceof Number) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                if (value instanceof Integer) {
                    return Long.valueOf(((Integer)value).longValue());
                }
            } else if (spec == ColumnSpec.STRING) {
                return value.toString();
            }
        }
        return (Serializable)value;
    }

    public void close() throws DirectoryException {
        try {
            if (!this.sqlConnection.isClosed()) {
                this.sqlConnection.close();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("close failed", (Throwable)e);
        }
        finally {
            this.getDirectory().removeSession((Session)this);
        }
    }

    public boolean isLive() throws DirectoryException {
        try {
            return !this.sqlConnection.isClosed();
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot check connection status of " + (Object)((Object)this), (Throwable)e);
        }
    }

    public boolean authenticate(String username, String password) {
        String storedPassword = this.getPassword(username);
        return PasswordHelper.verifyPassword((String)password, (String)storedPassword);
    }

    public boolean isAuthenticating() {
        return this.directory.getSchemaFieldMap().containsKey(this.getPasswordField());
    }

    public boolean hasEntry(String id) {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat("1");
        select.setWhere(this.table.getPrimaryColumn().getQuotedName() + " = ?");
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singleton(id));
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            rs = ps.executeQuery();
            boolean has = rs.next();
            if (this.logger.isLogEnabled()) {
                this.logger.logCount(has ? 1 : 0);
            }
            boolean bl = has;
            return bl;
        }
        catch (SQLException e) {
            throw new DirectoryException("hasEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    protected boolean isMultiTenant() {
        return this.directory.isMultiTenant();
    }

    protected String getCurrentTenantId() {
        NuxeoPrincipal principal = ClientLoginModule.getCurrentPrincipal();
        return principal != null ? principal.getTenantId() : null;
    }

    public String toString() {
        return "SQLSession [directory=" + this.directory.getName() + ", sid=" + this.sid + "]";
    }
}

