/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.osgi.BundleIdGenerator;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.BundleRegistry;
import org.nuxeo.osgi.SystemBundle;
import org.nuxeo.osgi.services.PackageAdminImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiAdapter {
    private static final Log log = LogFactory.getLog(OSGiAdapter.class);
    protected final File workingDir;
    protected final File dataDir;
    protected File idTableFile;
    protected BundleIdGenerator bundleIds;
    protected ListenerList frameworkListeners;
    protected ListenerList bundleListeners;
    protected ListenerList serviceListeners;
    protected Map<String, ServiceRegistration> services = new ConcurrentHashMap<String, ServiceRegistration>();
    protected BundleRegistry registry;
    protected Properties properties;
    protected SystemBundle systemBundle;

    public OSGiAdapter(File workingDir) {
        this(workingDir, new File(System.getProperty("nuxeo.data.dir", workingDir + File.separator + "data")), new Properties());
    }

    public OSGiAdapter(File workingDir, File dataDir, Properties properties) {
        this.workingDir = workingDir;
        this.dataDir = dataDir;
        this.dataDir.mkdirs();
        this.workingDir.mkdirs();
        this.initialize(properties);
    }

    public void removeService(String clazz) {
        this.services.remove(clazz);
    }

    protected void initialize(Properties properties) {
        this.properties = properties == null ? new Properties() : properties;
        this.registry = new BundleRegistry();
        this.frameworkListeners = new ListenerList();
        this.bundleListeners = new ListenerList();
        this.serviceListeners = new ListenerList();
        this.bundleIds = new BundleIdGenerator();
        this.idTableFile = new File(this.dataDir, "bundles.ids");
        this.bundleIds.load(this.idTableFile);
        properties.put("org.osgi.framework.vendor", "Nuxeo");
        properties.put("org.osgi.framework.version", "1.0.0");
    }

    public void setSystemBundle(SystemBundle systemBundle) throws BundleException {
        if (this.systemBundle != null) {
            throw new IllegalStateException("Cannot set system bundle");
        }
        this.install(systemBundle);
        this.registry.addBundleAlias("system.bundle", systemBundle.getSymbolicName());
        this.systemBundle = systemBundle;
        systemBundle.getBundleContext().registerService(PackageAdmin.class.getName(), (Object)new PackageAdminImpl(this), null);
    }

    public BundleRegistry getRegistry() {
        return this.registry;
    }

    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public String getProperty(String key, String defvalue) {
        String val = this.getProperty(key);
        if (val == null) {
            val = defvalue;
        }
        return val;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void shutdown() throws IOException {
        this.bundleIds.store(this.idTableFile);
        this.registry.shutdown();
        this.properties.clear();
        this.registry = null;
        this.frameworkListeners = null;
        this.bundleListeners = null;
        this.serviceListeners = null;
        this.properties = null;
    }

    public long getBundleId(String symbolicName) {
        return this.bundleIds.getBundleId(symbolicName);
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public BundleImpl getBundle(String symbolicName) {
        return this.registry.getBundle(symbolicName);
    }

    public BundleImpl[] getInstalledBundles() {
        return this.registry.getInstalledBundles();
    }

    public void install(BundleImpl bundle) throws BundleException {
        double s = System.currentTimeMillis();
        this.registry.install(bundle);
        bundle.startupTime = (double)System.currentTimeMillis() - s;
    }

    public void uninstall(BundleImpl bundle) throws BundleException {
        this.registry.uninstall(bundle);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.frameworkListeners.add((Object)listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.frameworkListeners.remove((Object)listener);
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceListeners.add((Object)listener);
    }

    public void addServiceListener(ServiceListener listener, String filter) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceListeners.remove((Object)listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.bundleListeners.add((Object)listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.bundleListeners.remove((Object)listener);
    }

    public void fireFrameworkEvent(FrameworkEvent event) {
        Object[] listeners;
        log.debug((Object)("Firing FrameworkEvent on " + this.frameworkListeners.size() + " listeners"));
        for (Object listener : listeners = this.frameworkListeners.getListeners()) {
            log.debug((Object)("Start execution of " + listener.getClass() + " listener"));
            try {
                ((FrameworkListener)listener).frameworkEvent(event);
                log.debug((Object)("End execution of " + listener.getClass() + " listener"));
            }
            catch (RuntimeException e) {
                log.error((Object)("Error during Framework Listener execution : " + listener.getClass()), (Throwable)e);
            }
        }
    }

    public void fireServiceEvent(ServiceEvent event) {
        Object[] listeners;
        for (Object listener : listeners = this.serviceListeners.getListeners()) {
            ((ServiceListener)listener).serviceChanged(event);
        }
    }

    public void fireBundleEvent(BundleEvent event) {
        Object[] listeners;
        for (Object listener : listeners = this.bundleListeners.getListeners()) {
            ((BundleListener)listener).bundleChanged(event);
        }
    }

    public Bundle getSystemBundle() {
        return this.systemBundle;
    }
}

