/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class DirectoryEntryResolver
implements ObjectResolver {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "directoryResolver";
    public static final String PARAM_DIRECTORY = "directory";
    public static final String PARAM_PARENT_FIELD = "parentField";
    public static final String PARAM_SEPARATOR = "separator";
    private String idField;
    private String schema;
    private Map<String, Serializable> parameters;
    private boolean hierarchical = false;
    private String parentField = null;
    private String separator = null;
    private List<Class<?>> managedClasses = null;
    private String directoryName;
    private transient Directory directory;
    private transient DirectoryService directoryService;

    public void configure(Map<String, String> parameters) throws IllegalArgumentException, IllegalStateException {
        if (this.parameters != null) {
            throw new IllegalStateException("cannot change configuration, may be already in use somewhere");
        }
        this.directoryName = parameters.get(PARAM_DIRECTORY);
        if (this.directoryName != null) {
            this.directoryName = this.directoryName.trim();
        }
        if (this.directoryName == null || this.directoryName.isEmpty()) {
            throw new IllegalArgumentException("missing directory parameter. A directory name is necessary");
        }
        this.fetchDirectory();
        this.idField = this.directory.getIdField();
        this.schema = this.directory.getSchema();
        if (this.schema.endsWith("xvocabulary")) {
            this.hierarchical = true;
            this.parentField = "parent";
            this.separator = "/";
        }
        String parentFieldParam = StringUtils.trim((String)parameters.get(PARAM_PARENT_FIELD));
        String separatorParam = StringUtils.trim((String)parameters.get(PARAM_SEPARATOR));
        if (!StringUtils.isBlank((String)parentFieldParam) && !StringUtils.isBlank((String)separatorParam)) {
            this.hierarchical = true;
            this.parentField = parentFieldParam;
            this.separator = separatorParam;
        }
        this.parameters = new HashMap<String, Serializable>();
        this.parameters.put(PARAM_DIRECTORY, (Serializable)((Object)this.directory.getName()));
    }

    public List<Class<?>> getManagedClasses() {
        if (this.managedClasses == null) {
            this.managedClasses = new ArrayList();
            this.managedClasses.add(DirectoryEntry.class);
        }
        return this.managedClasses;
    }

    private void fetchDirectory() {
        this.directory = this.getDirectoryService().getDirectory(this.directoryName);
        if (this.directory == null) {
            throw new IllegalArgumentException(String.format("the directory \"%s\" was not found", this.directoryName));
        }
    }

    public DirectoryService getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        }
        return this.directoryService;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public String getName() {
        this.checkConfig();
        return NAME;
    }

    public Map<String, Serializable> getParameters() {
        this.checkConfig();
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean validate(Object value) throws IllegalStateException {
        this.checkConfig();
        return this.fetch(value) != null;
    }

    public Object fetch(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value != null && value instanceof String) {
            String id = (String)value;
            if (this.hierarchical) {
                String[] ids = StringUtils.split((String)id, (String)this.separator);
                if (ids.length > 0) {
                    id = ids[ids.length - 1];
                } else {
                    return null;
                }
            }
            try (Session session = this.directory.getSession();){
                String finalId = id;
                DocumentModel doc = (DocumentModel)Framework.doPrivileged(() -> session.getEntry(finalId));
                if (doc != null) {
                    DirectoryEntry directoryEntry = new DirectoryEntry(this.directory.getName(), doc);
                    return directoryEntry;
                }
                Object var7_9 = null;
                return var7_9;
            }
        }
        return null;
    }

    public <T> T fetch(Class<T> type, Object value) throws IllegalStateException {
        this.checkConfig();
        DirectoryEntry doc = (DirectoryEntry)this.fetch(value);
        if (doc != null) {
            if (type.isInstance(doc)) {
                return type.cast(doc);
            }
            if (type.isInstance(doc.getDocumentModel())) {
                return type.cast(doc.getDocumentModel());
            }
        }
        return null;
    }

    public Serializable getReference(Object entity) throws IllegalStateException {
        this.checkConfig();
        DocumentModel entry = null;
        if (entity != null) {
            if (entity instanceof DirectoryEntry) {
                entry = ((DirectoryEntry)entity).getDocumentModel();
            } else if (entity instanceof DocumentModel) {
                entry = (DocumentModel)entity;
            }
            if (entry != null) {
                if (!entry.hasSchema(this.schema)) {
                    return null;
                }
                String result = (String)entry.getProperty(this.schema, this.idField);
                if (this.hierarchical) {
                    String parent = (String)entry.getProperty(this.schema, this.parentField);
                    try (Session session = this.directory.getSession();){
                        while (parent != null) {
                            String finalParent = parent;
                            entry = (DocumentModel)Framework.doPrivileged(() -> session.getEntry(finalParent));
                            if (entry == null) {
                                break;
                            }
                            result = parent + this.separator + result;
                            parent = (String)entry.getProperty(this.schema, this.parentField);
                        }
                    }
                }
                return result;
            }
        }
        return null;
    }

    public String getConstraintErrorMessage(Object invalidValue, Locale locale) {
        this.checkConfig();
        return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (Object)invalidValue, (Locale)locale, (String[])new String[]{this.directory.getName()});
    }

    private void checkConfig() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("you should call #configure(Map<String, String>) before. Please get this resolver throught ExternalReferenceService which is in charge of resolver configuration.");
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.fetchDirectory();
    }
}

