/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;

public class DirectoryRegistry {
    private static final Log log = LogFactory.getLog(DirectoryRegistry.class);
    protected Map<String, List<BaseDirectoryDescriptor>> allDescriptors = new HashMap<String, List<BaseDirectoryDescriptor>>();
    protected Map<String, BaseDirectoryDescriptor> descriptors = new HashMap<String, BaseDirectoryDescriptor>();
    protected Map<String, Directory> directories = new HashMap<String, Directory>();

    public synchronized void addContribution(BaseDirectoryDescriptor contrib) {
        String id = contrib.name;
        if (id.contains("/") && log.isWarnEnabled()) {
            log.warn((Object)("Directory " + id + " should not contain forward slashes in its name, as they are not supported." + " Operations with the REST API on this directory won't work."));
        }
        log.info((Object)("Registered directory" + (contrib.template ? " template" : "") + ": " + id));
        this.allDescriptors.computeIfAbsent(id, k -> new ArrayList()).add(contrib);
        this.contributionChanged(contrib);
    }

    public synchronized void removeContribution(BaseDirectoryDescriptor contrib) {
        String id = contrib.name;
        log.info((Object)("Unregistered directory" + (contrib.template ? " template" : "") + ": " + id));
        this.allDescriptors.getOrDefault(id, Collections.emptyList()).remove(contrib);
        this.contributionChanged(contrib);
    }

    protected void contributionChanged(BaseDirectoryDescriptor contrib) {
        LinkedList<String> todo = new LinkedList<String>();
        todo.add(contrib.name);
        HashSet<String> done = new HashSet<String>();
        while (!todo.isEmpty()) {
            BaseDirectoryDescriptor desc;
            String id = (String)todo.removeFirst();
            if (!done.add(id) || (desc = this.recomputeDescriptor(id)) == null) continue;
            block1: for (List<BaseDirectoryDescriptor> list : this.allDescriptors.values()) {
                for (BaseDirectoryDescriptor d : list) {
                    if (!id.equals(d.extendz)) continue;
                    todo.add(d.name);
                    continue block1;
                }
            }
        }
    }

    protected void removeDirectory(String id) {
        Directory dir = this.directories.remove(id);
        if (dir != null) {
            DirectoryRegistry.shutdownDirectory(dir);
        }
    }

    protected BaseDirectoryDescriptor recomputeDescriptor(String id) {
        this.removeDirectory(id);
        List list = this.allDescriptors.getOrDefault(id, Collections.emptyList());
        Object contrib = null;
        for (BaseDirectoryDescriptor next : list) {
            String extendz = next.extendz;
            if (extendz != null) {
                BaseDirectoryDescriptor base = this.descriptors.get(extendz);
                if (base != null && base.template) {
                    contrib = base.clone();
                    ((BaseDirectoryDescriptor)contrib).template = false;
                    ((BaseDirectoryDescriptor)contrib).name = next.name;
                    contrib.merge(next);
                    continue;
                }
                log.debug((Object)("Directory " + id + " extends non-existing directory template: " + extendz));
                contrib = null;
                continue;
            }
            if (next.remove) {
                contrib = null;
                continue;
            }
            if (contrib == null) {
                contrib = next.clone();
                continue;
            }
            if (contrib.getClass() == next.getClass()) {
                contrib.merge(next);
                continue;
            }
            log.warn((Object)("Directory " + id + " redefined with different factory"));
            contrib = next.clone();
        }
        if (contrib == null) {
            this.descriptors.remove(id);
        } else {
            this.descriptors.put(id, (BaseDirectoryDescriptor)contrib);
        }
        return contrib;
    }

    public synchronized BaseDirectoryDescriptor getDirectoryDescriptor(String id) {
        return this.descriptors.get(id);
    }

    public synchronized Directory getDirectory(String id) {
        BaseDirectoryDescriptor descriptor;
        Directory dir = this.directories.get(id);
        if (dir == null && (descriptor = this.descriptors.get(id)) != null) {
            dir = descriptor.newDirectory();
            this.directories.put(id, dir);
        }
        return dir;
    }

    public synchronized List<String> getDirectoryIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (BaseDirectoryDescriptor descriptor : this.descriptors.values()) {
            if (descriptor.template) continue;
            list.add(descriptor.name);
        }
        return list;
    }

    public synchronized List<Directory> getDirectories() {
        ArrayList<Directory> list = new ArrayList<Directory>();
        for (BaseDirectoryDescriptor descriptor : this.descriptors.values()) {
            if (descriptor.template) continue;
            list.add(this.getDirectory(descriptor.name));
        }
        return list;
    }

    public synchronized void shutdown() {
        for (Directory dir : this.directories.values()) {
            DirectoryRegistry.shutdownDirectory(dir);
        }
        this.allDescriptors.clear();
        this.descriptors.clear();
        this.directories.clear();
    }

    protected static void shutdownDirectory(Directory dir) {
        try {
            dir.shutdown();
        }
        catch (DirectoryException e) {
            log.error((Object)("Error while shutting down directory:" + dir.getName()), (Throwable)e);
        }
    }
}

