/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.MaxDepthReachedException;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DirectoryEntryJsonWriter
extends ExtensibleEntityJsonWriter<DirectoryEntry> {
    public static final String ENTITY_TYPE = "directoryEntry";
    private static final String MESSAGES_BUNDLE = "messages";
    private static final Log log = LogFactory.getLog(DirectoryEntryJsonWriter.class);
    @Inject
    private SchemaManager schemaManager;
    @Inject
    private DirectoryService directoryService;

    public DirectoryEntryJsonWriter() {
        super(ENTITY_TYPE, DirectoryEntry.class);
    }

    protected void writeEntityBody(DirectoryEntry entry, JsonGenerator jg) throws IOException {
        String directoryName = entry.getDirectoryName();
        DocumentModel document = entry.getDocumentModel();
        String schemaName = this.directoryService.getDirectorySchema(directoryName);
        String passwordField = this.directoryService.getDirectoryPasswordField(directoryName);
        jg.writeStringField("directoryName", directoryName);
        jg.writeStringField("id", document.getId());
        Schema schema = this.schemaManager.getSchema(schemaName);
        Writer propertyWriter = this.registry.getWriter(this.ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
        jg.writeObjectFieldStart("properties");
        Set translated = this.ctx.getTranslated(ENTITY_TYPE);
        Set fetched = this.ctx.getFetched(ENTITY_TYPE);
        for (Field field : schema.getFields()) {
            QName fieldName = field.getName();
            String key = fieldName.getLocalName();
            jg.writeFieldName(key);
            if (key.equals(passwordField)) {
                jg.writeString("");
                continue;
            }
            Property property = document.getProperty(fieldName.getPrefixedName());
            boolean managed = false;
            Serializable value = property.getValue();
            if (value != null && value instanceof String) {
                String valueString = (String)((Object)value);
                if (fetched.contains(fieldName.getLocalName())) {
                    try (Closeable resource = this.ctx.wrap().controlDepth().open();){
                        managed = this.writeFetchedValue(jg, directoryName, fieldName.getLocalName(), valueString);
                    }
                    catch (MaxDepthReachedException e) {
                        managed = false;
                    }
                } else if (translated.contains(fieldName.getLocalName())) {
                    managed = this.writeTranslatedValue(jg, fieldName.getLocalName(), valueString);
                }
            }
            if (managed) continue;
            propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)new OutputStreamWithJsonWriter(jg));
        }
        jg.writeEndObject();
    }

    protected boolean writeFetchedValue(JsonGenerator jg, String directoryName, String fieldName, String value) throws IOException {
        try (Session session = this.directoryService.open(directoryName);){
            DocumentModel entryModel = session.getEntry(value);
            if (entryModel != null) {
                DirectoryEntry entry = new DirectoryEntry(directoryName, entryModel);
                this.writeEntity(entry, jg);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected boolean writeTranslatedValue(JsonGenerator jg, String fieldName, String value) throws IOException {
        Locale locale = this.ctx.getLocale();
        String msg = DirectoryEntryJsonWriter.getMessageString(value, new Object[0], locale);
        if (msg == null && locale != Locale.ENGLISH) {
            msg = DirectoryEntryJsonWriter.getMessageString(value, new Object[0], Locale.ENGLISH);
        }
        if (msg != null && !msg.equals(value)) {
            jg.writeString(msg);
            return true;
        }
        return false;
    }

    public static String getMessageString(String key, Object[] params, Locale locale) {
        try {
            return I18NUtils.getMessageString((String)MESSAGES_BUNDLE, (String)key, (Object[])params, (Locale)locale);
        }
        catch (MissingResourceException e) {
            log.trace((Object)"No bundle found", (Throwable)e);
            return null;
        }
    }
}

