/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.ContainerBase;
import org.nuxeo.osgi.application.FrameworkBootstrap;

public class NuxeoDeployer
implements LifecycleListener {
    protected String home = "nxserver";
    protected FrameworkBootstrap bootstrap;

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle lf = event.getLifecycle();
        if (lf instanceof ContainerBase) {
            ContainerBase container = (ContainerBase)lf;
            this.handleEvent(container, event);
        }
    }

    protected void handleEvent(ContainerBase container, LifecycleEvent event) {
        block19: {
            try {
                ClassLoader parentCl = container.getParentClassLoader();
                String type = event.getType();
                if (type != "before_start") break block19;
                File homeDir = this.resolveHomeDirectory();
                File bundles = new File(homeDir, "bundles");
                File lib = new File(homeDir, "lib");
                File deployerJar = FrameworkBootstrap.findFileStartingWidth((File)bundles, (String)"nuxeo-runtime-deploy");
                File commonJar = FrameworkBootstrap.findFileStartingWidth((File)bundles, (String)"nuxeo-common");
                if (deployerJar == null || commonJar == null) {
                    System.out.println("Deployer and/or common JAR (nuxeo-runtime-deploy* | nuxeo-common*) not found in " + bundles);
                    return;
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                File[] files = lib.listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (!f.getPath().endsWith(".jar")) continue;
                        urls.add(f.toURI().toURL());
                    }
                }
                if ((files = bundles.listFiles()) != null) {
                    for (File f : files) {
                        if (!f.getPath().endsWith(".jar")) continue;
                        urls.add(f.toURI().toURL());
                    }
                }
                urls.add(homeDir.toURI().toURL());
                urls.add(new File(homeDir, "config").toURI().toURL());
                try (URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentCl);){
                    System.out.println("# Running Nuxeo Preprocessor ...");
                    Class<?> klass = cl.loadClass("org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor");
                    Method main = klass.getMethod("main", String[].class);
                    main.invoke(null, new Object[]{new String[]{homeDir.getAbsolutePath()}});
                    System.out.println("# Preprocessing done.");
                }
            }
            catch (IOException | ReflectiveOperationException e) {
                throw new RuntimeException("Failed to handle event", e);
            }
        }
    }

    protected File resolveHomeDirectory() {
        String path = this.home.startsWith("/") ? this.home : this.getTomcatHome() + "/" + this.home;
        return new File(path);
    }

    public String getTomcatHome() {
        String tomcatHome = System.getProperty("catalina.base");
        if (tomcatHome == null) {
            tomcatHome = System.getProperty("catalina.home");
        }
        return tomcatHome;
    }
}

