/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.application.FrameworkBootstrap;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.runtime.tomcat.dev.DevBundle;
import org.nuxeo.runtime.tomcat.dev.DevBundleType;
import org.nuxeo.runtime.tomcat.dev.DevBundlesManager;
import org.nuxeo.runtime.tomcat.dev.FrameworkInvoker;
import org.nuxeo.runtime.tomcat.dev.IOUtils;
import org.nuxeo.runtime.tomcat.dev.NuxeoDevWebappClassLoader;
import org.nuxeo.runtime.tomcat.dev.ReloadServiceInvoker;

public class DevFrameworkBootstrap
extends FrameworkBootstrap
implements DevBundlesManager {
    public static final String DEV_BUNDLES_NAME = "org.nuxeo:type=sdk,name=dev-bundles";
    public static final String WEB_RESOURCES_NAME = "org.nuxeo:type=sdk,name=web-resources";
    public static final String USE_COMPAT_HOT_RELOAD = "nuxeo.hotreload.compat.mechanism";
    protected static final String DEV_BUNDLES_CP = "dev-bundles/*";
    protected final Log log = LogFactory.getLog(DevFrameworkBootstrap.class);
    protected DevBundle[] devBundles;
    protected Timer bundlesCheck;
    protected long lastModified = 0L;
    protected ReloadServiceInvoker reloadServiceInvoker;
    protected File devBundlesFile;
    protected final File seamdev;
    protected final File webclasses;
    protected boolean compatHotReload;

    public DevFrameworkBootstrap(MutableClassLoader cl, File home) throws IOException {
        super(cl, home);
        this.devBundlesFile = new File(home, "dev.bundles");
        this.seamdev = new File(home, "nuxeo.war/WEB-INF/dev");
        this.webclasses = new File(home, "nuxeo.war/WEB-INF/classes");
        this.devBundles = new DevBundle[0];
    }

    public void start(MutableClassLoader cl) throws ReflectiveOperationException, IOException, JMException {
        this.preloadDevBundles();
        super.start(cl);
        ClassLoader loader = (ClassLoader)this.loader;
        this.reloadServiceInvoker = new ReloadServiceInvoker(loader);
        this.compatHotReload = new FrameworkInvoker(loader).isBooleanPropertyTrue(USE_COMPAT_HOT_RELOAD);
        this.writeComponentIndex();
        this.postloadDevBundles();
        String installReloadTimerOption = (String)this.env.get("org.nuxeo.app.installReloadTimer");
        if (installReloadTimerOption != null && Boolean.parseBoolean(installReloadTimerOption)) {
            this.toggleTimer();
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(this, new ObjectName(DEV_BUNDLES_NAME));
        server.registerMBean(cl, new ObjectName(WEB_RESOURCES_NAME));
    }

    protected void initializeEnvironment() throws IOException {
        super.initializeEnvironment();
        this.env.computeIfPresent("org.nuxeo.app.bundles", (k, v) -> v + ":" + DEV_BUNDLES_CP);
    }

    @Override
    public void toggleTimer() {
        if (this.isTimerRunning()) {
            this.bundlesCheck.cancel();
            this.bundlesCheck = null;
        } else {
            this.bundlesCheck = new Timer("Dev Bundles Loader");
            this.bundlesCheck.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DevFrameworkBootstrap.this.loadDevBundles();
                    }
                    catch (RuntimeException e) {
                        DevFrameworkBootstrap.this.log.error((Object)"Failed to reload dev bundles", (Throwable)e);
                    }
                }
            }, 2000L, 2000L);
        }
    }

    @Override
    public boolean isTimerRunning() {
        return this.bundlesCheck != null;
    }

    public void stop(MutableClassLoader cl) throws ReflectiveOperationException, JMException {
        if (this.bundlesCheck != null) {
            this.bundlesCheck.cancel();
            this.bundlesCheck = null;
        }
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            server.unregisterMBean(new ObjectName(DEV_BUNDLES_NAME));
            server.unregisterMBean(new ObjectName(WEB_RESOURCES_NAME));
        }
        finally {
            super.stop(cl);
        }
    }

    @Override
    public String getDevBundlesLocation() {
        return this.devBundlesFile.getAbsolutePath();
    }

    @Deprecated
    protected void preloadDevBundles() throws IOException {
        if (!this.compatHotReload) {
            return;
        }
        if (!this.devBundlesFile.isFile()) {
            return;
        }
        this.lastModified = this.devBundlesFile.lastModified();
        this.devBundles = DevBundle.parseDevBundleLines(new FileInputStream(this.devBundlesFile));
        if (this.devBundles.length > 0) {
            this.installNewClassLoader(this.devBundles);
        }
    }

    @Deprecated
    protected void postloadDevBundles() throws ReflectiveOperationException {
        if (!this.compatHotReload) {
            return;
        }
        if (this.devBundles.length > 0) {
            this.reloadServiceInvoker.hotDeployBundles(this.devBundles);
        }
    }

    @Override
    public void loadDevBundles() {
        long tm = this.devBundlesFile.lastModified();
        if (this.lastModified >= tm) {
            return;
        }
        this.lastModified = tm;
        try {
            this.reloadDevBundles(DevBundle.parseDevBundleLines(new FileInputStream(this.devBundlesFile)));
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new RuntimeException("Failed to reload dev bundles", e);
        }
    }

    @Override
    public void resetDevBundles(String path) {
        try {
            this.devBundlesFile = new File(path);
            this.lastModified = 0L;
            this.loadDevBundles();
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Unable to reset dev bundles", (Throwable)e);
        }
    }

    @Override
    public DevBundle[] getDevBundles() {
        return this.devBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reloadDevBundles(DevBundle[] bundles) throws ReflectiveOperationException, IOException {
        long begin = System.currentTimeMillis();
        if (this.compatHotReload) {
            if (this.devBundles.length > 0) {
                try {
                    this.reloadServiceInvoker.hotUndeployBundles(this.devBundles);
                    this.clearClassLoader();
                }
                finally {
                    this.devBundles = new DevBundle[0];
                }
            }
            if (bundles.length > 0) {
                try {
                    this.installNewClassLoader(bundles);
                    this.reloadServiceInvoker.hotDeployBundles(bundles);
                }
                finally {
                    this.devBundles = bundles;
                }
            }
        } else {
            DevBundle[] bundlesToDeploy = bundles;
            try {
                bundlesToDeploy = this.reloadServiceInvoker.hotReloadBundles(this.devBundles, bundlesToDeploy);
                this.writeDevBundles(bundlesToDeploy);
            }
            finally {
                this.devBundles = bundlesToDeploy;
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("Hot reload has been run in %s ms", System.currentTimeMillis() - begin));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDevBundles(DevBundle[] devBundles) throws IOException {
        boolean timerExists = this.isTimerRunning();
        if (timerExists) {
            this.toggleTimer();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.devBundlesFile.toPath(), new OpenOption[0]);){
            for (DevBundle devBundle : devBundles) {
                writer.write(devBundle.toString());
            }
        }
        finally {
            if (timerExists) {
                this.lastModified = System.currentTimeMillis();
                this.toggleTimer();
            }
        }
    }

    protected Path zipDirectory(final Path source, Path target, final CopyOption ... options) throws IOException {
        if (!source.toFile().isDirectory()) {
            throw new IllegalArgumentException("Source argument must be a directory to zip");
        }
        URI uri = URI.create("jar:file:" + target.toString());
        try (final FileSystem zipfs = FileSystems.newFileSystem(uri, Collections.singletonMap("create", "true"));){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (source.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return this.visitFile(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativePath = source.relativize(file);
                    Path pathInZipFile = zipfs.getPath(relativePath.toString(), new String[0]);
                    Files.copy(file, pathInZipFile, options);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return target;
    }

    @Deprecated
    protected void clearClassLoader() {
        NuxeoDevWebappClassLoader devLoader = (NuxeoDevWebappClassLoader)this.loader;
        devLoader.clear();
        System.gc();
    }

    @Deprecated
    protected void installNewClassLoader(DevBundle[] bundles) {
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        ArrayList<File> seamDirs = new ArrayList<File>();
        ArrayList<File> resourceBundleFragments = new ArrayList<File>();
        for (DevBundle bundle : bundles) {
            if (bundle.devBundleType.isJar) {
                try {
                    jarUrls.add(bundle.url());
                }
                catch (IOException e) {
                    this.log.error((Object)("Cannot install " + bundle));
                }
                continue;
            }
            if (bundle.devBundleType == DevBundleType.Seam) {
                seamDirs.add(bundle.file());
                continue;
            }
            if (bundle.devBundleType != DevBundleType.ResourceBundleFragment) continue;
            resourceBundleFragments.add(bundle.file());
        }
        NuxeoDevWebappClassLoader devLoader = (NuxeoDevWebappClassLoader)this.loader;
        devLoader.createLocalClassLoader(jarUrls.toArray(new URL[jarUrls.size()]));
        try {
            this.installSeamClasses(seamDirs.toArray(new File[seamDirs.size()]));
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot install seam classes in hotsync folder", (Throwable)e);
        }
        try {
            this.installResourceBundleFragments(resourceBundleFragments);
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot install l10n resources", (Throwable)e);
        }
    }

    public void writeComponentIndex() {
        File file = new File(this.home.getParentFile(), "sdk");
        file.mkdirs();
        file = new File(file, "components.index");
        try {
            Method m = this.getClassLoader().loadClass("org.nuxeo.runtime.model.impl.ComponentRegistrySerializer").getMethod("writeIndex", File.class);
            m.invoke(null, file);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Deprecated
    public void installSeamClasses(File[] dirs) throws IOException {
        if (this.seamdev.exists()) {
            IOUtils.deleteTree(this.seamdev);
        }
        this.seamdev.mkdirs();
        for (File dir : dirs) {
            IOUtils.copyTree(dir, this.seamdev);
        }
    }

    @Deprecated
    public void installResourceBundleFragments(List<File> files) throws IOException {
        HashMap fragments = new HashMap();
        for (File file : files) {
            String name = DevFrameworkBootstrap.resourceBundleName(file);
            if (!fragments.containsKey(name)) {
                fragments.put(name, new ArrayList());
            }
            ((List)fragments.get(name)).add(file);
        }
        for (String name : fragments.keySet()) {
            IOUtils.appendResourceBundleFragments(name, (List)fragments.get(name), this.webclasses);
        }
    }

    @Deprecated
    protected static String resourceBundleName(File file) {
        String name = file.getName();
        return name.substring(name.lastIndexOf(45) + 1);
    }
}

