/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.osgi.framework.Bundle;

public class RedisComponent
extends DefaultComponent
implements RedisAdmin {
    private static final String DEFAULT_PREFIX = "nuxeo:";
    protected volatile RedisExecutor executor;
    protected RedisPoolDescriptorRegistry registry = new RedisPoolDescriptorRegistry();
    protected String delsha;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.registry.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!(contribution instanceof RedisPoolDescriptor)) {
            throw new RuntimeException("Unknown contribution class: " + contribution);
        }
        this.registerRedisPoolDescriptor((RedisPoolDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof RedisPoolDescriptor) {
            this.unregisterRedisPoolDescriptor((RedisPoolDescriptor)contribution);
        }
    }

    public void registerRedisPoolDescriptor(RedisPoolDescriptor contrib) {
        this.registry.addContribution(contrib);
    }

    public void unregisterRedisPoolDescriptor(RedisPoolDescriptor contrib) {
        this.registry.removeContribution(contrib);
    }

    @Override
    public RedisPoolDescriptor getConfig() {
        return this.registry.getConfig();
    }

    public void start(ComponentContext context) {
        RedisPoolDescriptor config = this.getConfig();
        if (config == null || config.disabled) {
            return;
        }
        this.handleNewExecutor(config.newExecutor());
    }

    public void stop(ComponentContext context) {
        if (this.executor == null) {
            return;
        }
        try {
            this.executor.getPool().destroy();
        }
        finally {
            this.executor = null;
        }
    }

    public int getApplicationStartedOrder() {
        return ((DefaultComponent)Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.work.service").getInstance()).getApplicationStartedOrder() - 1;
    }

    public void handleNewExecutor(RedisExecutor executor) {
        this.executor = executor;
        try {
            this.delsha = this.load("org.nuxeo.runtime.redis", "del-keys");
        }
        catch (RuntimeException cause) {
            executor = null;
            throw new RuntimeException("Cannot activate redis executor", cause);
        }
    }

    @Override
    public Long clear(String pattern) {
        return (Long)this.executor.evalsha(this.delsha, Collections.singletonList(pattern), Collections.emptyList());
    }

    @Override
    public String load(String bundleName, String scriptName) {
        StrBuilder builder;
        Bundle b = Framework.getRuntime().getBundle(bundleName);
        URL loc = b.getEntry(scriptName + ".lua");
        if (loc == null) {
            throw new RuntimeException("Fail to load lua script: " + scriptName);
        }
        try {
            InputStream is = loc.openStream();
            builder = new StrBuilder();
            for (String line : IOUtils.readLines((InputStream)is)) {
                builder.appendln(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to load lua script: " + scriptName, e);
        }
        return this.executor.scriptLoad(builder.toString());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(RedisExecutor.class)) {
            return adapter.cast(this.executor);
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public String namespace(String ... names) {
        String prefix;
        RedisPoolDescriptor config = this.getConfig();
        String string = prefix = config == null ? null : config.prefix;
        if (StringUtils.isBlank((String)prefix)) {
            prefix = DEFAULT_PREFIX;
        }
        StringBuilder builder = new StringBuilder(prefix);
        for (String name : names) {
            builder.append(name).append(":");
        }
        return builder.toString();
    }

    public static class RedisPoolDescriptorRegistry
    extends SimpleContributionRegistry<RedisPoolDescriptor> {
        protected RedisPoolDescriptor config;

        public String getContributionId(RedisPoolDescriptor contrib) {
            return "main";
        }

        public void contributionUpdated(String id, RedisPoolDescriptor contrib, RedisPoolDescriptor newOrigContrib) {
            this.config = contrib;
        }

        public void contributionRemoved(String id, RedisPoolDescriptor origContrib) {
            this.config = null;
        }

        public RedisPoolDescriptor getConfig() {
            return this.config;
        }

        public void clear() {
            this.config = null;
        }
    }
}

