/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.web.resources.wro.provider.NuxeoUriLocator;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

public abstract class AbstractFlavorProcessor
implements ResourcePreProcessor {
    @Inject
    protected ReadOnlyContext context;

    public abstract String getAlias();

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String flavor = this.getFlavor();
        if (!StringUtils.isBlank((String)flavor) && this.isEnabled(resource)) {
            this.process(resource, reader, writer, flavor);
        } else {
            this.process(resource, reader, writer, null);
        }
    }

    protected abstract void process(Resource var1, Reader var2, Writer var3, String var4) throws IOException;

    public String getEncoding() {
        return Context.isContextSet() ? this.context.getConfig().getEncoding() : "UTF-8";
    }

    protected String getFlavor() {
        Map params;
        String queryString = this.context.getRequest().getQueryString();
        if (queryString != null && (params = URIUtils.getRequestParameters((String)queryString)) != null && params.containsKey("flavor")) {
            return (String)params.get("flavor");
        }
        return null;
    }

    protected boolean isEnabled(Resource resource) {
        return NuxeoUriLocator.isProcessorEnabled(this.getAlias(), resource.getUri());
    }
}

