/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.client.vindoz.InstallAfterRestart;
import org.nuxeo.connect.client.we.RequestHelper;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.Field;
import org.nuxeo.connect.update.model.Form;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="installHandler")
public class InstallHandler
extends DefaultObject {
    protected static final Log log = LogFactory.getLog(InstallHandler.class);
    protected static final String INSTALL_PARAM_MAPS = "org.nuxeo.connect.updates.install.params";

    protected String getStorageKey(String pkgId) {
        return "org.nuxeo.connect.updates.install.params_" + pkgId;
    }

    protected Map<String, String> getInstallParameters(String pkgId) {
        HashMap params = (HashMap)this.getContext().getRequest().getAttribute(this.getStorageKey(pkgId));
        if (params == null) {
            params = new HashMap();
        }
        return params;
    }

    protected void storeInstallParameters(String pkgId, Map<String, String> params) {
        this.getContext().getRequest().setAttribute(this.getStorageKey(pkgId), params);
    }

    protected void clearInstallParameters(String pkgId) {
        this.getContext().getRequest().setAttribute(this.getStorageKey(pkgId), null);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="showTermsAndConditions/{pkgId}")
    public Object showTermsAndConditions(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source, @QueryParam(value="depCheck") Boolean depCheck) {
        if (depCheck == null) {
            depCheck = true;
        }
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
            LocalPackage pkg = pus.getPackage(pkgId);
            String content = pkg.getTermsAndConditionsContent();
            return this.getView("termsAndConditions").arg("pkg", (Object)pkg).arg("source", (Object)source).arg("content", (Object)content).arg("depCheck", (Object)depCheck);
        }
        catch (PackageException e) {
            log.error((Object)"Error during terms and conditions phase ", (Throwable)e);
            return this.getView("installError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="start/{pkgId}")
    public Object startInstall(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source, @QueryParam(value="tacAccepted") Boolean acceptedTAC, @QueryParam(value="depCheck") Boolean depCheck, @QueryParam(value="autoMode") Boolean autoMode) {
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
            LocalPackage pkg = pus.getPackage(pkgId);
            if (pkg == null) {
                throw new NuxeoException("Can not find package " + pkgId);
            }
            if (pkg.requireTermsAndConditionsAcceptance() && !Boolean.TRUE.equals(acceptedTAC)) {
                return this.showTermsAndConditions(pkgId, source, depCheck);
            }
            if (!Boolean.FALSE.equals(depCheck) && pkg.getDependencies() != null && pkg.getDependencies().length > 0) {
                PackageManager pm = (PackageManager)Framework.getService(PackageManager.class);
                DependencyResolution resolution = pm.resolveDependencies(Collections.singletonList(pkgId), Collections.emptyList(), Collections.emptyList(), PlatformVersionHelper.getPlatformFilter());
                if (resolution.isFailed() && PlatformVersionHelper.getPlatformFilter() != null) {
                    resolution = pm.resolveDependencies(Collections.singletonList(pkgId), Collections.emptyList(), Collections.emptyList(), null);
                }
                if (resolution.isFailed()) {
                    return this.getView("dependencyError").arg("resolution", (Object)resolution).arg("pkg", (Object)pkg).arg("source", (Object)source);
                }
                if (resolution.requireChanges()) {
                    if (autoMode == null) {
                        autoMode = true;
                    }
                    return this.getView("displayDependencies").arg("resolution", (Object)resolution).arg("pkg", (Object)pkg).arg("source", (Object)source).arg("autoMode", (Object)autoMode);
                }
            }
            Task installTask = pkg.getInstallTask();
            ValidationStatus status = installTask.validate();
            String targetPlatform = PlatformVersionHelper.getPlatformFilter();
            if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform((Package)pkg, (String)targetPlatform)) {
                status.addWarning("This package is not validated for you current platform: " + targetPlatform);
            }
            if (status.hasErrors()) {
                return this.getView("canNotInstall").arg("status", (Object)status).arg("pkg", (Object)pkg).arg("source", (Object)source);
            }
            boolean needWizard = false;
            Form[] forms = installTask.getPackage().getInstallForms();
            if (forms != null && forms.length > 0) {
                needWizard = true;
            }
            return this.getView("startInstall").arg("status", (Object)status).arg("needWizard", (Object)needWizard).arg("installTask", (Object)installTask).arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        catch (PackageException e) {
            log.error((Object)"Error during first step of installation", (Throwable)e);
            return this.getView("installError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="form/{pkgId}/{formId}")
    public Object showInstallForm(@PathParam(value="pkgId") String pkgId, @PathParam(value="formId") int formId, @QueryParam(value="source") String source) {
        PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
        try {
            LocalPackage pkg = pus.getPackage(pkgId);
            Task installTask = pkg.getInstallTask();
            Form[] forms = installTask.getPackage().getInstallForms();
            if (forms == null || forms.length < formId - 1) {
                return this.getView("installError").arg("e", (Object)new NuxeoException("No form with Id " + formId + " for package " + pkgId)).arg("source", (Object)source);
            }
            return this.getView("showInstallForm").arg("form", (Object)forms[formId]).arg("pkg", (Object)pkg).arg("source", (Object)source).arg("step", (Object)(formId + 1)).arg("steps", (Object)forms.length);
        }
        catch (PackageException e) {
            log.error((Object)("Error during displaying Form nb " + formId), (Throwable)e);
            return this.getView("installError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="form/{pkgId}/{formId}")
    public Object processInstallForm(@PathParam(value="pkgId") String pkgId, @PathParam(value="formId") int formId, @QueryParam(value="source") String source) {
        PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
        try {
            LocalPackage pkg = pus.getPackage(pkgId);
            Task installTask = pkg.getInstallTask();
            Form[] forms = installTask.getPackage().getInstallForms();
            if (forms == null || forms.length < formId - 1) {
                return this.getView("installError").arg("e", (Object)new NuxeoException("No form with Id " + formId + " for package " + pkgId)).arg("source", (Object)source);
            }
            Form form = forms[formId];
            FormData fdata = this.getContext().getForm();
            Map<String, String> params = this.getInstallParameters(pkgId);
            for (Field field : form.getFields()) {
                String data = fdata.getString(field.getName());
                if (data == null) continue;
                params.put(field.getName(), data);
            }
            this.storeInstallParameters(pkgId, params);
            if (formId + 1 == forms.length) {
                return this.doInstall(pkgId, source);
            }
            return this.showInstallForm(pkgId, formId + 1, source);
        }
        catch (PackageException e) {
            log.error((Object)("Error during processing Form nb " + formId), (Throwable)e);
            return this.getView("installError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="bulkRun/{pkgId}")
    public Object doBulkInstall(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source, @QueryParam(value="confirm") Boolean confirm) {
        if (!RequestHelper.isInternalLink(this.getContext())) {
            return this.getView("installError").arg("e", (Object)new NuxeoException("Installation seems to have been started from an external link.")).arg("source", (Object)source);
        }
        PackageManager pm = (PackageManager)Framework.getService(PackageManager.class);
        PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
        try {
            List downloadPackagesIds;
            DependencyResolution resolution = pm.resolveDependencies(Collections.singletonList(pkgId), Collections.emptyList(), Collections.emptyList(), PlatformVersionHelper.getPlatformFilter());
            if (resolution.isFailed() && PlatformVersionHelper.getPlatformFilter() != null) {
                resolution = pm.resolveDependencies(Collections.singletonList(pkgId), Collections.emptyList(), Collections.emptyList(), null);
            }
            if ((downloadPackagesIds = resolution.getDownloadPackageIds()).size() > 0) {
                return this.getView("installError").arg("e", (Object)new NuxeoException("Some packages need to be downloaded before running bulk installation")).arg("source", (Object)source);
            }
            List pkgIds = resolution.getOrderedPackageIdsToInstall();
            ArrayList<String> warns = new ArrayList<String>();
            ArrayList<String> descs = new ArrayList<String>();
            if (!pkgIds.contains(pkgId)) {
                pkgIds.add(pkgId);
            }
            ArrayList<String> rmPkgIds = new ArrayList<String>();
            for (Map.Entry rmEntry : resolution.getLocalPackagesToRemove().entrySet()) {
                String id = (String)rmEntry.getKey() + "-" + ((Version)rmEntry.getValue()).toString();
                rmPkgIds.add(id);
            }
            for (String id : pkgIds) {
                LocalPackage pkg = pus.getPackage(id);
                if (pkg == null) {
                    return this.getView("installError").arg("e", (Object)new NuxeoException("Unable to find local package " + id)).arg("source", (Object)source);
                }
                String targetPlatform = PlatformVersionHelper.getPlatformFilter();
                if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform((Package)pkg, (String)targetPlatform)) {
                    warns.add("Package " + id + " is not validated for your current platform: " + targetPlatform);
                }
                descs.add(pkg.getDescription());
            }
            if (Boolean.TRUE.equals(confirm)) {
                for (String id : rmPkgIds) {
                    InstallAfterRestart.addPackageForUnInstallation(id);
                }
                for (String id : pkgIds) {
                    InstallAfterRestart.addPackageForInstallation(id);
                }
                return this.getView("bulkInstallOnRestart").arg("pkgIds", (Object)pkgIds).arg("rmPkgIds", rmPkgIds).arg("source", (Object)source);
            }
            return this.getView("bulkInstallOnRestartConfirm").arg("pkgIds", (Object)pkgIds).arg("rmPkgIds", rmPkgIds).arg("warns", warns).arg("descs", descs).arg("source", (Object)source).arg("pkgId", (Object)pkgId);
        }
        catch (PackageException e) {
            log.error((Object)("Error during installation of " + pkgId), (Throwable)e);
            return this.getView("installError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="run/{pkgId}")
    public Object doInstall(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source) {
        if (!RequestHelper.isInternalLink(this.getContext())) {
            return this.getView("installError").arg("e", (Object)new NuxeoException("Installation seems to have been started from an external link.")).arg("source", (Object)source);
        }
        PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
        try {
            LocalPackage pkg = pus.getPackage(pkgId);
            if (InstallAfterRestart.isNeededForPackage((Package)pkg)) {
                InstallAfterRestart.addPackageForInstallation(pkg.getId());
                return this.getView("installOnRestart").arg("pkg", (Object)pkg).arg("source", (Object)source);
            }
            Task installTask = pkg.getInstallTask();
            Map<String, String> params = this.getInstallParameters(pkgId);
            try {
                installTask.run(params);
            }
            catch (PackageException e) {
                log.error((Object)("Error during installation of " + pkgId), (Throwable)e);
                installTask.rollback();
                return this.getView("installError").arg("e", (Object)e).arg("source", (Object)source);
            }
            this.clearInstallParameters(pkgId);
            return this.getView("installedOK").arg("installTask", (Object)installTask).arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        catch (PackageException e) {
            log.error((Object)("Error during installation of " + pkgId), (Throwable)e);
            return this.getView("installError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }
}

