/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCtlManager {
    protected static final String CMD_POSIX = "nuxeoctl";
    protected static final String CMD_WIN = "nuxeoctl.bat";
    protected static final Log log = LogFactory.getLog(NuxeoCtlManager.class);
    private ConfigurationGenerator cg;
    private static boolean restartInProgress = false;

    @Deprecated
    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    private static String winEscape(String command) {
        return command.replaceAll("([ ()<>&])", "^$1");
    }

    protected static boolean doExec(String path, String logPath) {
        try {
            Object[] cmd = NuxeoCtlManager.getCommand(path);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restart command: " + StringUtils.join((Object[])cmd, (String)" ")));
            }
            ProcessBuilder pb = new ProcessBuilder((String[])cmd).redirectOutput(new File(logPath, "restart.log")).redirectError(new File(logPath, "restart-err.log"));
            pb.start();
        }
        catch (IOException e) {
            log.error((Object)"Unable to restart server", (Throwable)e);
            return false;
        }
        return true;
    }

    protected static String[] getCommand(String path) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new String[]{"cmd", "/C", NuxeoCtlManager.winEscape(new File(path, CMD_WIN).getPath()), "--gui=false", "restartbg"};
        }
        return new String[]{"/bin/sh", "-c", "\"" + new File(path, CMD_POSIX).getPath() + "\"" + " restartbg"};
    }

    public static synchronized boolean restart() {
        if (restartInProgress) {
            return false;
        }
        restartInProgress = true;
        String nuxeoHome = Framework.getProperty((String)"nuxeo.home");
        final String binPath = new File(nuxeoHome, "bin").getPath();
        final String logDir = Framework.getProperty((String)"nuxeo.log.dir", (String)nuxeoHome);
        new Thread("restart thread"){

            @Override
            public void run() {
                try {
                    log.info((Object)"Restarting Nuxeo server");
                    Thread.sleep(3000L);
                    NuxeoCtlManager.doExec(binPath, logDir);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Restart failed", (Throwable)e);
                }
            }
        }.start();
        return true;
    }

    public String restartServer() {
        NuxeoCtlManager.restart();
        return "Nuxeo server is restarting";
    }

    public String getServerURL() {
        if (this.cg == null) {
            this.cg = new ConfigurationGenerator();
            this.cg.init();
        }
        return this.cg.getUserConfig().getProperty("nuxeo.url");
    }
}

