/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.operation;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.admin.runtime.ReloadHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Service.HotReloadStudioSnapshot", category="Services", label="Hot Reload Studio Snapshot Package", description="Updates Studio project with latest snapshot.")
public class HotReloadStudioSnapshot {
    protected static final String inProgress = "updateInProgress";
    protected static final String success = "success";
    protected static final String error = "error";
    protected static final String dependencyMismatch = "dependencyMismatch";
    public static final String ID = "Service.HotReloadStudioSnapshot";
    protected static boolean updateInProgress = false;
    private static final Log log = LogFactory.getLog(HotReloadStudioSnapshot.class);
    @Context
    protected CoreSession session;
    @Context
    protected PackageManager pm;
    @Param(name="validate", required=false)
    protected boolean validate = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run() {
        if (updateInProgress) {
            return HotReloadStudioSnapshot.jsonHelper(inProgress, "Update in progress.", null);
        }
        if (!((NuxeoPrincipal)this.session.getPrincipal()).isAdministrator()) {
            return HotReloadStudioSnapshot.jsonHelper(error, "Must be Administrator to use this function.", null);
        }
        if (!Framework.isDevModeSet()) {
            return HotReloadStudioSnapshot.jsonHelper(error, "You must enable Dev mode to Hot reload your Studio Snapshot package.", null);
        }
        List pkgs = this.pm.listRemoteAssociatedStudioPackages();
        DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
        if (snapshotPkg == null) {
            return HotReloadStudioSnapshot.jsonHelper(error, "No Snapshot Package was found.", null);
        }
        try {
            updateInProgress = true;
            Blob blob = this.hotReloadPackage(snapshotPkg);
            return blob;
        }
        finally {
            updateInProgress = false;
        }
    }

    public Blob hotReloadPackage(DownloadablePackage remotePkg) {
        boolean useCompatReload;
        String packageId;
        if (this.validate) {
            this.pm.flushCache();
            String targetPlatform = PlatformVersionHelper.getPlatformFilter();
            if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform((Package)remotePkg, (String)targetPlatform)) {
                return HotReloadStudioSnapshot.jsonHelper(error, String.format("This package is not validated for your current platform: %s", targetPlatform), null);
            }
            PackageDependency[] pkgDeps = remotePkg.getDependencies();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%s target platforms: %s", remotePkg, ArrayUtils.toString((Object)remotePkg.getTargetPlatforms())));
                log.debug((Object)String.format("%s dependencies: %s", remotePkg, ArrayUtils.toString((Object)pkgDeps)));
            }
            packageId = remotePkg.getId();
            if (pkgDeps != null && pkgDeps.length > 0) {
                DependencyResolution resolution = this.pm.resolveDependencies(packageId, targetPlatform);
                if (resolution.isFailed() && targetPlatform != null) {
                    resolution = this.pm.resolveDependencies(packageId, null);
                }
                if (resolution.isFailed()) {
                    return HotReloadStudioSnapshot.jsonHelper(dependencyMismatch, String.format("Dependency check has failed for package '%s' (%s)", packageId, resolution), null);
                }
                List pkgToInstall = resolution.getInstallPackageIds();
                if ((pkgToInstall == null || pkgToInstall.size() != 1 || !packageId.equals(pkgToInstall.get(0))) && resolution.requireChanges()) {
                    ArrayList<String> dependencies = new ArrayList<String>();
                    for (String dependency : resolution.getInstallPackageNames()) {
                        if (dependency.contains(remotePkg.getName())) continue;
                        dependencies.add(dependency);
                    }
                    return HotReloadStudioSnapshot.jsonHelper(dependencyMismatch, "A dependency mismatch has been detected. Please check your Studio project settings and your server configuration.", dependencies);
                }
            }
        }
        if (!(useCompatReload = Framework.isBooleanPropertyTrue((String)"nuxeo.hotreload.compat.mechanism"))) {
            log.info((Object)"Use hot reload update mechanism");
            ReloadHelper.hotReloadPackage(remotePkg.getId());
            return HotReloadStudioSnapshot.jsonHelper(success, "Studio package installed.", null);
        }
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
            packageId = remotePkg.getId();
            LocalPackage pkg = pus.getPackage(packageId);
            if (pkg != null) {
                HotReloadStudioSnapshot.removePackage(pus, pkg);
            }
            DownloadingPackage downloadingPkg = this.pm.download(packageId);
            while (!downloadingPkg.isCompleted()) {
                log.debug((Object)("Downloading studio snapshot package: " + packageId));
                Thread.sleep(100L);
            }
            log.info((Object)("Installing " + packageId));
            pkg = pus.getPackage(packageId);
            if (pkg == null || PackageState.DOWNLOADED != pkg.getPackageState()) {
                throw new NuxeoException("Error while downloading studio snapshot " + pkg);
            }
            Task installTask = pkg.getInstallTask();
            try {
                HotReloadStudioSnapshot.performTask(installTask);
                return HotReloadStudioSnapshot.jsonHelper(success, "Studio package installed.", null);
            }
            catch (PackageException e) {
                installTask.rollback();
                throw e;
            }
        }
        catch (InterruptedException e) {
            ExceptionUtils.checkInterrupt((Exception)e);
            throw new NuxeoException("Error while downloading studio snapshot", (Throwable)e);
        }
        catch (ConnectServerError | PackageException e) {
            throw new NuxeoException("Error while installing studio snapshot", e);
        }
    }

    protected static void removePackage(PackageUpdateService pus, LocalPackage pkg) throws PackageException {
        log.info((Object)String.format("Removing package %s before update...", pkg.getId()));
        if (pkg.getPackageState().isInstalled()) {
            log.info((Object)("Uninstalling " + pkg.getId()));
            Task uninstallTask = pkg.getUninstallTask();
            try {
                HotReloadStudioSnapshot.performTask(uninstallTask);
            }
            catch (PackageException e) {
                uninstallTask.rollback();
                throw e;
            }
        }
        pus.removePackage(pkg.getId());
    }

    protected static void performTask(Task task) throws PackageException {
        ValidationStatus validationStatus = task.validate();
        if (validationStatus.hasErrors()) {
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
        }
        if (validationStatus.hasWarnings()) {
            log.warn((Object)("Got warnings on package validation " + task.getPackage().getId() + " -> " + validationStatus.getWarnings()));
        }
        task.run(null);
    }

    protected static Blob jsonHelper(String status, String message, List<String> dependencies) {
        JSONObject resultJSON = new JSONObject();
        JSONArray result = new JSONArray();
        resultJSON.put((Object)"status", (Object)status);
        resultJSON.put((Object)"message", (Object)message);
        if (dependencies != null) {
            resultJSON.put((Object)"deps", dependencies);
        }
        result.add((Object)resultJSON);
        return Blobs.createJSONBlob((String)result.toString());
    }
}

