/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.elasticsearch;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;

@Operation(id="Elasticsearch.Index", category="Services", label="Elasticsearch Indexing", since="8.1", description="Enable to index Nuxeo documents.")
public class ElasticsearchIndexOperation {
    public static final String ID = "Elasticsearch.Index";
    private static final Log log = LogFactory.getLog(Log.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected ElasticSearchIndexing esi;
    @Context
    protected ElasticSearchAdmin esa;
    @Context
    protected CoreSession repo;

    @OperationMethod
    public void run() {
        this.checkAccess();
        this.esi.reindexRepository(this.repo.getRepositoryName());
    }

    private void checkAccess() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
        if (principal == null || !principal.isAdministrator()) {
            throw new NuxeoException("Unauthorized access: " + principal);
        }
    }

    @OperationMethod
    public void run(String nxql) {
        this.checkAccess();
        this.esi.runReindexingWorker(this.repo.getRepositoryName(), nxql);
    }

    @OperationMethod
    public void run(DocumentModel doc) {
        this.checkAccess();
        IndexingCommand cmd = new IndexingCommand(doc, IndexingCommand.Type.DELETE, false, true);
        this.esi.runIndexingWorker(Arrays.asList(cmd));
        cmd = new IndexingCommand(doc, IndexingCommand.Type.INSERT, false, true);
        this.esi.runIndexingWorker(Arrays.asList(cmd));
    }
}

