/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.elasticsearch;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Elasticsearch.WaitForIndexing", category="Services", label="Wait for Elasticsearch Indexing", since="8.1", description="Wait until Elasticsearch indexing is done.")
public class ElasticsearchWaitForIndexingOperation {
    public static final String ID = "Elasticsearch.WaitForIndexing";
    public static final String AUDIT_ELASTICSEARCH_ENABLED = "audit.elasticsearch.enabled";
    @Context
    protected ElasticSearchAdmin esa;
    @Context
    protected CoreSession repo;
    @Param(name="timeoutSecond", required=false)
    protected Integer timeout = 60;
    @Param(name="refresh", required=false)
    protected Boolean refresh = false;
    @Param(name="waitForAudit", required=false)
    protected Boolean waitForAudit = false;

    @OperationMethod
    public Boolean run() {
        long start = System.currentTimeMillis();
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        AuditLogger auditLogger = (AuditLogger)Framework.getService(AuditLogger.class);
        boolean waitForAuditStoredInEs = this.waitForAudit != false && Framework.isBooleanPropertyTrue((String)AUDIT_ELASTICSEARCH_ENABLED);
        try {
            if (!workManager.awaitCompletion((long)this.timeout.intValue(), TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            if (waitForAuditStoredInEs && !auditLogger.await(this.computeRemainingTime(start), TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            this.esa.prepareWaitForIndexing().get(this.computeRemainingTime(start), TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (ExceptionUtils.hasInterruptedCause((Throwable)e)) {
                Thread.currentThread().interrupt();
            }
            return Boolean.FALSE;
        }
        if (this.refresh.booleanValue()) {
            this.esa.refreshRepositoryIndex(this.repo.getRepositoryName());
            if (waitForAuditStoredInEs) {
                this.esa.getClient().refresh(this.esa.getIndexNameForType("entry"));
            }
        }
        return Boolean.TRUE;
    }

    protected long computeRemainingTime(long start) {
        long elapsed = System.currentTimeMillis() - start;
        return Long.max((long)this.timeout.intValue() - TimeUnit.MILLISECONDS.toSeconds(elapsed), 1L);
    }
}

