/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.DefaultOptions;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public class UrlParser {
    private static final String DISABLE_MYSQL_URL = "disableMariaDbDriver";
    private String database;
    private Options options = null;
    private List<HostAddress> addresses;
    private HaMode haMode;
    private String initialUrl;
    private boolean multiMaster = this.isMultiMaster();

    private UrlParser() {
    }

    protected UrlParser(String database, List<HostAddress> addresses, Options options, HaMode haMode) {
        this.options = options;
        this.database = database;
        this.addresses = addresses;
        this.haMode = haMode;
        if (haMode == HaMode.AURORA) {
            for (HostAddress hostAddress : addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
        this.multiMaster = this.loadMultiMasterValue();
    }

    public static boolean acceptsUrl(String url) {
        return url != null && (url.startsWith("jdbc:mariadb:") || url.startsWith("jdbc:mysql:") && !url.contains(DISABLE_MYSQL_URL));
    }

    public static UrlParser parse(String url) throws SQLException {
        return UrlParser.parse(url, new Properties());
    }

    public static UrlParser parse(String url, Properties prop) throws SQLException {
        if (url != null) {
            if (prop == null) {
                prop = new Properties();
            }
            if (url.startsWith("jdbc:mariadb:") || url.startsWith("jdbc:mysql:") && !url.contains(DISABLE_MYSQL_URL)) {
                UrlParser urlParser = new UrlParser();
                UrlParser.parseInternal(urlParser, url, prop);
                return urlParser;
            }
        }
        return null;
    }

    private static void parseInternal(UrlParser urlParser, String url, Properties properties) throws SQLException {
        try {
            String additionalParameters;
            String hostAddressesString;
            urlParser.initialUrl = url;
            int separator = url.indexOf("//");
            if (separator == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
            }
            UrlParser.setHaMode(urlParser, url, separator);
            String urlSecondPart = url.substring(separator + 2);
            int dbIndex = urlSecondPart.indexOf("/");
            int paramIndex = urlSecondPart.indexOf("?");
            if (dbIndex < paramIndex && dbIndex < 0 || dbIndex > paramIndex && paramIndex > -1) {
                hostAddressesString = urlSecondPart.substring(0, paramIndex);
                additionalParameters = urlSecondPart.substring(paramIndex);
            } else if (dbIndex < paramIndex && dbIndex > -1 || dbIndex > paramIndex && paramIndex < 0) {
                hostAddressesString = urlSecondPart.substring(0, dbIndex);
                additionalParameters = urlSecondPart.substring(dbIndex);
            } else {
                hostAddressesString = urlSecondPart;
                additionalParameters = null;
            }
            UrlParser.defineUrlParserParameters(urlParser, properties, hostAddressesString, additionalParameters);
            UrlParser.setDefaultHostAddressType(urlParser);
        }
        catch (IllegalArgumentException i) {
            throw new SQLException(i.getMessage());
        }
    }

    private static void defineUrlParserParameters(UrlParser urlParser, Properties properties, String hostAddressesString, String additionalParameters) {
        if (additionalParameters != null) {
            String regex = "(\\/([^\\?]*))?(\\?(.+))*";
            Pattern pattern = Pattern.compile(regex, 32);
            Matcher matcher = pattern.matcher(additionalParameters);
            if (matcher.find()) {
                urlParser.database = matcher.group(2);
                urlParser.options = DefaultOptions.parse(urlParser.haMode, matcher.group(4), properties, urlParser.options);
                if (urlParser.database != null && urlParser.database.isEmpty()) {
                    urlParser.database = null;
                }
            } else {
                urlParser.database = null;
                urlParser.options = DefaultOptions.parse(urlParser.haMode, "", properties, urlParser.options);
            }
        } else {
            urlParser.database = null;
            urlParser.options = DefaultOptions.parse(urlParser.haMode, "", properties, urlParser.options);
        }
        LoggerFactory.init(urlParser.options.log || urlParser.options.profileSql || urlParser.options.slowQueryThresholdNanos != null);
        urlParser.addresses = HostAddress.parse(hostAddressesString, urlParser.haMode);
    }

    public UrlParser auroraPipelineQuirks() {
        boolean disablePipeline = this.isAurora();
        if (this.options.useBatchMultiSend == null) {
            Boolean bl = this.options.useBatchMultiSend = disablePipeline ? Boolean.FALSE : Boolean.TRUE;
        }
        if (this.options.usePipelineAuth == null) {
            this.options.usePipelineAuth = disablePipeline ? Boolean.FALSE : Boolean.TRUE;
        }
        return this;
    }

    public boolean isAurora() {
        if (this.haMode == HaMode.AURORA) {
            return true;
        }
        if (this.addresses != null) {
            Pattern clusterPattern = Pattern.compile("(.+)\\.([a-z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
            for (HostAddress hostAddress : this.addresses) {
                Matcher matcher = clusterPattern.matcher(hostAddress.host);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    private static void setHaMode(UrlParser urlParser, String url, int separator) {
        String[] baseTokens = url.substring(0, separator).split(":");
        urlParser.haMode = HaMode.NONE;
        if (baseTokens.length > 2) {
            try {
                urlParser.haMode = HaMode.valueOf(baseTokens[2].toUpperCase());
            }
            catch (IllegalArgumentException i) {
                throw new IllegalArgumentException("url parameter error '" + baseTokens[2] + "' is a unknown parameter in the url " + url);
            }
        }
    }

    private static void setDefaultHostAddressType(UrlParser urlParser) {
        if (urlParser.haMode == HaMode.AURORA) {
            for (HostAddress hostAddress : urlParser.addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : urlParser.addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
    }

    public void parseUrl(String url) throws SQLException {
        if (UrlParser.acceptsUrl(url)) {
            UrlParser.parseInternal(this, url, new Properties());
        }
    }

    public String getUsername() {
        return this.options.user;
    }

    protected void setUsername(String username) {
        this.options.user = username;
    }

    public String getPassword() {
        return this.options.password;
    }

    protected void setPassword(String password) {
        this.options.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    protected void setDatabase(String database) {
        this.database = database;
    }

    public List<HostAddress> getHostAddresses() {
        return this.addresses;
    }

    public void setHostAddresses(List<HostAddress> addresses) {
        this.addresses = addresses;
    }

    public Options getOptions() {
        return this.options;
    }

    protected void setProperties(String urlParameters) {
        DefaultOptions.parse(this.haMode, urlParameters, this.options);
    }

    public String toString() {
        return this.initialUrl;
    }

    public String getInitialUrl() {
        return this.initialUrl;
    }

    public HaMode getHaMode() {
        return this.haMode;
    }

    public boolean equals(Object parser) {
        if (this == parser) {
            return true;
        }
        if (!(parser instanceof UrlParser)) {
            return false;
        }
        UrlParser urlParser = (UrlParser)parser;
        if (this.initialUrl != null ? !this.initialUrl.equals(urlParser.getInitialUrl()) : urlParser.getInitialUrl() != null) {
            return false;
        }
        if (this.getUsername() != null ? !this.getUsername().equals(urlParser.getUsername()) : urlParser.getUsername() != null) {
            return false;
        }
        return this.getPassword() != null ? this.getPassword().equals(urlParser.getPassword()) : urlParser.getPassword() == null;
    }

    private boolean loadMultiMasterValue() {
        if (this.haMode == HaMode.SEQUENTIAL || this.haMode == HaMode.REPLICATION || this.haMode == HaMode.FAILOVER) {
            boolean firstMaster = false;
            for (HostAddress host : this.addresses) {
                if (host.type != "master") continue;
                if (firstMaster) {
                    return true;
                }
                firstMaster = true;
            }
        }
        return false;
    }

    public boolean isMultiMaster() {
        return this.multiMaster;
    }
}

