/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.AdapterType;
import org.nuxeo.ecm.webengine.model.LinkDescriptor;
import org.nuxeo.ecm.webengine.model.Messages;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.AbstractWebContext;
import org.nuxeo.ecm.webengine.model.impl.DefaultTypeLoader;
import org.nuxeo.ecm.webengine.model.impl.DirectoryStack;
import org.nuxeo.ecm.webengine.model.impl.LinkRegistry;
import org.nuxeo.ecm.webengine.model.impl.MediaTypeRef;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.TypeRegistry;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;

public class ModuleImpl
implements Module {
    private static final Log log = LogFactory.getLog(ModuleImpl.class);
    protected final WebEngine engine;
    protected final Object typeLock = new Object();
    protected volatile TypeRegistry typeReg;
    protected final ModuleConfiguration configuration;
    protected final ServerInjectableProviderContext sic;
    protected final ModuleImpl superModule;
    protected LinkRegistry linkReg;
    protected final String skinPathPrefix;
    @Deprecated
    protected ResourceType rootType;
    protected Messages messages;
    protected DirectoryStack dirStack;
    protected ConcurrentMap<String, ScriptFile> fileCache;

    public ModuleImpl(WebEngine engine, ModuleImpl superModule, ModuleConfiguration config, ServerInjectableProviderContext sic) {
        this.engine = engine;
        this.superModule = superModule;
        this.sic = sic;
        this.configuration = config;
        this.skinPathPrefix = engine.getSkinPathPrefix() + '/' + config.name;
        this.fileCache = new ConcurrentHashMap<String, ScriptFile>();
        this.loadConfiguration();
        this.reloadMessages();
        this.loadDirectoryStack();
    }

    public boolean isHeadless() {
        return this.configuration.isHeadless;
    }

    public Set<String> getNatures() {
        return this.configuration.natures;
    }

    public boolean hasNature(String natureId) {
        return this.configuration.natures != null && this.configuration.natures.contains(natureId);
    }

    @Override
    public WebEngine getEngine() {
        return this.engine;
    }

    @Override
    public String getName() {
        return this.configuration.name;
    }

    @Override
    public ModuleImpl getSuperModule() {
        return this.superModule;
    }

    public ModuleConfiguration getModuleConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public ResourceType getRootType() {
        this.getTypeRegistry();
        if (this.rootType == null) {
            throw new IllegalStateException("You use new web module declaration - should not call this compat. method");
        }
        return this.rootType;
    }

    @Override
    @Deprecated
    public Resource getRootObject(WebContext ctx) {
        ((AbstractWebContext)ctx).setModule(this);
        Resource obj = ctx.newObject(this.getRootType(), new Object[0]);
        obj.setRoot(true);
        return obj;
    }

    @Override
    public String getSkinPathPrefix() {
        return this.skinPathPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeRegistry getTypeRegistry() {
        if (this.typeReg == null) {
            Object object = this.typeLock;
            synchronized (object) {
                if (this.typeReg == null) {
                    this.typeReg = this.createTypeRegistry();
                    if (this.configuration.rootType != null) {
                        this.rootType = this.typeReg.getType(this.configuration.rootType);
                    }
                }
            }
        }
        return this.typeReg;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.engine.loadClass(className);
    }

    @Override
    public ResourceType getType(String typeName) {
        ResourceType type = this.getTypeRegistry().getType(typeName);
        if (type == null) {
            throw new WebResourceNotFoundException("Type not found: " + typeName);
        }
        return type;
    }

    @Override
    public ResourceType[] getTypes() {
        return this.getTypeRegistry().getTypes();
    }

    @Override
    public AdapterType[] getAdapters() {
        return this.getTypeRegistry().getAdapters();
    }

    @Override
    public AdapterType getAdapter(Resource ctx, String name) {
        AdapterType type = this.getTypeRegistry().getAdapter(ctx, name);
        if (type == null) {
            throw new WebResourceNotFoundException("Service " + name + " not found for object: " + ctx.getPath() + " of type " + ctx.getType().getName());
        }
        return type;
    }

    @Override
    public List<String> getAdapterNames(Resource ctx) {
        return this.getTypeRegistry().getAdapterNames(ctx);
    }

    @Override
    public List<AdapterType> getAdapters(Resource ctx) {
        return this.getTypeRegistry().getAdapters(ctx);
    }

    @Override
    public List<String> getEnabledAdapterNames(Resource ctx) {
        return this.getTypeRegistry().getEnabledAdapterNames(ctx);
    }

    @Override
    public List<AdapterType> getEnabledAdapters(Resource ctx) {
        return this.getTypeRegistry().getEnabledAdapters(ctx);
    }

    @Override
    public String getMediaTypeId(MediaType mt) {
        MediaTypeRef[] refs;
        if (this.configuration.mediatTypeRefs == null) {
            return null;
        }
        for (MediaTypeRef ref : refs = this.configuration.mediatTypeRefs) {
            String id = ref.match(mt);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    @Override
    public List<ResourceBinding> getResourceBindings() {
        return this.configuration.resources;
    }

    @Override
    public boolean isDerivedFrom(String moduleName) {
        if (this.configuration.name.equals(moduleName)) {
            return true;
        }
        if (this.superModule != null) {
            return this.superModule.isDerivedFrom(moduleName);
        }
        return false;
    }

    public void loadConfiguration() {
        this.linkReg = new LinkRegistry();
        if (this.configuration.links != null) {
            for (LinkDescriptor link : this.configuration.links) {
                this.linkReg.registerLink(link);
            }
        }
        this.configuration.links = null;
    }

    @Override
    public List<LinkDescriptor> getLinks(String category) {
        return this.linkReg.getLinks(category);
    }

    @Override
    public List<LinkDescriptor> getActiveLinks(Resource context, String category) {
        return this.linkReg.getActiveLinks(context, category);
    }

    public LinkRegistry getLinkRegistry() {
        return this.linkReg;
    }

    @Override
    public String getTemplateFileExt() {
        return this.configuration.templateFileExt;
    }

    public void flushSkinCache() {
        log.info((Object)("Flushing skin cache for module: " + this.getName()));
        this.fileCache = new ConcurrentHashMap<String, ScriptFile>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTypeCache() {
        log.info((Object)("Flushing type cache for module: " + this.getName()));
        Object object = this.typeLock;
        synchronized (object) {
            new DefaultTypeLoader(this, this.typeReg, this.configuration.directory).flushCache();
            this.typeReg = null;
        }
    }

    @Deprecated
    public void flushRootResourcesCache() {
        if (this.configuration.resources != null) {
            for (ResourceBinding rb : this.configuration.resources) {
                try {
                    this.engine.removeResourceBinding(rb);
                    rb.reload(this.engine);
                    this.engine.addResourceBinding(rb);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Failed to reload resource", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void flushCache() {
        this.reloadMessages();
        this.flushSkinCache();
        this.flushTypeCache();
    }

    public static File getSkinDir(File moduleDir) {
        return new File(moduleDir, "skin");
    }

    protected void loadDirectoryStack() {
        this.dirStack = new DirectoryStack();
        try {
            DirectoryStack ds;
            File skin = ModuleImpl.getSkinDir(this.configuration.directory);
            if (!this.configuration.allowHostOverride && skin.isDirectory()) {
                this.dirStack.addDirectory(skin);
            }
            for (File fragmentDir : this.configuration.fragmentDirectories) {
                File fragmentSkin = ModuleImpl.getSkinDir(fragmentDir);
                if (!fragmentSkin.isDirectory()) continue;
                this.dirStack.addDirectory(fragmentSkin);
            }
            if (this.configuration.allowHostOverride && skin.isDirectory()) {
                this.dirStack.addDirectory(skin);
            }
            if (this.superModule != null && (ds = this.superModule.dirStack) != null) {
                this.dirStack.getDirectories().addAll(ds.getDirectories());
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to load directories stack", (Throwable)e);
        }
    }

    @Override
    public ScriptFile getFile(String path) {
        int len = path.length();
        if (len == 0) {
            return null;
        }
        char c = path.charAt(0);
        if (c == '.') {
            path = new Path(path).makeAbsolute().toString();
        } else if (c != '/') {
            path = new StringBuilder(len + 1).append("/").append(path).toString();
        }
        try {
            return this.findFile(new Path(path).makeAbsolute().toString());
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected ScriptFile findFile(String path) throws IOException {
        File f;
        ScriptFile file = (ScriptFile)this.fileCache.get(path);
        if (file == null && (f = this.dirStack.getFile(path)) != null) {
            file = new ScriptFile(f);
            this.fileCache.put(path, file);
        }
        return file;
    }

    @Override
    public ScriptFile getSkinResource(String path) throws IOException {
        File file = this.dirStack.getFile(path);
        if (file != null) {
            return new ScriptFile(file);
        }
        return null;
    }

    public TypeRegistry createTypeRegistry() {
        TypeRegistry typeReg = null;
        typeReg = this.superModule != null ? new TypeRegistry(this.superModule.getTypeRegistry(), this.engine, this) : new TypeRegistry(this.engine, this);
        if (this.configuration.directory.isDirectory()) {
            DefaultTypeLoader loader = new DefaultTypeLoader(this, typeReg, this.configuration.directory);
            loader.load();
        }
        return typeReg;
    }

    @Override
    public File getRoot() {
        return this.configuration.directory;
    }

    public void reloadMessages() {
        this.messages = new Messages(this.superModule != null ? this.superModule.getMessages() : null, this);
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMessages(String language) {
        log.info((Object)("Loading i18n files for module " + this.configuration.name));
        File file = new File(this.configuration.directory, "/i18n/messages_" + language + ".properties");
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Properties p = new Properties();
            p.load(in);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(p);
            return hashMap;
        }
        catch (IOException e) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ee) {
                    log.error((Object)ee);
                }
            }
        }
    }

    public String toString() {
        return this.getName();
    }
}

