/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadHelper;

@Provider
@Produces(value={"*/*", "text/plain"})
public class FileWriter
implements MessageBodyWriter<File> {
    private static final Log log = LogFactory.getLog(FileWriter.class);

    public void writeTo(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (FileInputStream in = new FileInputStream(t);){
            IOUtils.copy((InputStream)in, (OutputStream)entityStream);
            entityStream.flush();
        }
        catch (IOException e) {
            if (DownloadHelper.isClientAbortError((Throwable)e)) {
                DownloadHelper.logClientAbort((Exception)e);
            }
            throw new NuxeoException("Failed to render resource", (Throwable)e);
        }
    }

    public long getSize(File arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        long n = arg0.length();
        return n <= 0L ? -1L : n;
    }

    public boolean isWriteable(Class<?> arg0, Type type, Annotation[] arg2, MediaType arg3) {
        return File.class.isAssignableFrom(arg0);
    }
}

