/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@Path(value="/api/v1{repo : (/repo/[^/]+?)?}")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="APIRoot")
public class APIRoot
extends ModuleRoot {
    @Path(value="/")
    public Object doGetRepository(@PathParam(value="repo") String repositoryParam) throws DocumentNotFoundException {
        if (StringUtils.isNotBlank((String)repositoryParam)) {
            String repoName = repositoryParam.substring("repo/".length() + 1);
            try {
                this.ctx.setRepositoryName(repoName);
            }
            catch (IllegalArgumentException e) {
                throw new WebResourceNotFoundException(e.getMessage());
            }
        }
        return this.newObject("repo", new Object[0]);
    }

    @Path(value="/user")
    public Object doGetUser() {
        return this.newObject("users", new Object[0]);
    }

    @Path(value="/group")
    public Object doGetGroup() {
        return this.newObject("groups", new Object[0]);
    }

    @Path(value="/automation")
    public Object getAutomationEndPoint() {
        return this.newObject("automation", new Object[0]);
    }

    @Path(value="/directory")
    public Object doGetDirectory() {
        return this.newObject("directory", new Object[0]);
    }

    @Path(value="/doc")
    public Object doGetDocumentation() {
        return this.newObject("doc", new Object[0]);
    }

    @Path(value="/query")
    public Object doQuery() {
        return this.newObject("query", new Object[0]);
    }

    @Path(value="/config")
    public Object doGetConfig() {
        return this.newObject("config", new Object[0]);
    }

    @Path(value="/conversion")
    public Object doGetConversion() {
        return this.newObject("conversions", new Object[0]);
    }

    @Path(value="/ext/{otherPath}")
    public Object route(@PathParam(value="otherPath") String otherPath) {
        return this.newObject(otherPath, new Object[0]);
    }
}

