/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@WebObject(type="upload")
public class BatchUploadObject
extends AbstractResource<ResourceTypeImpl> {
    protected static final Log log = LogFactory.getLog(BatchUploadObject.class);
    protected static final String REQUEST_BATCH_ID = "batchId";
    protected static final String REQUEST_FILE_IDX = "fileIdx";
    protected static final String OPERATION_ID = "operationId";
    public static final String UPLOAD_TYPE_NORMAL = "normal";
    public static final String UPLOAD_TYPE_CHUNKED = "chunked";
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;

    @POST
    public Response initBatch() throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String batchId = bm.initBatch();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(REQUEST_BATCH_ID, batchId);
        return this.buildResponse((Response.StatusType)Response.Status.CREATED, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{batchId}/{fileIdx}")
    public Response upload(@Context HttpServletRequest request, @PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) throws IOException {
        TransactionHelper.commitOrRollbackTransaction();
        try {
            Response response = this.uploadNoTransaction(request, batchId, fileIdx);
            return response;
        }
        finally {
            TransactionHelper.startTransaction();
        }
    }

    protected Response uploadNoTransaction(@Context HttpServletRequest request, @PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) throws IOException {
        BatchFileEntry fileEntry;
        Object blob;
        boolean isMultipart;
        if (!((BatchManager)Framework.getService(BatchManager.class)).hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        if (!NumberUtils.isDigits((String)fileIdx)) {
            return this.buildTextResponse((Response.StatusType)Response.Status.BAD_REQUEST, "fileIdx request path parameter must be a number");
        }
        String contentType = request.getHeader("Content-Type");
        String uploadType = request.getHeader("X-Upload-Type");
        if (!UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
            uploadType = UPLOAD_TYPE_NORMAL;
        }
        String uploadChunkIndexHeader = request.getHeader("X-Upload-Chunk-Index");
        String chunkCountHeader = request.getHeader("X-Upload-Chunk-Count");
        String fileName = request.getHeader("X-File-Name");
        String fileSizeHeader = request.getHeader("X-File-Size");
        String mimeType = request.getHeader("X-File-Type");
        int chunkCount = -1;
        int uploadChunkIndex = -1;
        long fileSize = -1L;
        if (UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
            try {
                chunkCount = Integer.parseInt(chunkCountHeader);
                uploadChunkIndex = Integer.parseInt(uploadChunkIndexHeader);
                fileSize = Long.parseLong(fileSizeHeader);
            }
            catch (NumberFormatException e) {
                throw new IllegalParameterException("X-Upload-Chunk-Index, X-Upload-Chunk-Count and X-File-Size headers must be numbers");
            }
        }
        long uploadedSize = this.getUploadedSize(request);
        boolean bl = isMultipart = contentType != null && contentType.contains("multipart");
        if (isMultipart) {
            FormData formData = new FormData(request);
            blob = formData.getFirstBlob();
            if (blob == null) {
                throw new NuxeoException("Cannot upload in multipart with no blobs");
            }
            if (!UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
                fileName = blob.getFilename();
            }
            if (StringUtils.isBlank((CharSequence)mimeType)) {
                mimeType = blob.getMimeType();
            }
            uploadedSize = blob.getLength();
            try (InputStream is2 = blob.getStream();){
                this.addStream(uploadType, batchId, fileIdx, is2, fileName, mimeType, uploadedSize, chunkCount, uploadChunkIndex, fileSize);
            }
        }
        if (fileName != null) {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        ServletInputStream is = request.getInputStream();
        blob = null;
        try {
            this.addStream(uploadType, batchId, fileIdx, (InputStream)is, fileName, mimeType, uploadedSize, chunkCount, uploadChunkIndex, fileSize);
        }
        catch (Throwable is2) {
            blob = is2;
            throw is2;
        }
        finally {
            if (is != null) {
                if (blob != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable is2) {
                        ((Throwable)blob).addSuppressed(is2);
                    }
                } else {
                    is.close();
                }
            }
        }
        Object status = Response.Status.CREATED;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("uploaded", "true");
        result.put(REQUEST_BATCH_ID, batchId);
        result.put(REQUEST_FILE_IDX, fileIdx);
        result.put("uploadType", uploadType);
        result.put("uploadedSize", String.valueOf(uploadedSize));
        if (UPLOAD_TYPE_CHUNKED.equals(uploadType) && (fileEntry = ((BatchManager)Framework.getService(BatchManager.class)).getFileEntry(batchId, fileIdx)) != null) {
            result.put("uploadedChunkIds", fileEntry.getOrderedChunkIndexes());
            result.put("chunkCount", fileEntry.getChunkCount());
            if (!fileEntry.isChunksCompleted()) {
                status = new ResumeIncompleteStatusType();
            }
        }
        return this.buildResponse((Response.StatusType)status, result, isMultipart);
    }

    protected long getUploadedSize(HttpServletRequest request) {
        String contentLength = request.getHeader("Content-Length");
        if (contentLength == null) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    protected void addStream(String uploadType, String batchId, String fileIdx, InputStream is, String fileName, String mimeType, long uploadedSize, int chunkCount, int uploadChunkIndex, long fileSize) throws IOException {
        String uploadedSizeDisplay;
        String string = uploadedSizeDisplay = uploadedSize > -1L ? uploadedSize + "b" : "unknown size";
        if (UPLOAD_TYPE_CHUNKED.equals(uploadType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Uploading chunk [index=%d / total=%d] (%s) for file %s", uploadChunkIndex, chunkCount, uploadedSizeDisplay, fileName));
            }
            ((BatchManager)Framework.getService(BatchManager.class)).addStream(batchId, fileIdx, is, chunkCount, uploadChunkIndex, fileName, mimeType, fileSize);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Uploading file %s (%s)", fileName, uploadedSizeDisplay));
            }
            ((BatchManager)Framework.getService(BatchManager.class)).addStream(batchId, fileIdx, is, fileName, mimeType);
        }
    }

    @GET
    @Path(value="{batchId}")
    public Response getBatchInfo(@PathParam(value="batchId") String batchId) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        List fileEntries = bm.getFileEntries(batchId);
        if (CollectionUtils.isEmpty((Collection)fileEntries)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NO_CONTENT);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (BatchFileEntry fileEntry : fileEntries) {
            result.add(this.getFileInfo(fileEntry));
        }
        return this.buildResponse((Response.StatusType)Response.Status.OK, result);
    }

    @GET
    @Path(value="{batchId}/{fileIdx}")
    public Response getFileInfo(@PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        BatchFileEntry fileEntry = bm.getFileEntry(batchId, fileIdx);
        if (fileEntry == null) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        Object status = Response.Status.OK;
        if (fileEntry.isChunked() && !fileEntry.isChunksCompleted()) {
            status = new ResumeIncompleteStatusType();
        }
        Map<String, Object> result = this.getFileInfo(fileEntry);
        return this.buildResponse((Response.StatusType)status, result);
    }

    @DELETE
    @Path(value="{batchId}")
    public Response cancel(@PathParam(value="batchId") String batchId) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        bm.clean(batchId);
        return this.buildEmptyResponse((Response.StatusType)Response.Status.NO_CONTENT);
    }

    @DELETE
    @Path(value="{batchId}/{fileIdx}")
    public Response removeFile(@PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        if (!bm.removeFileEntry(batchId, fileIdx)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        return this.buildEmptyResponse((Response.StatusType)Response.Status.NO_CONTENT);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{batchId}/execute/{operationId}")
    public Object execute(@PathParam(value="batchId") String batchId, @PathParam(value="operationId") String operationId, ExecutionRequest xreq) {
        return this.executeBatch(batchId, null, operationId, this.request, xreq);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{batchId}/{fileIdx}/execute/{operationId}")
    public Object execute(@PathParam(value="batchId") String batchId, @PathParam(value="fileIdx") String fileIdx, @PathParam(value="operationId") String operationId, ExecutionRequest xreq) {
        return this.executeBatch(batchId, fileIdx, operationId, this.request, xreq);
    }

    protected Object executeBatch(String batchId, String fileIdx, String operationId, HttpServletRequest request, ExecutionRequest xreq) {
        if (!((BatchManager)Framework.getService(BatchManager.class)).hasBatch(batchId)) {
            return this.buildEmptyResponse((Response.StatusType)Response.Status.NOT_FOUND);
        }
        if (!Boolean.parseBoolean(RequestContext.getActiveContext((ServletRequest)request).getRequest().getHeader("X-Batch-No-Drop"))) {
            RequestContext.getActiveContext((ServletRequest)request).addRequestCleanupHandler(req -> {
                BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
                bm.clean(batchId);
            });
        }
        try {
            CoreSession session = this.ctx.getCoreSession();
            OperationContext ctx = xreq.createContext(request, this.response, session);
            Map params = xreq.getParams();
            BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
            Object result = StringUtils.isBlank((CharSequence)fileIdx) ? bm.execute(batchId, operationId, session, (Map)ctx, params) : bm.execute(batchId, fileIdx, operationId, session, (Map)ctx, params);
            return ResponseHelper.getResponse((Object)result, (HttpServletRequest)request);
        }
        catch (IOException | MessagingException e) {
            log.error((Object)"Error while executing automation batch ", e);
            throw new NuxeoException(e);
        }
    }

    protected Response buildResponse(Response.StatusType status, Object object) throws IOException {
        return this.buildResponse(status, object, false);
    }

    protected Response buildResponse(Response.StatusType status, Object object, boolean html) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String result = mapper.writeValueAsString(object);
        if (html) {
            return this.buildHTMLResponse(status, result);
        }
        return this.buildJSONResponse(status, result);
    }

    protected Response buildJSONResponse(Response.StatusType status, String message) throws UnsupportedEncodingException {
        return this.buildResponse(status, "application/json", message);
    }

    protected Response buildHTMLResponse(Response.StatusType status, String message) throws UnsupportedEncodingException {
        message = "<html>" + message + "</html>";
        return this.buildResponse(status, "text/html", message);
    }

    protected Response buildTextResponse(Response.StatusType status, String message) throws UnsupportedEncodingException {
        return this.buildResponse(status, "text/plain", message);
    }

    protected Response buildEmptyResponse(Response.StatusType status) {
        return Response.status((Response.StatusType)status).build();
    }

    protected Response buildResponse(Response.StatusType status, String type, String message) throws UnsupportedEncodingException {
        return Response.status((Response.StatusType)status).header("Content-Length", (Object)message.getBytes("UTF-8").length).type(type + "; charset=UTF-8").entity((Object)message).build();
    }

    protected Map<String, Object> getFileInfo(BatchFileEntry fileEntry) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        boolean chunked = fileEntry.isChunked();
        String uploadType = chunked ? UPLOAD_TYPE_CHUNKED : UPLOAD_TYPE_NORMAL;
        info.put("name", fileEntry.getFileName());
        info.put("size", fileEntry.getFileSize());
        info.put("uploadType", uploadType);
        if (chunked) {
            info.put("uploadedChunkIds", fileEntry.getOrderedChunkIndexes());
            info.put("chunkCount", fileEntry.getChunkCount());
        }
        return info;
    }

    public final class ResumeIncompleteStatusType
    implements Response.StatusType {
        public int getStatusCode() {
            return 308;
        }

        public String getReasonPhrase() {
            return "Resume Incomplete";
        }

        public Response.Status.Family getFamily() {
            return Response.Status.Family.REDIRECTION;
        }
    }
}

