/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import java.util.List;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.AbstractUMRootObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="users")
@Produces(value={"application/json", "application/json+nxentity"})
public class UserRootObject
extends AbstractUMRootObject<NuxeoPrincipal> {
    public static final String PAGE_PROVIDER_NAME = "nuxeo_principals_listing";

    @Override
    protected NuxeoPrincipal getArtifact(String id) {
        return this.um.getPrincipal(id);
    }

    @Override
    protected String getArtifactType() {
        return "user";
    }

    @Override
    protected void checkPrecondition(NuxeoPrincipal principal) {
        this.checkCurrentUserCanCreateArtifact(principal);
        this.checkPrincipalDoesNotAlreadyExists(principal, this.um);
        this.checkPrincipalHasAName(principal);
    }

    @Override
    protected NuxeoPrincipal createArtifact(NuxeoPrincipal principal) {
        this.um.createUser(principal.getModel());
        return this.um.getPrincipal(principal.getName());
    }

    private void checkPrincipalDoesNotAlreadyExists(NuxeoPrincipal principal, UserManager um) {
        NuxeoPrincipal user = um.getPrincipal(principal.getName());
        if (user != null) {
            throw new NuxeoException("User already exists", 409);
        }
    }

    private void checkPrincipalHasAName(NuxeoPrincipal principal) {
        if (principal.getName() == null) {
            throw new NuxeoException("User MUST have a name", 400);
        }
    }

    @Override
    boolean isAPowerUserEditableArtifact(NuxeoPrincipal artifact) {
        return UserRootObject.isAPowerUserEditableUser(artifact);
    }

    static boolean isAPowerUserEditableUser(NuxeoPrincipal user) {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        List adminGroups = um.getAdministratorsGroups();
        for (String adminGroup : adminGroups) {
            if (!user.getAllGroups().contains(adminGroup)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected PageProviderDefinition getPageProviderDefinition() {
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        return ppService.getPageProviderDefinition(PAGE_PROVIDER_NAME);
    }

    @Override
    protected Object[] getParams() {
        return new Object[]{this.query};
    }
}

