/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodesStatsRequest
extends BaseNodesRequest<NodesStatsRequest> {
    private CommonStatsFlags indices = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
    private boolean os;
    private boolean process;
    private boolean jvm;
    private boolean threadPool;
    private boolean fs;
    private boolean transport;
    private boolean http;
    private boolean breaker;
    private boolean script;
    private boolean discovery;
    private boolean ingest;

    public NodesStatsRequest() {
    }

    public NodesStatsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesStatsRequest all() {
        this.indices.all();
        this.os = true;
        this.process = true;
        this.jvm = true;
        this.threadPool = true;
        this.fs = true;
        this.transport = true;
        this.http = true;
        this.breaker = true;
        this.script = true;
        this.discovery = true;
        this.ingest = true;
        return this;
    }

    public NodesStatsRequest clear() {
        this.indices.clear();
        this.os = false;
        this.process = false;
        this.jvm = false;
        this.threadPool = false;
        this.fs = false;
        this.transport = false;
        this.http = false;
        this.breaker = false;
        this.script = false;
        this.discovery = false;
        this.ingest = false;
        return this;
    }

    public CommonStatsFlags indices() {
        return this.indices;
    }

    public NodesStatsRequest indices(CommonStatsFlags indices) {
        this.indices = indices;
        return this;
    }

    public NodesStatsRequest indices(boolean indices) {
        if (indices) {
            this.indices.all();
        } else {
            this.indices.clear();
        }
        return this;
    }

    public boolean os() {
        return this.os;
    }

    public NodesStatsRequest os(boolean os) {
        this.os = os;
        return this;
    }

    public boolean process() {
        return this.process;
    }

    public NodesStatsRequest process(boolean process) {
        this.process = process;
        return this;
    }

    public boolean jvm() {
        return this.jvm;
    }

    public NodesStatsRequest jvm(boolean jvm) {
        this.jvm = jvm;
        return this;
    }

    public boolean threadPool() {
        return this.threadPool;
    }

    public NodesStatsRequest threadPool(boolean threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public boolean fs() {
        return this.fs;
    }

    public NodesStatsRequest fs(boolean fs) {
        this.fs = fs;
        return this;
    }

    public boolean transport() {
        return this.transport;
    }

    public NodesStatsRequest transport(boolean transport) {
        this.transport = transport;
        return this;
    }

    public boolean http() {
        return this.http;
    }

    public NodesStatsRequest http(boolean http) {
        this.http = http;
        return this;
    }

    public boolean breaker() {
        return this.breaker;
    }

    public NodesStatsRequest breaker(boolean breaker) {
        this.breaker = breaker;
        return this;
    }

    public boolean script() {
        return this.script;
    }

    public NodesStatsRequest script(boolean script) {
        this.script = script;
        return this;
    }

    public boolean discovery() {
        return this.discovery;
    }

    public NodesStatsRequest discovery(boolean discovery) {
        this.discovery = discovery;
        return this;
    }

    public boolean ingest() {
        return this.ingest;
    }

    public NodesStatsRequest ingest(boolean ingest) {
        this.ingest = ingest;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = new CommonStatsFlags(in);
        this.os = in.readBoolean();
        this.process = in.readBoolean();
        this.jvm = in.readBoolean();
        this.threadPool = in.readBoolean();
        this.fs = in.readBoolean();
        this.transport = in.readBoolean();
        this.http = in.readBoolean();
        this.breaker = in.readBoolean();
        this.script = in.readBoolean();
        this.discovery = in.readBoolean();
        this.ingest = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.indices.writeTo(out);
        out.writeBoolean(this.os);
        out.writeBoolean(this.process);
        out.writeBoolean(this.jvm);
        out.writeBoolean(this.threadPool);
        out.writeBoolean(this.fs);
        out.writeBoolean(this.transport);
        out.writeBoolean(this.http);
        out.writeBoolean(this.breaker);
        out.writeBoolean(this.script);
        out.writeBoolean(this.discovery);
        out.writeBoolean(this.ingest);
    }
}

