/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.compound;

import org.apache.lucene.analysis.CharArraySet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public abstract class AbstractCompoundWordTokenFilterFactory
extends AbstractTokenFilterFactory {
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    protected final CharArraySet wordList;

    public AbstractCompoundWordTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minWordSize = settings.getAsInt("min_word_size", 5);
        this.minSubwordSize = settings.getAsInt("min_subword_size", 2);
        this.maxSubwordSize = settings.getAsInt("max_subword_size", 15);
        this.onlyLongestMatch = settings.getAsBoolean("only_longest_match", false);
        this.wordList = Analysis.getWordSet(env, settings, "word_list");
        if (this.wordList == null) {
            throw new IllegalArgumentException("word_list must be provided for [" + name + "], either as a path to a file, or directly");
        }
    }
}

