/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.AbstractKeyValueStoreProvider;
import org.nuxeo.runtime.kv.KeyValueStoreDescriptor;

public class RedisKeyValueStore
extends AbstractKeyValueStoreProvider {
    private static final Log log = LogFactory.getLog(RedisKeyValueStore.class);
    public static final String NAMESPACE_PROP = "namespace";
    protected static final Long ONE = 1L;
    protected String name;
    protected String namespace;
    protected byte[] compareAndSetSHA;
    protected byte[] compareAndDelSHA;
    protected byte[] compareNullAndSetSHA;

    protected static byte[] getBytes(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    public void initialize(KeyValueStoreDescriptor descriptor) {
        String[] stringArray;
        log.debug((Object)"Initializing");
        this.name = descriptor.name;
        Map properties = descriptor.getProperties();
        String name = (String)properties.get(NAMESPACE_PROP);
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        if (name == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        this.namespace = redisAdmin.namespace(stringArray);
        try {
            this.compareAndSetSHA = RedisKeyValueStore.getBytes(redisAdmin.load("org.nuxeo.ecm.core.redis", "compare-and-set"));
            this.compareAndDelSHA = RedisKeyValueStore.getBytes(redisAdmin.load("org.nuxeo.ecm.core.redis", "compare-and-del"));
            this.compareNullAndSetSHA = RedisKeyValueStore.getBytes(redisAdmin.load("org.nuxeo.ecm.core.redis", "compare-null-and-set"));
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot load Redis script", (Throwable)e);
        }
    }

    public Stream<String> keyStream() {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        int namespaceLength = this.namespace.length();
        Set keys = (Set)redisExecutor.execute(jedis -> jedis.keys(this.namespace + "*"));
        return keys.stream().map(key -> key.substring(namespaceLength));
    }

    public void close() {
        log.debug((Object)"Closed");
    }

    public void clear() {
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        redisAdmin.clear(this.namespace + "*");
    }

    public void put(String key, byte[] value, long ttl) {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        redisExecutor.execute(jedis -> {
            byte[] keyb = RedisKeyValueStore.getBytes(this.namespace + key);
            if (value == null) {
                jedis.del(keyb);
            } else if (ttl == 0L) {
                jedis.set(keyb, value);
            } else {
                jedis.setex(keyb, (int)ttl, value);
            }
            return null;
        });
    }

    public byte[] get(String key) {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        return (byte[])redisExecutor.execute(jedis -> jedis.get(RedisKeyValueStore.getBytes(this.namespace + key)));
    }

    public Map<String, byte[]> get(Collection<String> keys) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(keys.size());
        List<byte[]> values = this.getValuesForKeys(keys);
        int i = 0;
        for (String key : keys) {
            byte[] value;
            if ((value = values.get(i++)) == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public Map<String, String> getStrings(Collection<String> keys) {
        HashMap<String, String> map = new HashMap<String, String>(keys.size());
        List<byte[]> values = this.getValuesForKeys(keys);
        int i = 0;
        for (String key : keys) {
            byte[] value;
            if ((value = values.get(i++)) == null) continue;
            try {
                map.put(key, RedisKeyValueStore.bytesToString((byte[])value));
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException("Value is not a String for key: " + key);
            }
        }
        return map;
    }

    protected List<byte[]> getValuesForKeys(Collection<String> keys) {
        byte[][] byteKeys = new byte[keys.size()][];
        int i = 0;
        for (String key : keys) {
            byteKeys[i++] = RedisKeyValueStore.getBytes(this.namespace + key);
        }
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        return (List)redisExecutor.execute(jedis -> jedis.mget(byteKeys));
    }

    public boolean setTTL(String key, long ttl) {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        Long result = (Long)redisExecutor.execute(jedis -> {
            byte[] keyb = RedisKeyValueStore.getBytes(this.namespace + key);
            if (ttl == 0L) {
                return jedis.persist(keyb);
            }
            return jedis.expire(keyb, (int)ttl);
        });
        return ONE.equals(result);
    }

    public boolean compareAndSet(String key, byte[] expected, byte[] value, long ttl) {
        List<Object> args;
        byte[] sha;
        if (expected == null && value == null) {
            return this.get(key) == null;
        }
        List<byte[]> keys = Collections.singletonList(RedisKeyValueStore.getBytes(this.namespace + key));
        if (expected == null) {
            sha = this.compareNullAndSetSHA;
            args = Collections.singletonList(value);
        } else if (value == null) {
            sha = this.compareAndDelSHA;
            args = Collections.singletonList(expected);
        } else {
            sha = this.compareAndSetSHA;
            args = Arrays.asList(expected, value);
        }
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        Object result = redisExecutor.evalsha(sha, keys, args);
        boolean set = ONE.equals(result);
        if (set && value != null && ttl != 0L) {
            this.setTTL(key, ttl);
        }
        return set;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.name + ")";
    }
}

