/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.exceptions.JedisException;

public class RedisUIDSequencer
extends AbstractUIDSequencer {
    protected static final Log log = LogFactory.getLog(RedisUIDSequencer.class);
    protected String namespace;

    public void init() {
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        this.namespace = redisAdmin.namespace(new String[]{"counters"});
    }

    public void dispose() {
    }

    public void initSequence(String key, long id) {
        RedisExecutor executor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        try {
            executor.execute(jedis -> jedis.set(this.namespace + key, String.valueOf(id)));
        }
        catch (JedisException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public long getNextLong(String key) {
        RedisExecutor executor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        try {
            return (Long)executor.execute(jedis -> jedis.incr(this.namespace + key));
        }
        catch (JedisException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

