/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.contribs.RedisBlockingQueue;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.SafeEncoder;

public class RedisWorkQueuing
implements WorkQueuing {
    private static final Log log = LogFactory.getLog(RedisWorkQueuing.class);
    protected static final String UTF_8 = "UTF-8";
    protected static final String KEY_DATA = "data";
    protected static final String KEY_STATE = "state";
    protected static final String KEY_SUSPENDED_PREFIX = "prev";
    protected static final byte[] KEY_SUSPENDED = "prev".getBytes();
    protected static final String KEY_QUEUE_PREFIX = "queue";
    protected static final byte[] KEY_QUEUE = "queue".getBytes();
    protected static final String KEY_SCHEDULED_PREFIX = "sched";
    protected static final byte[] KEY_SCHEDULED = "sched".getBytes();
    protected static final String KEY_RUNNING_PREFIX = "run";
    protected static final byte[] KEY_RUNNING = "run".getBytes();
    protected static final String KEY_COMPLETED_PREFIX = "done";
    protected static final byte[] KEY_COMPLETED = "done".getBytes();
    protected static final String KEY_CANCELED_PREFIX = "cancel";
    protected static final byte[] KEY_CANCELED = "cancel".getBytes();
    protected static final String KEY_COUNT_PREFIX = "count";
    protected static final byte STATE_SCHEDULED_B = 81;
    protected static final byte STATE_RUNNING_B = 82;
    protected static final byte STATE_RUNNING_C = 67;
    protected static final byte[] STATE_SCHEDULED = new byte[]{81};
    protected static final byte[] STATE_RUNNING = new byte[]{82};
    protected static final byte[] STATE_UNKNOWN = new byte[0];
    protected WorkQueuing.Listener listener;
    protected final Map<String, NuxeoBlockingQueue> allQueued = new HashMap<String, NuxeoBlockingQueue>();
    protected String redisNamespace;
    protected byte[] initWorkQueueSha;
    protected byte[] metricsWorkQueueSha;
    protected byte[] schedulingWorkSha;
    protected byte[] popWorkSha;
    protected byte[] runningWorkSha;
    protected byte[] cancelledScheduledWorkSha;
    protected byte[] completedWorkSha;
    protected byte[] cancelledRunningWorkSha;

    public RedisWorkQueuing(WorkQueuing.Listener listener) {
        this.listener = listener;
        this.loadConfig();
    }

    void loadConfig() {
        RedisAdmin admin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        this.redisNamespace = admin.namespace(new String[]{"work"});
        try {
            this.initWorkQueueSha = admin.load("org.nuxeo.ecm.core.redis", "init-work-queue").getBytes();
            this.metricsWorkQueueSha = admin.load("org.nuxeo.ecm.core.redis", "metrics-work-queue").getBytes();
            this.schedulingWorkSha = admin.load("org.nuxeo.ecm.core.redis", "scheduling-work").getBytes();
            this.popWorkSha = admin.load("org.nuxeo.ecm.core.redis", "pop-work").getBytes();
            this.runningWorkSha = admin.load("org.nuxeo.ecm.core.redis", "running-work").getBytes();
            this.cancelledScheduledWorkSha = admin.load("org.nuxeo.ecm.core.redis", "cancelled-scheduled-work").getBytes();
            this.completedWorkSha = admin.load("org.nuxeo.ecm.core.redis", "completed-work").getBytes();
            this.cancelledRunningWorkSha = admin.load("org.nuxeo.ecm.core.redis", "cancelled-running-work").getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load LUA scripts", e);
        }
    }

    public NuxeoBlockingQueue init(WorkQueueDescriptor config) {
        this.evalSha(this.initWorkQueueSha, this.keys(config.id), Collections.emptyList());
        RedisBlockingQueue queue = new RedisBlockingQueue(config.id, this);
        this.allQueued.put(config.id, queue);
        return queue;
    }

    public NuxeoBlockingQueue getQueue(String queueId) {
        return this.allQueued.get(queueId);
    }

    public void workSchedule(String queueId, Work work) {
        this.getQueue(queueId).offer((Runnable)new WorkHolder(work));
    }

    public void workRunning(String queueId, Work work) {
        try {
            this.workSetRunning(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void workCanceled(String queueId, Work work) {
        try {
            this.workSetCancelledScheduled(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void workCompleted(String queueId, Work work) {
        try {
            this.workSetCompleted(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void workReschedule(String queueId, Work work) {
        try {
            this.workSetReschedule(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Work> listWork(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.listScheduled(queueId);
            }
            case RUNNING: {
                return this.listRunning(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf(state));
    }

    public List<String> listWorkIds(String queueId, Work.State state) {
        if (state == null) {
            return this.listNonCompletedIds(queueId);
        }
        switch (state) {
            case SCHEDULED: {
                return this.listScheduledIds(queueId);
            }
            case RUNNING: {
                return this.listRunningIds(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf(state));
    }

    protected List<Work> listScheduled(String queueId) {
        try {
            return this.listWorkList(this.queuedKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Work> listRunning(String queueId) {
        try {
            return this.listWorkSet(this.runningKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listScheduledIds(String queueId) {
        try {
            return this.listWorkIdsList(this.queuedKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listRunningIds(String queueId) {
        try {
            return this.listWorkIdsSet(this.runningKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listNonCompletedIds(String queueId) {
        List<String> list = this.listScheduledIds(queueId);
        list.addAll(this.listRunningIds(queueId));
        return list;
    }

    public long count(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.metrics((String)queueId).scheduled.longValue();
            }
            case RUNNING: {
                return this.metrics((String)queueId).running.longValue();
            }
        }
        throw new IllegalArgumentException(String.valueOf(state));
    }

    public Work find(String workId, Work.State state) {
        if (this.isWorkInState(workId, state)) {
            return this.getWork(this.bytes(workId));
        }
        return null;
    }

    public boolean isWorkInState(String workId, Work.State state) {
        Work.State s = this.getWorkState(workId);
        if (state == null) {
            return s == Work.State.SCHEDULED || s == Work.State.RUNNING;
        }
        return s == state;
    }

    public void removeScheduled(String queueId, String workId) {
        try {
            this.removeScheduledWork(queueId, workId);
        }
        catch (IOException cause) {
            throw new RuntimeException("Cannot remove scheduled work " + workId + " from " + queueId, cause);
        }
    }

    public Work.State getWorkState(String workId) {
        return this.getWorkStateInfo(workId);
    }

    public void setActive(String queueId, boolean value) {
        WorkQueueMetrics metrics = this.getQueue(queueId).setActive(value);
        if (value) {
            this.listener.queueActivated(metrics);
        } else {
            this.listener.queueDeactivated(metrics);
        }
    }

    protected String string(byte[] bytes) {
        try {
            return new String(bytes, UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen, cannot decode string in UTF-8", e);
        }
    }

    protected byte[] bytes(String string) {
        try {
            return string.getBytes(UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen, cannot encode string in UTF-8", e);
        }
    }

    protected byte[] bytes(Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return STATE_SCHEDULED;
            }
            case RUNNING: {
                return STATE_RUNNING;
            }
        }
        return STATE_UNKNOWN;
    }

    protected static String key(String ... names) {
        return String.join((CharSequence)":", names);
    }

    protected byte[] keyBytes(String prefix, String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(prefix, queueId));
    }

    protected byte[] keyBytes(String prefix) {
        return this.bytes(this.redisNamespace.concat(prefix));
    }

    protected byte[] workId(Work work) {
        return this.workId(work.getId());
    }

    protected byte[] workId(String id) {
        return this.bytes(id);
    }

    protected byte[] suspendedKey(String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(KEY_SUSPENDED_PREFIX, queueId));
    }

    protected byte[] queuedKey(String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(KEY_QUEUE_PREFIX, queueId));
    }

    protected byte[] countKey(String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(KEY_COUNT_PREFIX, queueId));
    }

    protected byte[] runningKey(String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(KEY_RUNNING_PREFIX, queueId));
    }

    protected byte[] scheduledKey(String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(KEY_SCHEDULED_PREFIX, queueId));
    }

    protected byte[] completedKey(String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(KEY_COMPLETED_PREFIX, queueId));
    }

    protected byte[] canceledKey(String queueId) {
        return this.keyBytes(RedisWorkQueuing.key(KEY_CANCELED_PREFIX, queueId));
    }

    protected byte[] stateKey() {
        return this.keyBytes(KEY_STATE);
    }

    protected byte[] dataKey() {
        return this.keyBytes(KEY_DATA);
    }

    protected byte[] serializeWork(Work work) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baout);
        out.writeObject(work);
        out.flush();
        out.close();
        return baout.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Work deserializeWork(byte[] workBytes) {
        if (workBytes == null) {
            return null;
        }
        ByteArrayInputStream bain = new ByteArrayInputStream(workBytes);
        try (ObjectInputStream in = new ObjectInputStream(bain);){
            Work work = (Work)in.readObject();
            return work;
        }
        catch (RuntimeException cause) {
            throw cause;
        }
        catch (IOException | ClassNotFoundException cause) {
            throw new RuntimeException("Cannot deserialize work", cause);
        }
    }

    protected Set<String> getSuspendedQueueIds() throws IOException {
        return this.getQueueIds(KEY_SUSPENDED_PREFIX);
    }

    protected Set<String> getScheduledQueueIds() {
        return this.getQueueIds(KEY_QUEUE_PREFIX);
    }

    protected Set<String> getRunningQueueIds() {
        return this.getQueueIds(KEY_RUNNING_PREFIX);
    }

    protected Set<String> getQueueIds(final String queuePrefix) {
        return (Set)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<Set<String>>(){

            public Set<String> call(Jedis jedis) {
                int offset = RedisWorkQueuing.this.keyBytes(queuePrefix).length;
                Set keys = jedis.keys(RedisWorkQueuing.this.keyBytes(RedisWorkQueuing.key(queuePrefix, "*")));
                HashSet<String> queueIds = new HashSet<String>(keys.size());
                for (byte[] bytes : keys) {
                    try {
                        String queueId = new String(bytes, offset, bytes.length - offset, RedisWorkQueuing.UTF_8);
                        queueIds.add(queueId);
                    }
                    catch (IOException e) {
                        throw new NuxeoException((Throwable)e);
                    }
                }
                return queueIds;
            }
        });
    }

    public int scheduleSuspendedWork(final String queueId) throws IOException {
        return (Integer)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<Integer>(){

            public Integer call(Jedis jedis) {
                int n = 0;
                byte[] workIdBytes;
                while ((workIdBytes = jedis.rpoplpush(RedisWorkQueuing.this.suspendedKey(queueId), RedisWorkQueuing.this.queuedKey(queueId))) != null) {
                    ++n;
                }
                return n;
            }
        });
    }

    public int suspendScheduledWork(final String queueId) throws IOException {
        return (Integer)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<Integer>(){

            public Integer call(Jedis jedis) {
                int n = 0;
                byte[] workIdBytes;
                while ((workIdBytes = jedis.rpoplpush(RedisWorkQueuing.this.queuedKey(queueId), RedisWorkQueuing.this.suspendedKey(queueId))) != null) {
                    ++n;
                }
                return n;
            }
        });
    }

    public WorkQueueMetrics metrics(String queueId) {
        return this.metrics(queueId, this.evalSha(this.metricsWorkQueueSha, this.keys(queueId), Collections.emptyList()));
    }

    WorkQueueMetrics metrics(String queueId, Number[] counters) {
        return new WorkQueueMetrics(queueId, counters[0], counters[1], counters[2], counters[3]);
    }

    public void workSetScheduled(String queueId, Work work) throws IOException {
        this.listener.queueChanged(work, this.metrics(queueId, this.evalSha(this.schedulingWorkSha, this.keys(queueId), this.args(work, true))));
    }

    protected void workSetCancelledScheduled(String queueId, Work work) throws IOException {
        this.listener.queueChanged(work, this.metrics(queueId, this.evalSha(this.cancelledScheduledWorkSha, this.keys(queueId), this.args(work, true))));
    }

    protected void workSetRunning(String queueId, Work work) throws IOException {
        this.listener.queueChanged(work, this.metrics(queueId, this.evalSha(this.runningWorkSha, this.keys(queueId), this.args(work, true))));
    }

    protected void workSetCompleted(String queueId, Work work) throws IOException {
        this.listener.queueChanged(work, this.metrics(queueId, this.evalSha(this.completedWorkSha, this.keys(queueId), this.args(work, false))));
    }

    protected void workSetReschedule(String queueId, Work work) throws IOException {
        this.listener.queueChanged(work, this.metrics(queueId, this.evalSha(this.cancelledRunningWorkSha, this.keys(queueId), this.args(work, true))));
    }

    protected List<byte[]> keys(String queueid) {
        return Arrays.asList(this.dataKey(), this.stateKey(), this.countKey(queueid), this.scheduledKey(queueid), this.queuedKey(queueid), this.runningKey(queueid), this.completedKey(queueid), this.canceledKey(queueid));
    }

    protected List<byte[]> args(String workId) throws IOException {
        return Arrays.asList(new byte[][]{this.workId(workId)});
    }

    protected List<byte[]> args(Work work, boolean serialize) throws IOException {
        List<byte[]> args = Arrays.asList(this.workId(work), this.bytes(work.getWorkInstanceState()));
        if (serialize) {
            args = new ArrayList<byte[]>(args);
            args.add(this.serializeWork(work));
        }
        return args;
    }

    protected Work.State getWorkStateInfo(final String workId) {
        final byte[] workIdBytes = this.bytes(workId);
        return (Work.State)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<Work.State>(){

            public Work.State call(Jedis jedis) {
                String msg;
                byte[] bytes = jedis.hget(RedisWorkQueuing.this.stateKey(), workIdBytes);
                if (bytes == null || bytes.length == 0) {
                    return null;
                }
                switch (bytes[0]) {
                    case 81: {
                        return Work.State.SCHEDULED;
                    }
                    case 82: {
                        return Work.State.RUNNING;
                    }
                }
                try {
                    msg = new String(bytes, RedisWorkQueuing.UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    msg = Arrays.toString(bytes);
                }
                log.error((Object)("Unknown work state: " + msg + ", work: " + workId));
                return null;
            }
        });
    }

    protected List<String> listWorkIdsList(final byte[] queueBytes) throws IOException {
        return (List)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<List<String>>(){

            public List<String> call(Jedis jedis) {
                List keys = jedis.lrange(queueBytes, 0L, -1L);
                ArrayList<String> list = new ArrayList<String>(keys.size());
                for (byte[] workIdBytes : keys) {
                    list.add(RedisWorkQueuing.this.string(workIdBytes));
                }
                return list;
            }
        });
    }

    protected List<String> listWorkIdsSet(final byte[] queueBytes) throws IOException {
        return (List)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<List<String>>(){

            public List<String> call(Jedis jedis) {
                Set keys = jedis.smembers(queueBytes);
                ArrayList<String> list = new ArrayList<String>(keys.size());
                for (byte[] workIdBytes : keys) {
                    list.add(RedisWorkQueuing.this.string(workIdBytes));
                }
                return list;
            }
        });
    }

    protected List<Work> listWorkList(final byte[] queueBytes) throws IOException {
        return (List)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<List<Work>>(){

            public List<Work> call(Jedis jedis) {
                List keys = jedis.lrange(queueBytes, 0L, -1L);
                ArrayList<Work> list = new ArrayList<Work>(keys.size());
                for (byte[] workIdBytes : keys) {
                    byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                    Work work = RedisWorkQueuing.this.deserializeWork(workBytes);
                    list.add(work);
                }
                return list;
            }
        });
    }

    protected List<Work> listWorkSet(final byte[] queueBytes) throws IOException {
        return (List)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<List<Work>>(){

            public List<Work> call(Jedis jedis) {
                Set keys = jedis.smembers(queueBytes);
                ArrayList<Work> list = new ArrayList<Work>(keys.size());
                for (byte[] workIdBytes : keys) {
                    byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                    Work work = RedisWorkQueuing.this.deserializeWork(workBytes);
                    list.add(work);
                }
                return list;
            }
        });
    }

    protected Work getWork(byte[] workIdBytes) {
        try {
            return this.getWorkData(workIdBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Work getWorkData(final byte[] workIdBytes) throws IOException {
        return (Work)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<Work>(){

            public Work call(Jedis jedis) {
                byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                return RedisWorkQueuing.this.deserializeWork(workBytes);
            }
        });
    }

    protected Work getWorkFromQueue(String queueId) throws IOException {
        List<byte[]> args;
        List<byte[]> keys;
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        List result = (List)redisExecutor.evalsha(this.popWorkSha, keys = this.keys(queueId), args = Collections.singletonList(STATE_RUNNING));
        if (result == null) {
            return null;
        }
        List numbers = (List)result.get(0);
        WorkQueueMetrics metrics = this.metrics(queueId, RedisWorkQueuing.coerceNullToZero(numbers));
        Object bytes = result.get(1);
        if (bytes instanceof String) {
            bytes = this.bytes((String)bytes);
        }
        Work work = this.deserializeWork((byte[])bytes);
        this.listener.queueChanged(work, metrics);
        return work;
    }

    protected void removeScheduledWork(String queueId, String workId) throws IOException {
        this.evalSha(this.cancelledScheduledWorkSha, this.keys(queueId), this.args(workId));
    }

    Number[] evalSha(byte[] sha, List<byte[]> keys, List<byte[]> args) throws JedisException {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        List numbers = (List)redisExecutor.evalsha(sha, keys, args);
        return RedisWorkQueuing.coerceNullToZero(numbers);
    }

    protected static Number[] coerceNullToZero(List<Number> numbers) {
        return RedisWorkQueuing.coerceNullToZero(numbers.toArray(new Number[numbers.size()]));
    }

    protected static Number[] coerceNullToZero(Number[] counters) {
        for (int i = 0; i < counters.length; ++i) {
            if (counters[i] != null) continue;
            counters[i] = 0;
        }
        return counters;
    }

    public void listen(WorkQueuing.Listener listener) {
        this.listener = listener;
    }

    public static class SScanner {
        protected List<String> smembers;

        protected ScanResult<String> sscan(Jedis jedis, String key, String cursor, ScanParams params) {
            ScanResult scanResult;
            block6: {
                try {
                    scanResult = jedis.sscan(key, cursor, params);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof NoSuchMethodException)) {
                        throw e;
                    }
                    if (this.smembers == null) {
                        Set set = jedis.smembers(key);
                        this.smembers = new ArrayList<String>(set);
                    }
                    Collection bparams = params.getParams();
                    int count = 1000;
                    Iterator it = bparams.iterator();
                    while (it.hasNext()) {
                        byte[] param = (byte[])it.next();
                        if (param.equals(Protocol.Keyword.MATCH.raw)) {
                            throw new UnsupportedOperationException("MATCH not supported");
                        }
                        if (!param.equals(Protocol.Keyword.COUNT.raw)) continue;
                        count = Integer.parseInt(SafeEncoder.encode((byte[])((byte[])it.next())));
                    }
                    int pos = Integer.parseInt(cursor);
                    int end = Math.min(pos + count, this.smembers.size());
                    int nextPos = end == this.smembers.size() ? 0 : end;
                    scanResult = new ScanResult(String.valueOf(nextPos), this.smembers.subList(pos, end));
                    if (nextPos != 0) break block6;
                    this.smembers = null;
                }
            }
            return scanResult;
        }
    }
}

