/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.io;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ThumbnailJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "thumbnail";
    public static final String THUMBNAIL_URL_LABEL = "url";
    public static final String THUMBNAIL_URL_PATTERN = "%s/api/v1/repo/%s/id/%s/@rendition/thumbnail";

    public ThumbnailJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeFieldName(NAME);
        jg.writeStartObject();
        jg.writeStringField(THUMBNAIL_URL_LABEL, String.format(THUMBNAIL_URL_PATTERN, this.ctx.getBaseUrl().replaceAll("/$", ""), document.getRepositoryName(), document.getId()));
        jg.writeEndObject();
    }
}

