/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.listener;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.thumbnail.ThumbnailConstants;
import org.nuxeo.runtime.api.Framework;

public class CheckBlobUpdateListener
implements EventListener {
    public void handleEvent(Event event) {
        EventContext ec = event.getContext();
        if (!(ec instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext context = (DocumentEventContext)ec;
        DocumentModel doc = context.getSourceDocument();
        if (!doc.hasSchema("file")) {
            return;
        }
        Property content = doc.getProperty("file:content");
        if ("documentCreated".equals(event.getName()) || content.isDirty()) {
            if ("beforeDocumentModification".equals(event.getName()) && doc.hasFacet("Thumbnail")) {
                doc.setPropertyValue("thumb:thumbnail", null);
            }
            if (content.getValue() != null) {
                doc.addFacet("Thumbnail");
                ((EventService)Framework.getService(EventService.class)).fireEvent(ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name(), (EventContext)context);
            }
        }
    }
}

