/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.localeProvider;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.web.common.locale.DefaultLocaleProvider;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

public class UserLocaleProvider
extends DefaultLocaleProvider {
    public static final Log log = LogFactory.getLog(UserLocaleProvider.class);

    public Locale getLocale(CoreSession repo) {
        try {
            UserProfileService userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
            DocumentModel userProfileDoc = userProfileService.getUserProfileDocument(repo);
            return this.getLocale(userProfileDoc);
        }
        catch (Exception ex) {
            log.error((Object)"Can't get Locale", (Throwable)ex);
            return null;
        }
    }

    public Locale getLocale(DocumentModel userProfileDoc) {
        if (userProfileDoc == null) {
            return null;
        }
        String locale = (String)((Object)userProfileDoc.getPropertyValue("userprofile:locale"));
        if (locale == null || locale.trim().length() == 0) {
            return null;
        }
        try {
            return LocaleUtils.toLocale((String)locale);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Locale parse exception:  \"" + locale + "\""), (Throwable)e);
            return null;
        }
    }

    public TimeZone getTimeZone(CoreSession repo) {
        return null;
    }

    public Locale getLocaleWithDefault(CoreSession session) {
        Locale locale = this.getLocale(session);
        return locale == null ? this.getDefaultLocale() : locale;
    }

    public Locale getLocaleWithDefault(DocumentModel userProfileDoc) {
        Locale locale = this.getLocale(userProfileDoc);
        return locale == null ? this.getDefaultLocale() : locale;
    }
}

